/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cloneworkspace;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.WorkspaceSnapshot;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.plugins.cloneworkspace.CloneWorkspacePublisher;
import hudson.plugins.cloneworkspace.CloneWorkspaceUtil;
import hudson.plugins.cloneworkspace.Messages;
import hudson.scm.ChangeLogParser;
import hudson.scm.PollingResult;
import hudson.scm.SCM;
import hudson.scm.SCMDescriptor;
import hudson.scm.SCMRevisionState;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CloneWorkspaceSCM
extends SCM {
    public String parentJobName;
    public String criteria;
    private static final Logger LOGGER = Logger.getLogger(CloneWorkspaceSCM.class.getName());

    @DataBoundConstructor
    public CloneWorkspaceSCM(String parentJobName, String criteria) {
        this.parentJobName = parentJobName;
        this.criteria = criteria;
    }

    public Snapshot resolve() throws ResolvedFailedException {
        Hudson h = Hudson.getInstance();
        AbstractProject job = (AbstractProject)h.getItemByFullName(this.parentJobName, AbstractProject.class);
        if (job == null) {
            if (h.getItemByFullName(this.parentJobName) == null) {
                AbstractProject nearest = AbstractProject.findNearest((String)this.parentJobName);
                throw new ResolvedFailedException(Messages.CloneWorkspaceSCM_NoSuchJob(this.parentJobName, nearest.getFullName()));
            }
            throw new ResolvedFailedException(Messages.CloneWorkspaceSCM_IncorrectJobType(this.parentJobName));
        }
        AbstractBuild<?, ?> b = CloneWorkspaceUtil.getMostRecentBuildForCriteria(job, this.criteria);
        if (b == null) {
            throw new ResolvedFailedException(Messages.CloneWorkspaceSCM_NoBuild(this.criteria, this.parentJobName));
        }
        WorkspaceSnapshot snapshot = (WorkspaceSnapshot)b.getAction(WorkspaceSnapshot.class);
        if (snapshot == null) {
            throw new ResolvedFailedException(Messages.CloneWorkspaceSCM_NoWorkspace(this.parentJobName, this.criteria));
        }
        return new Snapshot(snapshot, b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkout(AbstractBuild build, Launcher launcher, FilePath workspace, BuildListener listener, File changelogFile) throws IOException, InterruptedException {
        try {
            workspace.deleteContents();
            this.resolve().restoreTo(workspace, (TaskListener)listener);
            PrintWriter w = new PrintWriter(new FileOutputStream(CloneWorkspaceSCM.getParentBuildFile(build)));
            try {
                w.println(this.resolve().getParent().getNumber());
            }
            finally {
                w.close();
            }
            return this.calcChangeLog(this.resolve().getParent(), changelogFile, listener);
        }
        catch (ResolvedFailedException e) {
            listener.error(e.getMessage());
            build.setResult(Result.FAILURE);
            return false;
        }
    }

    private boolean calcChangeLog(AbstractBuild<?, ?> parentBuild, File changelogFile, BuildListener listener) throws IOException, InterruptedException {
        FilePath parentChangeLog = new FilePath(new File(parentBuild.getRootDir(), "changelog.xml"));
        if (parentChangeLog.exists()) {
            FilePath childChangeLog = new FilePath(changelogFile);
            parentChangeLog.copyTo(childChangeLog);
        } else {
            this.createEmptyChangeLog(changelogFile, listener, "log");
        }
        return true;
    }

    public ChangeLogParser createChangeLogParser() {
        try {
            return this.resolve().getParent().getProject().getScm().createChangeLogParser();
        }
        catch (ResolvedFailedException e) {
            return null;
        }
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public static File getParentBuildFile(AbstractBuild b) {
        return new File(b.getRootDir(), "cloneWorkspaceParent.txt");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int parseParentBuildFile(AbstractBuild<?, ?> build, boolean findClosest) throws IOException {
        File file;
        int parentBuildNumber = 0;
        if (build == null) {
            return parentBuildNumber;
        }
        if (findClosest) {
            for (AbstractBuild b = build; b != null; b = (AbstractBuild)b.getPreviousBuild()) {
                if (!CloneWorkspaceSCM.getParentBuildFile(b).exists()) continue;
                build = b;
                break;
            }
        }
        if (!(file = CloneWorkspaceSCM.getParentBuildFile(build)).exists()) {
            return parentBuildNumber;
        }
        BufferedReader br = new BufferedReader(new FileReader(file));
        try {
            String line;
            while ((line = br.readLine()) != null) {
                try {
                    parentBuildNumber = Integer.parseInt(Util.fixEmptyAndTrim((String)line));
                }
                catch (NumberFormatException e) {}
            }
        }
        finally {
            br.close();
        }
        return parentBuildNumber;
    }

    public SCMRevisionState calcRevisionsFromBuild(AbstractBuild build, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        int parentBuildNumber = this.parseParentBuildFile(build, true);
        return new CloneWorkspaceSCMRevisionState(parentBuildNumber);
    }

    protected PollingResult compareRemoteRevisionWith(AbstractProject<?, ?> project, Launcher launcher, FilePath workspace, TaskListener listener, SCMRevisionState _baseline) throws IOException, InterruptedException {
        Hudson h = Hudson.getInstance();
        AbstractProject parentProject = (AbstractProject)h.getItemByFullName(this.parentJobName, AbstractProject.class);
        if (parentProject == null) {
            listener.getLogger().println("The CloneWorkspace parent project for " + project + " does not exist, project will be disabled.");
            project.makeDisabled(true);
            return new PollingResult(_baseline, _baseline, PollingResult.Change.NONE);
        }
        CloneWorkspaceSCMRevisionState baseline = (CloneWorkspaceSCMRevisionState)_baseline;
        Snapshot s = null;
        try {
            s = this.resolve();
        }
        catch (ResolvedFailedException e) {
            listener.getLogger().println(e.getMessage());
            return new PollingResult((SCMRevisionState)baseline, (SCMRevisionState)baseline, PollingResult.Change.NONE);
        }
        if (s == null) {
            listener.getLogger().println("Snapshot failed to resolve for unknown reasons.");
            return new PollingResult((SCMRevisionState)baseline, (SCMRevisionState)baseline, PollingResult.Change.NONE);
        }
        if (s.getParent().getNumber() > baseline.parentBuildNumber) {
            listener.getLogger().println("Build #" + s.getParent().getNumber() + " of project " + this.parentJobName + " is newer than build #" + baseline.parentBuildNumber + ", so a new build of " + project + " will be run.");
            return new PollingResult((SCMRevisionState)baseline, (SCMRevisionState)new CloneWorkspaceSCMRevisionState(s.getParent().getNumber()), PollingResult.Change.SIGNIFICANT);
        }
        listener.getLogger().println("Build #" + s.getParent().getNumber() + " of project " + this.parentJobName + " is NOT newer than build #" + baseline.parentBuildNumber + ", so no new build of " + project + " will be run.");
        return new PollingResult((SCMRevisionState)baseline, (SCMRevisionState)baseline, PollingResult.Change.NONE);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Snapshot {
        final WorkspaceSnapshot snapshot;
        final AbstractBuild<?, ?> parent;

        private Snapshot(WorkspaceSnapshot snapshot, AbstractBuild<?, ?> parent) {
            this.snapshot = snapshot;
            this.parent = parent;
        }

        void restoreTo(FilePath dst, TaskListener listener) throws IOException, InterruptedException {
            this.snapshot.restoreTo(this.parent, dst, listener);
        }

        AbstractBuild<?, ?> getParent() {
            return this.parent;
        }
    }

    private final class ResolvedFailedException
    extends Exception {
        private ResolvedFailedException(String message) {
            super(message);
        }
    }

    public final class CloneWorkspaceSCMRevisionState
    extends SCMRevisionState
    implements Serializable {
        final int parentBuildNumber;
        private static final long serialVersionUID = 1L;

        CloneWorkspaceSCMRevisionState(int parentBuildNumber) {
            this.parentBuildNumber = parentBuildNumber;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class DescriptorImpl
    extends SCMDescriptor<CloneWorkspaceSCM> {
        public DescriptorImpl() {
            super(CloneWorkspaceSCM.class, null);
            this.load();
        }

        public String getDisplayName() {
            return "Clone Workspace";
        }

        public SCM newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return (SCM)req.bindJSON(CloneWorkspaceSCM.class, formData);
        }

        public List<String> getEligibleParents() {
            ArrayList<String> parentNames = new ArrayList<String>();
            for (AbstractProject p : Hudson.getInstance().getItems(AbstractProject.class)) {
                if (p.getPublishersList().get(CloneWorkspacePublisher.class) == null) continue;
                parentNames.add(p.getDisplayName());
            }
            return parentNames;
        }
    }
}

