/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cloneworkspace;

import hudson.FilePath;
import hudson.FileSystemProvisioner;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.plugins.cloneworkspace.CloneWorkspacePublisher;
import hudson.plugins.cloneworkspace.CloneWorkspaceUtil;
import hudson.plugins.cloneworkspace.Messages;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Recorder;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CloneWorkspacePublisher
extends Recorder {
    private final String workspaceGlob;
    private final String criteria;
    private static final Logger LOGGER = Logger.getLogger(CloneWorkspacePublisher.class.getName());

    @DataBoundConstructor
    public CloneWorkspacePublisher(String workspaceGlob, String criteria) {
        this.workspaceGlob = workspaceGlob.trim();
        this.criteria = criteria;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public String getWorkspaceGlob() {
        return this.workspaceGlob;
    }

    public String getCriteria() {
        return this.criteria;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException {
        String realGlob;
        Result criteriaResult = CloneWorkspaceUtil.getResultForCriteria((String)this.criteria);
        if (this.workspaceGlob.length() == 0) {
            realGlob = "**/*";
        } else {
            try {
                realGlob = build.getEnvironment((TaskListener)listener).expand(this.workspaceGlob);
            }
            catch (IOException e) {
                realGlob = this.workspaceGlob;
            }
        }
        if (build.getResult().isBetterOrEqualTo(criteriaResult)) {
            listener.getLogger().println(Messages.CloneWorkspacePublisher_ArchivingWorkspace());
            FilePath ws = build.getWorkspace();
            if (ws == null) {
                return true;
            }
            try {
                String msg = ws.validateAntFileMask(realGlob);
                if (msg == null) {
                    build.addAction((Action)FileSystemProvisioner.DEFAULT.snapshot(build, ws, realGlob, (TaskListener)listener));
                    AbstractBuild previousArchivedBuild = CloneWorkspaceUtil.getMostRecentBuildForCriteriaWithSnapshot((AbstractBuild)((AbstractBuild)build.getPreviousBuild()), (String)this.criteria);
                    if (previousArchivedBuild != null) {
                        listener.getLogger().println(Messages.CloneWorkspacePublisher_DeletingOld((Object)previousArchivedBuild.getDisplayName()));
                        try {
                            File oldWss = new File(previousArchivedBuild.getRootDir(), "workspace.zip");
                            Util.deleteFile((File)oldWss);
                        }
                        catch (IOException e) {
                            e.printStackTrace(listener.error(e.getMessage()));
                        }
                    }
                    return true;
                }
                listener.getLogger().println(Messages.CloneWorkspacePublisher_NoMatchFound((Object)realGlob, (Object)msg));
                return true;
            }
            catch (IOException e) {
                Util.displayIOException((IOException)e, (TaskListener)listener);
                e.printStackTrace(listener.error(Messages.CloneWorkspacePublisher_FailedToArchive((Object)realGlob)));
                return true;
            }
            catch (InterruptedException e) {
                e.printStackTrace(listener.error(Messages.CloneWorkspacePublisher_FailedToArchive((Object)realGlob)));
                return true;
            }
        }
        listener.getLogger().println(Messages.CloneWorkspacePublisher_CriteriaNotMet((Object)criteriaResult));
        return true;
    }
}

