/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clover.results;

import hudson.model.Build;
import hudson.model.Run;
import hudson.plugins.clover.CloverBuildAction;
import hudson.plugins.clover.results.AbstractCloverMetrics;
import hudson.plugins.clover.results.AbstractFileAggregatedMetrics;
import hudson.plugins.clover.results.ClassCoverage;
import hudson.plugins.clover.results.FileCoverage;
import hudson.plugins.clover.results.PackageCoverage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageCoverage
extends AbstractFileAggregatedMetrics {
    private List<FileCoverage> fileCoverages = new ArrayList();

    public List<FileCoverage> getChildren() {
        return this.getFileCoverages();
    }

    public boolean addFileCoverage(FileCoverage result) {
        return this.fileCoverages.add(result);
    }

    public List<FileCoverage> getFileCoverages() {
        return this.fileCoverages;
    }

    public FileCoverage findFileCoverage(String name) {
        for (FileCoverage i : this.fileCoverages) {
            if (!name.equals(i.getName())) continue;
            return i;
        }
        return null;
    }

    public ClassCoverage findClassCoverage(String name) {
        for (FileCoverage i : this.fileCoverages) {
            ClassCoverage j = i.findClassCoverage(name);
            if (j == null) continue;
            return j;
        }
        return null;
    }

    public Object getDynamic(String token, StaplerRequest req, StaplerResponse rsp) throws IOException {
        boolean isPath = false;
        for (FileCoverage i : this.fileCoverages) {
            if (i.getName().equals(token)) {
                return i;
            }
            if (!i.getName().startsWith(token)) continue;
            isPath = true;
            break;
        }
        if (isPath) {
            return new FilePathMapper(this, token + '/');
        }
        return null;
    }

    public AbstractCloverMetrics getPreviousResult() {
        if (this.owner == null) {
            return null;
        }
        Run prevBuild = this.owner.getPreviousBuild();
        if (prevBuild == null) {
            return null;
        }
        CloverBuildAction action = (CloverBuildAction)prevBuild.getAction(CloverBuildAction.class);
        if (action == null) {
            return null;
        }
        return action.findPackageCoverage(this.getName());
    }

    public void setOwner(Build owner) {
        super.setOwner(owner);
        for (FileCoverage fileCoverage : this.fileCoverages) {
            fileCoverage.setOwner(owner);
        }
    }

    static /* synthetic */ List access$000(PackageCoverage x0) {
        return x0.fileCoverages;
    }
}

