/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clover;

import hudson.model.Build;
import hudson.model.HealthReport;
import hudson.model.HealthReportingAction;
import hudson.model.Result;
import hudson.plugins.clover.CloverCoverageParser;
import hudson.plugins.clover.CloverPublisher;
import hudson.plugins.clover.Ratio;
import hudson.plugins.clover.results.AbstractPackageAggregatedMetrics;
import hudson.plugins.clover.results.ClassCoverage;
import hudson.plugins.clover.results.FileCoverage;
import hudson.plugins.clover.results.PackageCoverage;
import hudson.plugins.clover.results.ProjectCoverage;
import hudson.plugins.clover.targets.CoverageMetric;
import hudson.plugins.clover.targets.CoverageTarget;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.stapler.StaplerProxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CloverBuildAction
extends AbstractPackageAggregatedMetrics
implements HealthReportingAction,
StaplerProxy {
    public final Build owner;
    private String buildBaseDir;
    private CoverageTarget healthyTarget;
    private CoverageTarget unhealthyTarget;
    private transient WeakReference<ProjectCoverage> report;
    private static final Logger logger = Logger.getLogger(CloverBuildAction.class.getName());

    public HealthReport getBuildHealth() {
        if (this.healthyTarget == null || this.unhealthyTarget == null) {
            return null;
        }
        ProjectCoverage projectCoverage = this.getResult();
        Map<CoverageMetric, Integer> scores = this.healthyTarget.getRangeScores(this.unhealthyTarget, projectCoverage);
        int minValue = 100;
        Enum minKey = null;
        for (Map.Entry<CoverageMetric, Integer> e : scores.entrySet()) {
            if (e.getValue() >= minValue) continue;
            minKey = e.getKey();
            minValue = e.getValue();
        }
        if (minKey == null) {
            return null;
        }
        StringBuilder description = new StringBuilder("Clover Coverage: ");
        switch (1.$SwitchMap$hudson$plugins$clover$targets$CoverageMetric[minKey.ordinal()]) {
            case 1: {
                description.append("Methods ");
                description.append(projectCoverage.getMethodCoverage().getPercentage());
                description.append("% (");
                description.append(projectCoverage.getMethodCoverage().toString());
                description.append(")");
                break;
            }
            case 2: {
                description.append("Conditionals ");
                description.append(projectCoverage.getConditionalCoverage().getPercentage());
                description.append("% (");
                description.append(projectCoverage.getConditionalCoverage().toString());
                description.append(")");
                break;
            }
            case 3: {
                description.append("Statements ");
                description.append(projectCoverage.getStatementCoverage().getPercentage());
                description.append("% (");
                description.append(projectCoverage.getStatementCoverage().toString());
                description.append(")");
                break;
            }
            case 4: {
                description.append("Elements ");
                description.append(projectCoverage.getElementCoverage().getPercentage());
                description.append("% (");
                description.append(projectCoverage.getElementCoverage().toString());
                description.append(")");
                break;
            }
            default: {
                return null;
            }
        }
        return new HealthReport(minValue, description.toString());
    }

    public String getIconFileName() {
        return "graph.gif";
    }

    public String getDisplayName() {
        return "Coverage Report";
    }

    public String getUrlName() {
        return "clover";
    }

    public Object getTarget() {
        return this.getResult();
    }

    @Override
    public CloverBuildAction getPreviousResult() {
        return CloverBuildAction.getPreviousResult(this.owner);
    }

    static CloverBuildAction getPreviousResult(Build start) {
        CloverBuildAction r;
        Build b = start;
        do {
            if ((b = (Build)b.getPreviousBuild()) != null) continue;
            return null;
        } while (b.getResult() == Result.FAILURE || (r = (CloverBuildAction)b.getAction(CloverBuildAction.class)) == null);
        return r;
    }

    CloverBuildAction(Build owner, String workspacePath, ProjectCoverage r, CoverageTarget healthyTarget, CoverageTarget unhealthyTarget) {
        this.owner = owner;
        this.report = new WeakReference<ProjectCoverage>(r);
        this.buildBaseDir = workspacePath;
        if (this.buildBaseDir == null) {
            this.buildBaseDir = File.separator;
        } else if (!this.buildBaseDir.endsWith(File.separator)) {
            this.buildBaseDir = this.buildBaseDir + File.separator;
        }
        this.healthyTarget = healthyTarget;
        this.unhealthyTarget = unhealthyTarget;
        r.setOwner(owner);
    }

    public synchronized ProjectCoverage getResult() {
        ProjectCoverage r;
        if (this.report != null && (r = (ProjectCoverage)this.report.get()) != null) {
            return r;
        }
        File reportFile = CloverPublisher.getCloverReport(this.owner);
        try {
            ProjectCoverage r2 = CloverCoverageParser.parse(reportFile, this.buildBaseDir);
            r2.setOwner(this.owner);
            this.report = new WeakReference<ProjectCoverage>(r2);
            return r2;
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Failed to load " + reportFile, e);
            return null;
        }
    }

    @Override
    public PackageCoverage findPackageCoverage(String name) {
        return this.getResult().findPackageCoverage(name);
    }

    @Override
    public FileCoverage findFileCoverage(String name) {
        return this.getResult().findFileCoverage(name);
    }

    @Override
    public ClassCoverage findClassCoverage(String name) {
        return this.getResult().findClassCoverage(name);
    }

    @Override
    public int getPackages() {
        return this.getResult().getPackages();
    }

    @Override
    public int getFiles() {
        return this.getResult().getFiles();
    }

    @Override
    public int getClasses() {
        return this.getResult().getClasses();
    }

    @Override
    public int getLoc() {
        return this.getResult().getLoc();
    }

    @Override
    public int getNcloc() {
        return this.getResult().getNcloc();
    }

    @Override
    public Ratio getMethodCoverage() {
        return this.getResult().getMethodCoverage();
    }

    @Override
    public Ratio getStatementCoverage() {
        return this.getResult().getStatementCoverage();
    }

    @Override
    public Ratio getConditionalCoverage() {
        return this.getResult().getConditionalCoverage();
    }

    @Override
    public Ratio getElementCoverage() {
        return this.getResult().getElementCoverage();
    }

    @Override
    public int getConditionals() {
        return this.getResult().getConditionals();
    }

    @Override
    public int getMethods() {
        return this.getResult().getMethods();
    }

    @Override
    public int getCoveredstatements() {
        return this.getResult().getCoveredstatements();
    }

    @Override
    public int getCoveredmethods() {
        return this.getResult().getCoveredmethods();
    }

    @Override
    public int getCoveredconditionals() {
        return this.getResult().getCoveredconditionals();
    }

    @Override
    public int getStatements() {
        return this.getResult().getStatements();
    }

    @Override
    public int getCoveredelements() {
        return this.getResult().getCoveredelements();
    }

    @Override
    public int getElements() {
        return this.getResult().getElements();
    }

    public static CloverBuildAction load(Build<?, ?> build, String workspacePath, ProjectCoverage result, CoverageTarget healthyTarget, CoverageTarget unhealthyTarget) {
        return new CloverBuildAction(build, workspacePath, result, healthyTarget, unhealthyTarget);
    }

    static class 1 {
        static final /* synthetic */ int[] $SwitchMap$hudson$plugins$clover$targets$CoverageMetric;

        static {
            $SwitchMap$hudson$plugins$clover$targets$CoverageMetric = new int[CoverageMetric.values().length];
            try {
                1.$SwitchMap$hudson$plugins$clover$targets$CoverageMetric[CoverageMetric.METHOD.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$hudson$plugins$clover$targets$CoverageMetric[CoverageMetric.CONDITIONAL.ordinal()] = 2;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$hudson$plugins$clover$targets$CoverageMetric[CoverageMetric.STATEMENT.ordinal()] = 3;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$hudson$plugins$clover$targets$CoverageMetric[CoverageMetric.ELEMENT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }
}

