/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clover;

import hudson.model.AbstractBuild;
import hudson.model.HealthReport;
import hudson.model.HealthReportingAction;
import hudson.model.Result;
import hudson.plugins.clover.CloverBuildAction;
import hudson.plugins.clover.CloverCoverageParser;
import hudson.plugins.clover.CloverPublisher;
import hudson.plugins.clover.Ratio;
import hudson.plugins.clover.results.AbstractCloverMetrics;
import hudson.plugins.clover.results.AbstractPackageAggregatedMetrics;
import hudson.plugins.clover.results.ClassCoverage;
import hudson.plugins.clover.results.FileCoverage;
import hudson.plugins.clover.results.PackageCoverage;
import hudson.plugins.clover.results.ProjectCoverage;
import hudson.plugins.clover.targets.CoverageMetric;
import hudson.plugins.clover.targets.CoverageTarget;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.stapler.StaplerProxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class CloverBuildAction
extends AbstractPackageAggregatedMetrics
implements HealthReportingAction,
StaplerProxy {
    public final AbstractBuild owner;
    private String buildBaseDir;
    private CoverageTarget healthyTarget;
    private CoverageTarget unhealthyTarget;
    private transient WeakReference<ProjectCoverage> report;
    private static final Logger logger = Logger.getLogger(CloverBuildAction.class.getName());

    public HealthReport getBuildHealth() {
        if (this.healthyTarget == null || this.unhealthyTarget == null) {
            return null;
        }
        ProjectCoverage projectCoverage = this.getResult();
        Map scores = this.healthyTarget.getRangeScores(this.unhealthyTarget, (AbstractCloverMetrics)projectCoverage);
        int minValue = 100;
        CoverageMetric minKey = null;
        for (Map.Entry e : scores.entrySet()) {
            if ((Integer)e.getValue() >= minValue) continue;
            minKey = (CoverageMetric)e.getKey();
            minValue = (Integer)e.getValue();
        }
        if (minKey == null) {
            return null;
        }
        StringBuilder description = new StringBuilder("Clover Coverage: ");
        switch (1.$SwitchMap$hudson$plugins$clover$targets$CoverageMetric[minKey.ordinal()]) {
            case 1: {
                description.append("Methods ");
                description.append(projectCoverage.getMethodCoverage().getPercentage());
                description.append("% (");
                description.append(projectCoverage.getMethodCoverage().toString());
                description.append(")");
                break;
            }
            case 2: {
                description.append("Conditionals ");
                description.append(projectCoverage.getConditionalCoverage().getPercentage());
                description.append("% (");
                description.append(projectCoverage.getConditionalCoverage().toString());
                description.append(")");
                break;
            }
            case 3: {
                description.append("Statements ");
                description.append(projectCoverage.getStatementCoverage().getPercentage());
                description.append("% (");
                description.append(projectCoverage.getStatementCoverage().toString());
                description.append(")");
                break;
            }
            case 4: {
                description.append("Elements ");
                description.append(projectCoverage.getElementCoverage().getPercentage());
                description.append("% (");
                description.append(projectCoverage.getElementCoverage().toString());
                description.append(")");
                break;
            }
            default: {
                return null;
            }
        }
        return new HealthReport(minValue, description.toString());
    }

    public String getIconFileName() {
        return "graph.gif";
    }

    public String getDisplayName() {
        return "Coverage Report";
    }

    public String getUrlName() {
        return "clover";
    }

    public Object getTarget() {
        return this.getResult();
    }

    public CloverBuildAction getPreviousResult() {
        return CloverBuildAction.getPreviousResult((AbstractBuild)this.owner);
    }

    static CloverBuildAction getPreviousResult(AbstractBuild start) {
        CloverBuildAction r;
        AbstractBuild b = start;
        do {
            if ((b = (AbstractBuild)b.getPreviousBuild()) != null) continue;
            return null;
        } while (b.getResult() == Result.FAILURE || (r = (CloverBuildAction)b.getAction(CloverBuildAction.class)) == null);
        return r;
    }

    CloverBuildAction(AbstractBuild owner, String workspacePath, ProjectCoverage r, CoverageTarget healthyTarget, CoverageTarget unhealthyTarget) {
        this.owner = owner;
        this.report = new WeakReference<ProjectCoverage>(r);
        this.buildBaseDir = workspacePath;
        if (this.buildBaseDir == null) {
            this.buildBaseDir = File.separator;
        } else if (!this.buildBaseDir.endsWith(File.separator)) {
            this.buildBaseDir = this.buildBaseDir + File.separator;
        }
        this.healthyTarget = healthyTarget;
        this.unhealthyTarget = unhealthyTarget;
        r.setOwner(owner);
    }

    public synchronized ProjectCoverage getResult() {
        ProjectCoverage r;
        if (this.report != null && (r = (ProjectCoverage)this.report.get()) != null) {
            return r;
        }
        File reportFile = CloverPublisher.getCloverReport((AbstractBuild)this.owner);
        try {
            ProjectCoverage r2 = CloverCoverageParser.parse((File)reportFile, (String)this.buildBaseDir);
            r2.setOwner(this.owner);
            this.report = new WeakReference<ProjectCoverage>(r2);
            return r2;
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Failed to load " + reportFile, e);
            return null;
        }
    }

    public PackageCoverage findPackageCoverage(String name) {
        return this.getResult().findPackageCoverage(name);
    }

    public FileCoverage findFileCoverage(String name) {
        return this.getResult().findFileCoverage(name);
    }

    public ClassCoverage findClassCoverage(String name) {
        return this.getResult().findClassCoverage(name);
    }

    public int getPackages() {
        return this.getResult().getPackages();
    }

    public int getFiles() {
        return this.getResult().getFiles();
    }

    public int getClasses() {
        return this.getResult().getClasses();
    }

    public int getLoc() {
        return this.getResult().getLoc();
    }

    public int getNcloc() {
        return this.getResult().getNcloc();
    }

    public Ratio getMethodCoverage() {
        return this.getResult().getMethodCoverage();
    }

    public Ratio getStatementCoverage() {
        return this.getResult().getStatementCoverage();
    }

    public Ratio getConditionalCoverage() {
        return this.getResult().getConditionalCoverage();
    }

    public Ratio getElementCoverage() {
        return this.getResult().getElementCoverage();
    }

    public int getConditionals() {
        return this.getResult().getConditionals();
    }

    public int getMethods() {
        return this.getResult().getMethods();
    }

    public int getCoveredstatements() {
        return this.getResult().getCoveredstatements();
    }

    public int getCoveredmethods() {
        return this.getResult().getCoveredmethods();
    }

    public int getCoveredconditionals() {
        return this.getResult().getCoveredconditionals();
    }

    public int getStatements() {
        return this.getResult().getStatements();
    }

    public int getCoveredelements() {
        return this.getResult().getCoveredelements();
    }

    public int getElements() {
        return this.getResult().getElements();
    }

    public static CloverBuildAction load(AbstractBuild<?, ?> build, String workspacePath, ProjectCoverage result, CoverageTarget healthyTarget, CoverageTarget unhealthyTarget) {
        return new CloverBuildAction(build, workspacePath, result, healthyTarget, unhealthyTarget);
    }
}

