/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clover.results;

import hudson.model.AbstractBuild;
import hudson.plugins.clover.Ratio;
import hudson.util.ChartUtil;
import hudson.util.ColorPalette;
import hudson.util.DataSetBuilder;
import hudson.util.ShiftedCategoryAxis;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.io.IOException;
import java.util.Calendar;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.data.category.CategoryDataset;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public abstract class AbstractCloverMetrics {
    private String name;
    private int methods;
    private int coveredmethods;
    private int conditionals;
    private int coveredconditionals;
    private int statements;
    private int coveredstatements;
    private int elements;
    private int coveredelements;
    public AbstractBuild owner = null;

    public Ratio getMethodCoverage() {
        return Ratio.create((float)this.coveredmethods, (float)this.methods);
    }

    public Ratio getConditionalCoverage() {
        return Ratio.create((float)this.coveredconditionals, (float)this.conditionals);
    }

    public Ratio getStatementCoverage() {
        return Ratio.create((float)this.coveredstatements, (float)this.statements);
    }

    public Ratio getElementCoverage() {
        return Ratio.create((float)this.coveredelements, (float)this.elements);
    }

    public int getConditionals() {
        return this.conditionals;
    }

    public void setConditionals(int conditionals) {
        this.conditionals = conditionals;
    }

    public int getMethods() {
        return this.methods;
    }

    public void setMethods(int methods) {
        this.methods = methods;
    }

    public int getCoveredstatements() {
        return this.coveredstatements;
    }

    public void setCoveredstatements(int coveredstatements) {
        this.coveredstatements = coveredstatements;
    }

    public int getCoveredmethods() {
        return this.coveredmethods;
    }

    public void setCoveredmethods(int coveredmethods) {
        this.coveredmethods = coveredmethods;
    }

    public int getCoveredconditionals() {
        return this.coveredconditionals;
    }

    public void setCoveredconditionals(int coveredconditionals) {
        this.coveredconditionals = coveredconditionals;
    }

    public int getStatements() {
        return this.statements;
    }

    public void setStatements(int statements) {
        this.statements = statements;
    }

    public int getCoveredelements() {
        return this.coveredelements;
    }

    public void setCoveredelements(int coveredelements) {
        this.coveredelements = coveredelements;
    }

    public int getElements() {
        return this.elements;
    }

    public void setElements(int elements) {
        this.elements = elements;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public AbstractBuild getOwner() {
        return this.owner;
    }

    public void setOwner(AbstractBuild owner) {
        this.owner = owner;
    }

    public abstract AbstractCloverMetrics getPreviousResult();

    public void doGraph(StaplerRequest req, StaplerResponse rsp) throws IOException {
        if (ChartUtil.awtProblem) {
            rsp.sendRedirect2(req.getContextPath() + "/images/headless.png");
            return;
        }
        AbstractBuild build = this.getOwner();
        Calendar t = build.getTimestamp();
        if (req.checkIfModified(t, rsp)) {
            return;
        }
        DataSetBuilder dsb = new DataSetBuilder();
        for (AbstractCloverMetrics a = this; a != null; a = a.getPreviousResult()) {
            ChartUtil.NumberOnlyBuildLabel label = new ChartUtil.NumberOnlyBuildLabel(a.getOwner());
            dsb.add((Number)Float.valueOf(a.getMethodCoverage().getPercentageFloat()), (Comparable)((Object)"method"), (Comparable)label);
            dsb.add((Number)Float.valueOf(a.getConditionalCoverage().getPercentageFloat()), (Comparable)((Object)"conditional"), (Comparable)label);
            dsb.add((Number)Float.valueOf(a.getStatementCoverage().getPercentageFloat()), (Comparable)((Object)"statement"), (Comparable)label);
        }
        ChartUtil.generateGraph((StaplerRequest)req, (StaplerResponse)rsp, (JFreeChart)this.createChart(dsb.build()), (int)400, (int)200);
    }

    private JFreeChart createChart(CategoryDataset dataset) {
        JFreeChart chart = ChartFactory.createLineChart(null, null, (String)"%", (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        LegendTitle legend = chart.getLegend();
        legend.setPosition(RectangleEdge.RIGHT);
        chart.setBackgroundPaint((Paint)Color.white);
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setOutlinePaint(null);
        plot.setRangeGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)Color.black);
        ShiftedCategoryAxis domainAxis = new ShiftedCategoryAxis(null);
        plot.setDomainAxis((CategoryAxis)domainAxis);
        domainAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
        domainAxis.setLowerMargin(0.0);
        domainAxis.setUpperMargin(0.0);
        domainAxis.setCategoryMargin(0.0);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        rangeAxis.setUpperBound(100.0);
        rangeAxis.setLowerBound(0.0);
        LineAndShapeRenderer renderer = (LineAndShapeRenderer)plot.getRenderer();
        renderer.setStroke((Stroke)new BasicStroke(2.0f));
        ColorPalette.apply((LineAndShapeRenderer)renderer);
        plot.setInsets(new RectangleInsets(5.0, 0.0, 0.0, 5.0));
        return chart;
    }
}

