/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clover;

import hudson.FilePath;
import hudson.model.Actionable;
import hudson.model.Build;
import hudson.model.DirectoryBrowserSupport;
import hudson.model.ModelObject;
import hudson.model.Project;
import hudson.model.ProminentProjectAction;
import hudson.model.Result;
import hudson.plugins.clover.CloverBuildAction;
import hudson.plugins.clover.CloverPublisher;
import java.io.File;
import java.io.IOException;
import javax.servlet.ServletException;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class CloverProjectAction
extends Actionable
implements ProminentProjectAction {
    private final Project<?, ?> project;

    public CloverProjectAction(Project project) {
        this.project = project;
    }

    public String getIconFileName() {
        if (new File(CloverPublisher.getCloverReportDir(this.project), "index.html").exists()) {
            return "graph.gif";
        }
        if (new File(CloverPublisher.getCloverReportDir(this.project), "clover.pdf").exists()) {
            return "graph.gif";
        }
        if (new File(CloverPublisher.getCloverReportDir(this.project), "clover.xml").exists()) {
            return "graph.gif";
        }
        return null;
    }

    public String getDisplayName() {
        if (new File(CloverPublisher.getCloverReportDir(this.project), "index.html").exists()) {
            return "Clover Coverage Report";
        }
        if (new File(CloverPublisher.getCloverReportDir(this.project), "clover.pdf").exists()) {
            return "Clover Coverage PDF";
        }
        if (new File(CloverPublisher.getCloverReportDir(this.project), "clover.xml").exists()) {
            return "Coverage Report";
        }
        return null;
    }

    public String getUrlName() {
        if (new File(CloverPublisher.getCloverReportDir(this.project), "index.html").exists()) {
            return "clover";
        }
        if (new File(CloverPublisher.getCloverReportDir(this.project), "clover.pdf").exists()) {
            return "clover";
        }
        if (new File(CloverPublisher.getCloverReportDir(this.project), "clover.xml").exists()) {
            return "clover";
        }
        return "clover";
    }

    public CloverBuildAction getLastResult() {
        for (Build b = (Build)this.project.getLastBuild(); b != null; b = (Build)b.getPreviousBuild()) {
            CloverBuildAction r;
            if (b.getResult() == Result.FAILURE || (r = (CloverBuildAction)b.getAction(CloverBuildAction.class)) == null) continue;
            return r;
        }
        return null;
    }

    public void doGraph(StaplerRequest req, StaplerResponse rsp) throws IOException {
        if (this.getLastResult() != null) {
            this.getLastResult().getResult().doGraph(req, rsp);
        }
    }

    public void doDynamic(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException, InterruptedException {
        new DirectoryBrowserSupport((ModelObject)this).serveFile(req, rsp, new FilePath(CloverPublisher.getCloverReportDir(this.project)), "graph.gif", false);
    }

    public String getSearchUrl() {
        return this.getUrlName();
    }
}

