/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clover;

import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractItem;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Project;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.plugins.clover.CloverBuildAction;
import hudson.plugins.clover.CloverCoverageParser;
import hudson.plugins.clover.CloverProjectAction;
import hudson.plugins.clover.results.ProjectCoverage;
import hudson.plugins.clover.targets.CoverageMetric;
import hudson.plugins.clover.targets.CoverageTarget;
import hudson.remoting.VirtualChannel;
import hudson.tasks.Publisher;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CloverPublisher
extends Publisher {
    private final String cloverReportDir;
    private CoverageTarget healthyTarget;
    private CoverageTarget unhealthyTarget;
    private CoverageTarget failingTarget;
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    public CloverPublisher(String cloverReportDir) {
        this.cloverReportDir = cloverReportDir;
        this.healthyTarget = new CoverageTarget();
        this.unhealthyTarget = new CoverageTarget();
        this.failingTarget = new CoverageTarget();
    }

    public String getCloverReportDir() {
        return this.cloverReportDir;
    }

    public CoverageTarget getHealthyTarget() {
        return this.healthyTarget;
    }

    public void setHealthyTarget(CoverageTarget healthyTarget) {
        this.healthyTarget = healthyTarget;
    }

    public CoverageTarget getUnhealthyTarget() {
        return this.unhealthyTarget;
    }

    public void setUnhealthyTarget(CoverageTarget unhealthyTarget) {
        this.unhealthyTarget = unhealthyTarget;
    }

    public CoverageTarget getFailingTarget() {
        return this.failingTarget;
    }

    public void setFailingTarget(CoverageTarget failingTarget) {
        this.failingTarget = failingTarget;
    }

    static File getCloverReportDir(AbstractItem project) {
        return new File(project.getRootDir(), "clover");
    }

    static File getCloverReport(AbstractBuild<?, ?> build) {
        return new File(build.getRootDir(), "clover.xml");
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException {
        File cloverXmlReport;
        listener.getLogger().println("Publishing Clover coverage report...");
        FilePath coverageReport = ((AbstractProject)build.getParent()).getWorkspace().child(this.cloverReportDir);
        FilePath target = new FilePath(CloverPublisher.getCloverReportDir((AbstractItem)build.getParent()));
        File buildCloverDir = build.getRootDir();
        FilePath buildTarget = new FilePath(buildCloverDir);
        try {
            if (build.getResult().isWorseOrEqualTo(Result.FAILURE) && !coverageReport.exists()) {
                return true;
            }
            coverageReport.copyRecursiveTo("**/*", target);
            coverageReport.copyRecursiveTo("clover.xml", buildTarget);
        }
        catch (IOException e) {
            Util.displayIOException((IOException)e, (TaskListener)listener);
            e.printStackTrace(listener.fatalError("Unable to copy coverage from " + coverageReport + " to " + target));
            build.setResult(Result.FAILURE);
        }
        String workspacePath = "";
        try {
            workspacePath = (String)((AbstractProject)build.getParent()).getWorkspace().act((FilePath.FileCallable)new FilePath.FileCallable<String>(){

                public String invoke(File file, VirtualChannel virtualChannel) throws IOException {
                    try {
                        return file.getCanonicalPath();
                    }
                    catch (IOException e) {
                        return file.getAbsolutePath();
                    }
                }
            });
        }
        catch (IOException e) {
            // empty catch block
        }
        if (!workspacePath.endsWith(File.separator)) {
            workspacePath = workspacePath + File.separator;
        }
        if ((cloverXmlReport = CloverPublisher.getCloverReport(build)).exists()) {
            listener.getLogger().println("Publishing Clover coverage results...");
            ProjectCoverage result = null;
            try {
                result = CloverCoverageParser.parse(cloverXmlReport, workspacePath);
            }
            catch (IOException e) {
                Util.displayIOException((IOException)e, (TaskListener)listener);
                e.printStackTrace(listener.fatalError("Unable to copy coverage from " + coverageReport + " to " + target));
                build.setResult(Result.FAILURE);
            }
            CloverBuildAction action = CloverBuildAction.load(build, workspacePath, result, this.healthyTarget, this.unhealthyTarget);
            build.getActions().add(action);
            Set<CoverageMetric> failingMetrics = this.failingTarget.getFailingMetrics(result);
            if (!failingMetrics.isEmpty()) {
                listener.getLogger().println("Code coverage enforcement failed for the following metrics:");
                for (CoverageMetric metric : failingMetrics) {
                    listener.getLogger().println("    " + (Object)((Object)metric));
                }
                listener.getLogger().println("Setting Build to unstable.");
                build.setResult(Result.UNSTABLE);
            }
        } else {
            this.flagMissingCloverXml(listener, build);
        }
        return true;
    }

    private void flagMissingCloverXml(BuildListener listener, AbstractBuild<?, ?> build) {
        listener.getLogger().println("Could not find '" + this.cloverReportDir + "/clover.xml'.  Did you generate " + "the XML report for Clover?");
        build.setResult(Result.FAILURE);
    }

    public Action getProjectAction(Project project) {
        return new CloverProjectAction(project);
    }

    public Descriptor<Publisher> getDescriptor() {
        return DESCRIPTOR;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends Descriptor<Publisher> {
        DescriptorImpl() {
            super(CloverPublisher.class);
        }

        public String getDisplayName() {
            return "Publish Clover Coverage Report";
        }

        public boolean configure(StaplerRequest req) throws Descriptor.FormException {
            req.bindParameters((Object)this, "clover.");
            this.save();
            return super.configure(req);
        }

        public CloverPublisher newInstance(StaplerRequest req) throws Descriptor.FormException {
            CloverPublisher instance = (CloverPublisher)((Object)req.bindParameters(CloverPublisher.class, "clover."));
            req.bindParameters((Object)instance.failingTarget, "cloverFailingTarget.");
            req.bindParameters((Object)instance.healthyTarget, "cloverHealthyTarget.");
            req.bindParameters((Object)instance.unhealthyTarget, "cloverUnhealthyTarget.");
            if (instance.healthyTarget.isEmpty()) {
                instance.healthyTarget = new CoverageTarget(70, 80, 80);
            }
            return instance;
        }
    }
}

