/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clover;

import com.atlassian.clover.api.ci.CIOptions;
import com.atlassian.clover.api.ci.Integrator;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Proc;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.FreeStyleProject;
import hudson.model.Hudson;
import hudson.model.Project;
import hudson.model.Run;
import hudson.plugins.clover.CloverProjectAction;
import hudson.plugins.clover.CloverPublisher;
import hudson.remoting.Channel;
import hudson.tasks.BuildWrapper;
import hudson.tasks.BuildWrapperDescriptor;
import hudson.util.DescribableList;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class CloverBuildWrapper
extends BuildWrapper {
    public boolean historical = true;
    public boolean json = true;
    public String licenseCert;
    public static final Descriptor<BuildWrapper> DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public CloverBuildWrapper(boolean historical, boolean json, String licenseCert) {
        this.historical = historical;
        this.json = json;
        this.licenseCert = licenseCert;
    }

    public BuildWrapper.Environment setUp(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        this.addCloverPublisher(build, listener);
        return new BuildWrapper.Environment(){};
    }

    private void addCloverPublisher(AbstractBuild build, BuildListener listener) throws IOException {
        DescribableList publishers = build.getProject().getPublishersList();
        if (!publishers.contains((Descriptor)CloverPublisher.DESCRIPTOR)) {
            String reportDir = "clover";
            listener.getLogger().println("Adding Clover Publisher with reportDir: clover");
            build.getProject().getPublishersList().add((Describable)new CloverPublisher("clover"));
        }
    }

    public Action getProjectAction(AbstractProject job) {
        if (job.getAction(CloverProjectAction.class) == null) {
            return new CloverProjectAction((Project)job);
        }
        return super.getProjectAction(job);
    }

    public Launcher decorateLauncher(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException, Run.RunnerAbortedException {
        DescriptorImpl descriptor = (DescriptorImpl)Hudson.getInstance().getDescriptorByType(DescriptorImpl.class);
        String license = Util.nullify((String)this.licenseCert) == null ? descriptor.licenseCert : this.licenseCert;
        final CIOptions.Builder options = new CIOptions.Builder().json(this.json).historical(this.historical).licenseCert(license).fullClean(true);
        final Launcher outer = launcher;
        return new Launcher(outer){

            public Proc launch(Launcher.ProcStarter starter) throws IOException {
                if (starter.cmds().isEmpty() || ((String)starter.cmds().get(0)).endsWith("ant")) {
                    Integrator integrator = Integrator.Factory.newAntIntegrator((CIOptions)options.build());
                    integrator.decorateArguments(starter.cmds().subList(1, starter.cmds().size() - 1));
                    boolean[] masks = new boolean[starter.cmds().size()];
                    for (int i = 0; i < starter.masks().length; ++i) {
                        masks[i] = starter.masks()[i];
                    }
                    starter.masks(masks);
                }
                return outer.launch(starter);
            }

            public Channel launchChannel(String[] cmd, OutputStream out, FilePath workDir, Map<String, String> envVars) throws IOException, InterruptedException {
                return outer.launchChannel(cmd, out, workDir, envVars);
            }

            public void kill(Map<String, String> modelEnvVars) throws IOException, InterruptedException {
                outer.kill(modelEnvVars);
            }
        };
    }

    public static final class DescriptorImpl
    extends BuildWrapperDescriptor {
        public String licenseCert;

        public DescriptorImpl() {
            super(CloverBuildWrapper.class);
            this.load();
        }

        public String getDisplayName() {
            return "<img src='/plugin/clover/clover_48x48.png' height='24'/> Automatically record and report Code Coverage using <a href='http://atlassian.com/clover'>Clover.</a>. Currently for Ant builds only.";
        }

        public String getHelpFile() {
            return "/plugin/clover/help-cloverConfig.html";
        }

        public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            req.bindParameters((Object)this, "clover.");
            this.save();
            return true;
        }

        public boolean isApplicable(AbstractProject item) {
            return item instanceof FreeStyleProject;
        }
    }
}

