/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clover;

import hudson.FilePath;
import hudson.model.Actionable;
import hudson.model.Build;
import hudson.model.DirectoryBrowserSupport;
import hudson.model.ModelObject;
import hudson.model.Project;
import hudson.model.ProminentProjectAction;
import hudson.model.Result;
import hudson.plugins.clover.CloverBuildAction;
import java.io.File;
import java.io.IOException;
import javax.servlet.ServletException;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class CloverProjectAction
extends Actionable
implements ProminentProjectAction {
    static final String ICON = "/plugin/clover/clover_48x48.png";
    private final Project<?, ?> project;

    public CloverProjectAction(Project project) {
        this.project = project;
    }

    public String getIconFileName() {
        File reportDir = this.getLastBuildReportDir();
        if (reportDir != null && (new File(reportDir, "index.html").exists() || new File(reportDir, "clover.pdf").exists() || new File(reportDir, "clover.xml").exists())) {
            return ICON;
        }
        return null;
    }

    private File getLastBuildReportDir() {
        if (this.project.getLastBuild() == null) {
            return null;
        }
        File reportDir = ((Build)this.project.getLastBuild()).getRootDir();
        return reportDir;
    }

    public String getDisplayName() {
        File reportDir = this.getLastBuildReportDir();
        if (reportDir == null) {
            return null;
        }
        if (new File(reportDir, "index.html").exists()) {
            return "Clover HTML Coverage Report";
        }
        if (new File(reportDir, "clover.pdf").exists()) {
            return "Clover PDF Coverage";
        }
        if (new File(reportDir, "clover.xml").exists()) {
            return "Coverage Report";
        }
        return null;
    }

    public String getUrlName() {
        return "clover";
    }

    public CloverBuildAction getLastSuccessfulResult() {
        for (Build b = (Build)this.project.getLastBuild(); b != null; b = (Build)b.getPreviousBuild()) {
            CloverBuildAction r;
            if (b.getResult() == Result.FAILURE || (r = (CloverBuildAction)b.getAction(CloverBuildAction.class)) == null) continue;
            return r;
        }
        return null;
    }

    public void doGraph(StaplerRequest req, StaplerResponse rsp) throws IOException {
        if (this.getLastSuccessfulResult() != null) {
            this.getLastSuccessfulResult().getResult().doGraph(req, rsp);
        }
    }

    public DirectoryBrowserSupport doDynamic(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException, InterruptedException {
        if (this.project.getLastBuild() != null && this.getDisplayName() != null) {
            return new DirectoryBrowserSupport((ModelObject)this, new FilePath(((Build)this.project.getLastBuild()).getRootDir()), "Clover Html Report", "/clover/clover.gif", false);
        }
        return null;
    }

    public String getSearchUrl() {
        return this.getUrlName();
    }
}

