/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clover;

import com.atlassian.clover.api.ci.CIOptions;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Project;
import hudson.model.Run;
import hudson.plugins.clover.CloverBuildWrapper;
import hudson.plugins.clover.CloverProjectAction;
import hudson.plugins.clover.CloverPublisher;
import hudson.tasks.BuildWrapper;
import hudson.util.DescribableList;
import java.io.IOException;
import org.kohsuke.stapler.DataBoundConstructor;

public class CloverBuildWrapper
extends BuildWrapper {
    public boolean historical = true;
    public boolean json = true;
    public String licenseCert;
    public static final Descriptor<BuildWrapper> DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public CloverBuildWrapper(boolean historical, boolean json, String licenseCert) {
        this.historical = historical;
        this.json = json;
        this.licenseCert = licenseCert;
    }

    public BuildWrapper.Environment setUp(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        this.addCloverPublisher(build, listener);
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private void addCloverPublisher(AbstractBuild build, BuildListener listener) throws IOException {
        DescribableList publishers = build.getProject().getPublishersList();
        if (!publishers.contains((Descriptor)CloverPublisher.DESCRIPTOR)) {
            String reportDir = "clover";
            listener.getLogger().println("Adding Clover Publisher with reportDir: clover");
            build.getProject().getPublishersList().add((Describable)new CloverPublisher("clover"));
        }
    }

    public Action getProjectAction(AbstractProject job) {
        if (job.getAction(CloverProjectAction.class) == null) {
            return new CloverProjectAction((Project)job);
        }
        return super.getProjectAction(job);
    }

    public Launcher decorateLauncher(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException, Run.RunnerAbortedException {
        DescriptorImpl descriptor = (DescriptorImpl)Hudson.getInstance().getDescriptorByType(DescriptorImpl.class);
        String license = Util.nullify((String)this.licenseCert) == null ? descriptor.licenseCert : this.licenseCert;
        CIOptions.Builder options = new CIOptions.Builder().json(this.json).historical(this.historical).fullClean(true);
        Launcher outer = launcher;
        return new CloverDecoratingLauncher(outer, options, license);
    }
}

