/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clover;

import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Project;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.plugins.clover.CloverBuildAction;
import hudson.plugins.clover.CloverCoverageParser;
import hudson.plugins.clover.CloverHtmlBuildAction;
import hudson.plugins.clover.CloverProjectAction;
import hudson.plugins.clover.results.ProjectCoverage;
import hudson.plugins.clover.targets.CoverageMetric;
import hudson.plugins.clover.targets.CoverageTarget;
import hudson.remoting.VirtualChannel;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CloverPublisher
extends Recorder {
    private final String cloverReportDir;
    private CoverageTarget healthyTarget;
    private CoverageTarget unhealthyTarget;
    private CoverageTarget failingTarget;
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    public CloverPublisher(String cloverReportDir) {
        this.cloverReportDir = cloverReportDir;
        this.healthyTarget = new CoverageTarget();
        this.unhealthyTarget = new CoverageTarget();
        this.failingTarget = new CoverageTarget();
    }

    public String getCloverReportDir() {
        return this.cloverReportDir;
    }

    public CoverageTarget getHealthyTarget() {
        return this.healthyTarget;
    }

    public void setHealthyTarget(CoverageTarget healthyTarget) {
        this.healthyTarget = healthyTarget;
    }

    public CoverageTarget getUnhealthyTarget() {
        return this.unhealthyTarget;
    }

    public void setUnhealthyTarget(CoverageTarget unhealthyTarget) {
        this.unhealthyTarget = unhealthyTarget;
    }

    public CoverageTarget getFailingTarget() {
        return this.failingTarget;
    }

    public void setFailingTarget(CoverageTarget failingTarget) {
        this.failingTarget = failingTarget;
    }

    static File getCloverXmlReport(AbstractBuild<?, ?> build) {
        return new File(build.getRootDir(), "clover.xml");
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException {
        File buildRootDir = build.getRootDir();
        FilePath buildTarget = new FilePath(buildRootDir);
        FilePath workspace = build.getWorkspace();
        FilePath coverageReportDir = workspace.child(this.cloverReportDir);
        try {
            boolean missingReport;
            listener.getLogger().println("Publishing Clover coverage report...");
            if (!coverageReportDir.exists()) {
                coverageReportDir = this.findOneDirDeep(workspace, this.cloverReportDir);
            }
            boolean buildFailure = build.getResult().isWorseOrEqualTo(Result.FAILURE);
            boolean bl = missingReport = !coverageReportDir.exists();
            if (buildFailure && missingReport) {
                listener.getLogger().println("No Clover report will be published due to a " + (buildFailure ? "Build Failure" : "missing report"));
                return true;
            }
            boolean htmlExists = this.copyHtmlReport(coverageReportDir, buildTarget, listener);
            boolean xmlExists = this.copyXmlReport(coverageReportDir, buildTarget, listener);
            if (htmlExists) {
                build.getActions().add(new CloverHtmlBuildAction(buildTarget));
            }
            this.processCloverXml(build, listener, coverageReportDir, buildTarget);
        }
        catch (IOException e) {
            Util.displayIOException((IOException)e, (TaskListener)listener);
            e.printStackTrace(listener.fatalError("Unable to copy coverage from " + coverageReportDir + " to " + buildTarget));
            build.setResult(Result.FAILURE);
        }
        return true;
    }

    private void processCloverXml(AbstractBuild<?, ?> build, BuildListener listener, FilePath coverageReport, FilePath buildTarget) throws InterruptedException {
        File cloverXmlReport;
        String workspacePath = "";
        try {
            workspacePath = (String)build.getWorkspace().act((FilePath.FileCallable)new FilePath.FileCallable<String>(){

                public String invoke(File file, VirtualChannel virtualChannel) throws IOException {
                    try {
                        return file.getCanonicalPath();
                    }
                    catch (IOException e) {
                        return file.getAbsolutePath();
                    }
                }
            });
        }
        catch (IOException e) {
            // empty catch block
        }
        if (!workspacePath.endsWith(File.separator)) {
            workspacePath = workspacePath + File.separator;
        }
        if ((cloverXmlReport = CloverPublisher.getCloverXmlReport(build)).exists()) {
            listener.getLogger().println("Publishing Clover coverage results...");
            ProjectCoverage result = null;
            try {
                result = CloverCoverageParser.parse(cloverXmlReport, workspacePath);
            }
            catch (IOException e) {
                Util.displayIOException((IOException)e, (TaskListener)listener);
                e.printStackTrace(listener.fatalError("Unable to copy coverage from " + coverageReport + " to " + buildTarget));
                build.setResult(Result.FAILURE);
            }
            CloverBuildAction action = CloverBuildAction.load(build, workspacePath, result, this.healthyTarget, this.unhealthyTarget);
            build.getActions().add(action);
            Set<CoverageMetric> failingMetrics = this.failingTarget.getFailingMetrics(result);
            if (!failingMetrics.isEmpty()) {
                listener.getLogger().println("Code coverage enforcement failed for the following metrics:");
                for (CoverageMetric metric : failingMetrics) {
                    listener.getLogger().println("    " + (Object)((Object)metric));
                }
                listener.getLogger().println("Setting Build to unstable.");
                build.setResult(Result.UNSTABLE);
            }
        } else {
            this.flagMissingCloverXml(listener, build);
        }
    }

    private boolean copyXmlReport(FilePath coverageReport, FilePath buildTarget, BuildListener listener) throws IOException, InterruptedException {
        FilePath cloverXmlPath = this.findOneDirDeep(coverageReport, "clover.xml");
        if (cloverXmlPath.exists()) {
            listener.getLogger().println("Publishing Clover XML report...");
            cloverXmlPath.copyTo(buildTarget.child("clover.xml"));
            return true;
        }
        listener.getLogger().println("Clover xml file does not exist at: " + cloverXmlPath);
        return false;
    }

    private boolean copyHtmlReport(FilePath coverageReport, FilePath buildTarget, BuildListener listener) throws IOException, InterruptedException {
        FilePath htmlIndexHtmlPath = this.findOneDirDeep(coverageReport, "index.html");
        if (htmlIndexHtmlPath.exists()) {
            FilePath htmlDirPath = htmlIndexHtmlPath.getParent();
            listener.getLogger().println("Publishing Clover HTML report...");
            htmlDirPath.copyRecursiveTo("**/*", buildTarget);
            return true;
        }
        return false;
    }

    private FilePath findOneDirDeep(FilePath startDir, String filename) throws IOException, InterruptedException {
        List dirs;
        FilePath dirContainingFile = startDir;
        if (!dirContainingFile.child(filename).exists() && (dirs = dirContainingFile.listDirectories()) != null) {
            for (FilePath dir : dirs) {
                if (!dir.child(filename).exists()) continue;
                dirContainingFile = dir;
                break;
            }
        }
        return dirContainingFile.child(filename);
    }

    private void flagMissingCloverXml(BuildListener listener, AbstractBuild<?, ?> build) {
        listener.getLogger().println("Could not find '" + this.cloverReportDir + "/clover.xml'.  Did you generate " + "the XML report for Clover?");
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        return project instanceof Project ? new CloverProjectAction((Project)project) : null;
    }

    public BuildStepDescriptor<Publisher> getDescriptor() {
        return DESCRIPTOR;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        DescriptorImpl() {
            super(CloverPublisher.class);
        }

        public String getDisplayName() {
            return "Publish Clover Coverage Report";
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            req.bindParameters((Object)this, "clover.");
            this.save();
            return super.configure(req, formData);
        }

        public CloverPublisher newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            CloverPublisher instance = (CloverPublisher)((Object)req.bindParameters(CloverPublisher.class, "clover."));
            req.bindParameters((Object)instance.failingTarget, "cloverFailingTarget.");
            req.bindParameters((Object)instance.healthyTarget, "cloverHealthyTarget.");
            req.bindParameters((Object)instance.unhealthyTarget, "cloverUnhealthyTarget.");
            if (instance.healthyTarget.isEmpty()) {
                instance.healthyTarget = new CoverageTarget(70, 80, 80);
            }
            return instance;
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }
    }
}

