/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clover;

import hudson.plugins.clover.CoverageBarProvider;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.Locale;

public final class Ratio
implements Serializable,
CoverageBarProvider {
    public final float numerator;
    public final float denominator;
    public static final NumberFormat PC_WIDTH_FORMAT = NumberFormat.getInstance(Locale.US);
    private static final long serialVersionUID = 1L;
    private static final Ratio[] COMMON_INSTANCES;

    private Ratio(float numerator, float denominator) {
        this.numerator = numerator;
        this.denominator = denominator;
    }

    public String toString() {
        return this.print(this.numerator) + "/" + this.print(this.denominator);
    }

    private String print(float f) {
        int i = (int)f;
        if ((float)i == f) {
            return String.valueOf(i);
        }
        return String.valueOf(f);
    }

    public String getPercentage1d() {
        return PC_WIDTH_FORMAT.format(this.getPercentageFloat());
    }

    public String getPercentageStr() {
        return this.denominator > 0.0f ? PC_WIDTH_FORMAT.format(this.getPercentageFloat()) + "%" : "-";
    }

    private String pcFormat(float pc) {
        return PC_WIDTH_FORMAT.format(pc) + "%";
    }

    public String getPcWidth() {
        return this.pcFormat(this.getPercentageFloat());
    }

    public String getPcUncovered() {
        float pcUncovered = 100.0f - this.getPercentageFloat();
        return this.pcFormat(pcUncovered);
    }

    public String getPcCovered() {
        return this.getPercentageStr();
    }

    public String getHasData() {
        return "" + (this.denominator > 0.0f);
    }

    public int getPercentage() {
        return Math.round(this.getPercentageFloat());
    }

    public float getPercentageFloat() {
        if (Float.compare(this.denominator, this.numerator) == 0) {
            return 100.0f;
        }
        return 100.0f * this.numerator / this.denominator;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Ratio ratio = (Ratio)o;
        return Float.compare(ratio.denominator, this.denominator) == 0 && Float.compare(ratio.numerator, this.numerator) == 0;
    }

    public int hashCode() {
        int result = this.numerator != 0.0f ? Float.floatToIntBits(this.numerator) : 0;
        result = (float)(31 * result) + this.denominator != 0.0f ? Float.floatToIntBits(this.denominator) : 0;
        return result;
    }

    public static Ratio create(float x, float y) {
        int idx;
        int xx = (int)x;
        int yy = (int)y;
        if ((float)xx == x && (float)yy == y && 0 <= (idx = yy * (yy + 1) / 2 + xx) && idx < COMMON_INSTANCES.length) {
            Ratio r = COMMON_INSTANCES[idx];
            if (r == null) {
                Ratio.COMMON_INSTANCES[idx] = r = new Ratio(x, y);
            }
            return r;
        }
        return new Ratio(x, y);
    }

    static {
        PC_WIDTH_FORMAT.setMaximumFractionDigits(1);
        COMMON_INSTANCES = new Ratio[256];
    }
}

