/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clover.targets;

import hudson.plugins.clover.results.AbstractCloverMetrics;
import hudson.plugins.clover.targets.CoverageMetric;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class CoverageTarget
implements Serializable {
    private Integer methodCoverage;
    private Integer conditionalCoverage;
    private Integer statementCoverage;
    private Integer elementCoverage;

    public CoverageTarget() {
    }

    public CoverageTarget(Integer methodCoverage, Integer conditionalCoverage, Integer statementCoverage) {
        this.methodCoverage = methodCoverage;
        this.conditionalCoverage = conditionalCoverage;
        this.statementCoverage = statementCoverage;
        this.elementCoverage = null;
    }

    public boolean isAlwaysMet() {
        return !(this.methodCoverage != null && this.methodCoverage >= 0 || this.conditionalCoverage != null && this.conditionalCoverage >= 0 || this.statementCoverage != null && this.statementCoverage >= 0 || this.elementCoverage != null && this.elementCoverage >= 0);
    }

    public boolean isEmpty() {
        return this.methodCoverage == null && this.conditionalCoverage == null && this.statementCoverage == null && this.elementCoverage == null;
    }

    public Set<CoverageMetric> getFailingMetrics(AbstractCloverMetrics coverage) {
        HashSet<CoverageMetric> result = new HashSet<CoverageMetric>();
        if (this.methodCoverage != null && coverage.getMethodCoverage().getPercentage() < this.methodCoverage) {
            result.add(CoverageMetric.METHOD);
        }
        if (this.conditionalCoverage != null && coverage.getConditionalCoverage().getPercentage() < this.conditionalCoverage) {
            result.add(CoverageMetric.CONDITIONAL);
        }
        if (this.statementCoverage != null && coverage.getStatementCoverage().getPercentage() < this.statementCoverage) {
            result.add(CoverageMetric.STATEMENT);
        }
        if (this.elementCoverage != null && coverage.getElementCoverage().getPercentage() < this.elementCoverage) {
            result.add(CoverageMetric.ELEMENT);
        }
        return result;
    }

    public Map<CoverageMetric, Integer> getRangeScores(CoverageTarget min, AbstractCloverMetrics coverage) {
        HashMap<CoverageMetric, Integer> result = new HashMap<CoverageMetric, Integer>();
        Integer j = CoverageTarget.calcRangeScore((Integer)this.methodCoverage, (Integer)min.methodCoverage, (int)coverage.getMethodCoverage().getPercentage());
        if (j != null) {
            result.put(CoverageMetric.METHOD, j);
        }
        if ((j = Integer.valueOf(CoverageTarget.calcRangeScore((Integer)this.conditionalCoverage, (Integer)min.conditionalCoverage, (int)coverage.getConditionalCoverage().getPercentage()))) != null) {
            result.put(CoverageMetric.CONDITIONAL, j);
        }
        if ((j = Integer.valueOf(CoverageTarget.calcRangeScore((Integer)this.statementCoverage, (Integer)min.statementCoverage, (int)coverage.getStatementCoverage().getPercentage()))) != null) {
            result.put(CoverageMetric.STATEMENT, j);
        }
        if ((j = Integer.valueOf(CoverageTarget.calcRangeScore((Integer)this.elementCoverage, (Integer)min.elementCoverage, (int)coverage.getElementCoverage().getPercentage()))) != null) {
            result.put(CoverageMetric.ELEMENT, (int)j);
        }
        return result;
    }

    private static int calcRangeScore(Integer max, Integer min, int value) {
        int result;
        if (min == null || min < 0) {
            min = 0;
        }
        if (max == null || max > 100) {
            max = 100;
        }
        if (min > max) {
            min = max - 1;
        }
        if ((result = (int)(100.0f * ((float)value - min.floatValue()) / (max.floatValue() - min.floatValue()))) < 0) {
            return 0;
        }
        if (result > 100) {
            return 100;
        }
        return result;
    }

    public Integer getMethodCoverage() {
        return this.methodCoverage;
    }

    public void setMethodCoverage(Integer methodCoverage) {
        this.methodCoverage = methodCoverage;
    }

    public Integer getConditionalCoverage() {
        return this.conditionalCoverage;
    }

    public void setConditionalCoverage(Integer conditionalCoverage) {
        this.conditionalCoverage = conditionalCoverage;
    }

    public Integer getStatementCoverage() {
        return this.statementCoverage;
    }

    public void setStatementCoverage(Integer statementCoverage) {
        this.statementCoverage = statementCoverage;
    }

    public Integer getElementCoverage() {
        return this.elementCoverage;
    }

    public void setElementCoverage(Integer elementCoverage) {
        this.elementCoverage = elementCoverage;
    }
}

