/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clover.results;

import hudson.model.AbstractBuild;
import hudson.model.Run;
import hudson.plugins.clover.CloverBuildAction;
import hudson.plugins.clover.results.AbstractClassAggregatedMetrics;
import hudson.plugins.clover.results.AbstractCloverMetrics;
import hudson.plugins.clover.results.ClassCoverage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileCoverage
extends AbstractClassAggregatedMetrics {
    private List<ClassCoverage> classCoverages = new ArrayList<ClassCoverage>();

    public List<ClassCoverage> getChildren() {
        return this.getClassCoverages();
    }

    public ClassCoverage getDynamic(String token, StaplerRequest req, StaplerResponse rsp) throws IOException {
        return this.findClassCoverage(token);
    }

    public boolean addClassCoverage(ClassCoverage result) {
        return this.classCoverages.add(result);
    }

    public List<ClassCoverage> getClassCoverages() {
        return this.classCoverages;
    }

    @Override
    public ClassCoverage findClassCoverage(String name) {
        for (ClassCoverage i : this.classCoverages) {
            if (!name.equals(i.getName())) continue;
            return i;
        }
        return null;
    }

    @Override
    public AbstractCloverMetrics getPreviousResult() {
        if (this.owner == null) {
            return null;
        }
        Run prevBuild = this.owner.getPreviousBuild();
        if (prevBuild == null) {
            return null;
        }
        CloverBuildAction action = (CloverBuildAction)prevBuild.getAction(CloverBuildAction.class);
        if (action == null) {
            return null;
        }
        return action.findFileCoverage(this.getName());
    }

    @Override
    public void setOwner(AbstractBuild owner) {
        super.setOwner(owner);
        for (ClassCoverage classCoverage : this.classCoverages) {
            classCoverage.setOwner(owner);
        }
    }
}

