/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clover;

import com.atlassian.clover.api.ci.CIOptions;
import com.atlassian.clover.api.ci.Integrator;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Proc;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.FreeStyleProject;
import hudson.model.Hudson;
import hudson.model.Project;
import hudson.model.Run;
import hudson.plugins.clover.CloverProjectAction;
import hudson.plugins.clover.CloverPublisher;
import hudson.remoting.Channel;
import hudson.tasks.BuildWrapper;
import hudson.tasks.BuildWrapperDescriptor;
import hudson.util.DescribableList;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Map;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class CloverBuildWrapper
extends BuildWrapper {
    public boolean historical = true;
    public boolean json = true;
    public String licenseCert;
    public static final Descriptor<BuildWrapper> DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public CloverBuildWrapper(boolean historical, boolean json, String licenseCert) {
        this.historical = historical;
        this.json = json;
        this.licenseCert = licenseCert;
    }

    public BuildWrapper.Environment setUp(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        this.addCloverPublisher(build, listener);
        return new BuildWrapper.Environment(){};
    }

    private void addCloverPublisher(AbstractBuild build, BuildListener listener) throws IOException {
        DescribableList publishers = build.getProject().getPublishersList();
        if (!publishers.contains((Descriptor)CloverPublisher.DESCRIPTOR)) {
            String reportDir = "clover";
            listener.getLogger().println("Adding Clover Publisher with reportDir: clover");
            build.getProject().getPublishersList().add((Object)new CloverPublisher("clover", null));
        }
    }

    public Action getProjectAction(AbstractProject job) {
        if (job.getAction(CloverProjectAction.class) == null) {
            return new CloverProjectAction((Project)job);
        }
        return super.getProjectAction(job);
    }

    public Launcher decorateLauncher(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException, Run.RunnerAbortedException {
        DescriptorImpl descriptor = (DescriptorImpl)Hudson.getInstance().getDescriptorByType(DescriptorImpl.class);
        String license = Util.nullify((String)this.licenseCert) == null ? descriptor.licenseCert : this.licenseCert;
        CIOptions.Builder options = new CIOptions.Builder().json(this.json).historical(this.historical).fullClean(true);
        Launcher outer = launcher;
        return new CloverDecoratingLauncher(outer, options, license);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CloverDecoratingLauncher
    extends Launcher {
        private final Launcher outer;
        private final CIOptions.Builder options;
        private final String license;

        public CloverDecoratingLauncher(Launcher outer, CIOptions.Builder options, String license) {
            super(outer);
            this.outer = outer;
            this.options = options;
            this.license = license;
        }

        public Proc launch(Launcher.ProcStarter starter) throws IOException {
            this.decorateArgs(starter);
            return this.outer.launch(starter);
        }

        public void decorateArgs(Launcher.ProcStarter starter) throws IOException {
            LinkedList<String> userArgs = new LinkedList<String>();
            LinkedList preSystemArgs = new LinkedList();
            LinkedList<String> postSystemArgs = new LinkedList<String>();
            ArrayList cmds = new ArrayList();
            cmds.addAll(starter.cmds());
            int numPreSystemCmds = 2;
            String sysArgSplitter = "&&";
            if (!cmds.isEmpty() && cmds.size() >= 2 && !((String)cmds.get(0)).endsWith("ant")) {
                preSystemArgs.addAll(cmds.subList(0, 2));
                String argString = (String)cmds.get(2);
                argString = argString.replaceAll("\"", "");
                String[] tokens = argString.split(" ");
                preSystemArgs.add(tokens[0]);
                for (int i = 1; i < tokens.length; ++i) {
                    String arg = tokens[i];
                    if ("&&".equals(arg)) {
                        postSystemArgs.addAll(Arrays.asList(tokens).subList(i, tokens.length));
                        break;
                    }
                    userArgs.add(arg);
                }
            } else {
                if (cmds.size() > 0) {
                    preSystemArgs.add(cmds.get(0));
                }
                if (cmds.size() > 1) {
                    userArgs.addAll(cmds.subList(1, cmds.size()));
                }
            }
            if (!userArgs.isEmpty()) {
                this.options.fullClean(true);
                this.setupLicense(starter);
                Integrator integrator = Integrator.Factory.newAntIntegrator((CIOptions)this.options.build());
                integrator.decorateArguments(userArgs);
                starter.cmds(new ArrayList());
                ArrayList allCommands = new ArrayList();
                allCommands.addAll(preSystemArgs);
                allCommands.addAll(userArgs);
                allCommands.addAll(postSystemArgs);
                starter.cmds(allCommands);
                boolean[] masks = new boolean[starter.cmds().size()];
                for (int i = 0; i < starter.masks().length; ++i) {
                    masks[i] = starter.masks()[i];
                }
                starter.masks(masks);
            }
        }

        private void setupLicense(Launcher.ProcStarter starter) throws IOException {
            if (this.license == null) {
                this.listener.getLogger().println("No Clover license configured. Please download a free 30 day license from http://my.atlassian.com.");
                return;
            }
            FilePath licenseFile = new FilePath(starter.pwd(), ".clover/clover.license");
            try {
                licenseFile.write(this.license, "UTF-8");
                this.options.license(new File(licenseFile.toURI()));
            }
            catch (InterruptedException e) {
                this.listener.getLogger().print("Could not create license file at: " + licenseFile + ". Setting as a system property.");
                this.listener.getLogger().print(e.getMessage());
                this.options.licenseCert(this.license);
            }
        }

        public Channel launchChannel(String[] cmd, OutputStream out, FilePath workDir, Map<String, String> envVars) throws IOException, InterruptedException {
            return this.outer.launchChannel(cmd, out, workDir, envVars);
        }

        public void kill(Map<String, String> modelEnvVars) throws IOException, InterruptedException {
            this.outer.kill(modelEnvVars);
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildWrapperDescriptor {
        public String licenseCert;

        public DescriptorImpl() {
            super(CloverBuildWrapper.class);
            this.load();
        }

        public String getDisplayName() {
            return "Automatically record and report Code Coverage using Atlassian Clover. Currently for Ant builds only.";
        }

        public String getHelpFile() {
            return "/plugin/clover/help-cloverConfig.html";
        }

        public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            req.bindParameters((Object)this, "clover.");
            this.save();
            return true;
        }

        public boolean isApplicable(AbstractProject item) {
            return item instanceof FreeStyleProject;
        }
    }
}

