/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cmvc;

import hudson.model.AbstractBuild;
import hudson.model.User;
import hudson.scm.ChangeLogSet;
import hudson.scm.EditType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.TransformerUtils;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CmvcChangeLogSet
extends ChangeLogSet<CmvcChangeLog> {
    private List<CmvcChangeLog> logs;
    private Set<String> trackNames;

    public CmvcChangeLogSet(AbstractBuild<?, ?> build) {
        super(build);
    }

    public CmvcChangeLogSet(AbstractBuild<?, ?> build, List<CmvcChangeLog> logs) {
        super(build);
        this.logs = Collections.unmodifiableList(logs);
    }

    public boolean isEmptySet() {
        return this.logs == null || this.logs.isEmpty();
    }

    public Iterator<CmvcChangeLog> iterator() {
        return this.logs.iterator();
    }

    public List<CmvcChangeLog> getLogs() {
        return this.logs;
    }

    public void setLogs(List<CmvcChangeLog> logs) {
        this.logs = logs;
    }

    public Set<String> getTrackNames() {
        return this.trackNames;
    }

    public void setTrackNames(Set<String> trackNames) {
        this.trackNames = trackNames;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @ExportedBean(defaultVisibility=999)
    public static class CmvcChangeLog
    extends ChangeLogSet.Entry {
        private Date dateTime;
        private User author;
        private String msg;
        private String type;
        private String level;
        private String trackName;
        private List<ModifiedFile> files = new ArrayList<ModifiedFile>();

        public CmvcChangeLog() {
        }

        public CmvcChangeLog(CmvcChangeLogSet changeLogSet) {
            this.setParent(changeLogSet);
        }

        @Exported
        public String getTrackName() {
            return this.trackName;
        }

        public void setTrackName(String trackName) {
            this.trackName = trackName;
        }

        public void addFile(ModifiedFile file) {
            if (file != null) {
                file.setParent(this);
                this.files.add(file);
            }
        }

        public Collection<String> getAffectedPaths() {
            return CollectionUtils.collect(this.files, (Transformer)TransformerUtils.invokerTransformer((String)"getPath"));
        }

        public void setUser(String author) {
            if (StringUtils.isNotEmpty((String)author)) {
                this.author = User.get((String)author);
            }
        }

        @Exported
        public String getUser() {
            return this.author.getDisplayName();
        }

        @Exported
        public Date getDateTime() {
            return this.dateTime;
        }

        public void setDateTime(Date date) {
            this.dateTime = date;
        }

        @Exported
        public String getMsg() {
            return this.msg;
        }

        public void setMsg(String msg) {
            this.msg = msg;
        }

        public User getAuthor() {
            if (this.author == null) {
                return User.getUnknown();
            }
            return this.author;
        }

        @Exported
        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        @Exported
        public String getLevel() {
            return this.level;
        }

        public void setLevel(String level) {
            this.level = level;
        }

        public List<ModifiedFile> getFiles() {
            return this.files;
        }

        public void setFiles(List<ModifiedFile> files) {
            this.files = files;
        }

        @ExportedBean(defaultVisibility=999)
        public static class ModifiedFile {
            private String path;
            private String action;
            private String version;
            private CmvcChangeLog parent;

            public ModifiedFile() {
                this("", "", "");
            }

            public ModifiedFile(String path, String action, String version) {
                this.path = path;
                this.action = action;
                this.version = version;
            }

            public CmvcChangeLog getParent() {
                return this.parent;
            }

            void setParent(CmvcChangeLog parent) {
                this.parent = parent;
            }

            @Exported
            public String getPath() {
                return this.path;
            }

            public void setPath(String path) {
                this.path = path;
            }

            @Exported
            public String getAction() {
                return this.action;
            }

            public void setAction(String action) {
                this.action = action;
            }

            @Exported
            public EditType getEditType() {
                if (this.action.equalsIgnoreCase("delete")) {
                    return EditType.DELETE;
                }
                if (this.action.equalsIgnoreCase("add") || this.action.equalsIgnoreCase("create")) {
                    return EditType.ADD;
                }
                return EditType.EDIT;
            }

            public String getVersion() {
                return this.version;
            }

            public void setVersion(String version) {
                this.version = version;
            }
        }
    }
}

