/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cmvc;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.ModelObject;
import hudson.model.TaskListener;
import hudson.plugins.cmvc.CmvcChangeLogParser;
import hudson.plugins.cmvc.CmvcChangeLogSet;
import hudson.plugins.cmvc.Messages;
import hudson.plugins.cmvc.util.CmvcRawParser;
import hudson.plugins.cmvc.util.CommandLineUtil;
import hudson.plugins.cmvc.util.DateUtil;
import hudson.scm.ChangeLogParser;
import hudson.scm.SCM;
import hudson.scm.SCMDescriptor;
import hudson.util.ArgumentListBuilder;
import hudson.util.ForkOutputStream;
import hudson.util.FormValidation;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.Writer;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONObject;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmvcSCM
extends SCM
implements Serializable {
    private static final long serialVersionUID = -6712277029373852186L;
    private String family;
    private String releases;
    private String become;
    private String checkoutScript;
    private String trackViewReportWhereClause;
    private CommandLineUtil commandLineUtil = null;
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public CmvcSCM(String family, String become, String releases, String checkoutScript, String trackViewReportWhereClause) {
        this.checkoutScript = checkoutScript;
        this.family = family;
        this.releases = releases;
        this.become = become;
        this.trackViewReportWhereClause = trackViewReportWhereClause;
    }

    private CommandLineUtil getCmvcCommandLineUtil() {
        return this.commandLineUtil != null ? this.commandLineUtil : new CommandLineUtil(this);
    }

    public boolean checkout(AbstractBuild build, Launcher launcher, FilePath workspace, BuildListener listener, File changelogFile) throws IOException, InterruptedException {
        boolean checkoutResult = false;
        CmvcChangeLogSet cmvcChangeLogSet = null;
        try {
            cmvcChangeLogSet = this.getCmvcChangeLogSet(build, launcher, workspace, listener, changelogFile);
            if (cmvcChangeLogSet != null) {
                checkoutResult = cmvcChangeLogSet.getTrackNames() != null ? this.doCheckout(build, launcher, workspace, listener, changelogFile, cmvcChangeLogSet) : true;
                listener.getLogger().print("Writing changelog file.");
                this.writeChangeLogFile(changelogFile, cmvcChangeLogSet);
            }
        }
        catch (Throwable e) {
            listener.fatalError("Error performing checkout: " + e.getMessage(), new Object[]{e});
            checkoutResult = false;
        }
        return checkoutResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeChangeLogFile(File changelogFile, CmvcChangeLogSet cmvcChangeLogSet) throws IOException {
        FileWriter fileWriter = new FileWriter(changelogFile);
        try {
            CmvcRawParser.writeChangeLogFile(cmvcChangeLogSet, fileWriter);
        }
        finally {
            IOUtils.closeQuietly((Writer)fileWriter);
        }
    }

    private boolean doCheckout(AbstractBuild build, Launcher launcher, FilePath workspace, BuildListener listener, File changelogFile, CmvcChangeLogSet cmvcChangeLogSet) throws IOException, InterruptedException {
        listener.getLogger().print("Wiping out workspace.");
        workspace.deleteContents();
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        if (this.isGroovyCheckoutScript() && !launcher.isUnix()) {
            cmd.add("groovy");
        }
        cmd.add(this.checkoutScript);
        cmd.addQuoted(this.getCmvcCommandLineUtil().convertToUnixQuotedParameter(cmvcChangeLogSet.getTrackNames().toArray(new String[0])));
        listener.getLogger().print("Invoking checkout script.");
        return this.run(launcher, cmd, (TaskListener)listener, workspace, build);
    }

    private boolean isGroovyCheckoutScript() {
        return FilenameUtils.isExtension((String)this.checkoutScript, (String)".groovy");
    }

    private CmvcChangeLogSet getCmvcChangeLogSet(AbstractBuild build, Launcher launcher, FilePath workspace, BuildListener listener, File changelogFile) throws IOException, InterruptedException, ParseException {
        ByteArrayOutputStream baos;
        CmvcChangeLogSet changeLogSet = null;
        ArgumentListBuilder cmd = this.generateChangesDetectionCommand(build.getProject(), (TaskListener)listener);
        if (!this.run(launcher, cmd, (TaskListener)listener, workspace, (OutputStream)new ForkOutputStream((OutputStream)(baos = new ByteArrayOutputStream()), (OutputStream)listener.getLogger()), build)) {
            throw new IOException("Error while checking for tracks");
        }
        BufferedReader in = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(baos.toByteArray())));
        changeLogSet = new CmvcChangeLogSet(build);
        List<CmvcChangeLogSet.CmvcChangeLog> logs = CmvcRawParser.parseTrackViewReport(in, changeLogSet);
        changeLogSet.setLogs(logs);
        cmd = this.getCmvcCommandLineUtil().buildReportChangeViewCommand(changeLogSet);
        baos.reset();
        if (cmd != null) {
            if (this.run(launcher, cmd, (TaskListener)listener, workspace, (OutputStream)new ForkOutputStream((OutputStream)baos, (OutputStream)listener.getLogger()), build)) {
                in = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(baos.toByteArray())));
                CmvcRawParser.parseChangeViewReportAndPopulateChangeLogs(in, changeLogSet);
            } else {
                throw new IOException("Error while checking for changes");
            }
        }
        return changeLogSet;
    }

    public ChangeLogParser createChangeLogParser() {
        return new CmvcChangeLogParser();
    }

    public SCMDescriptor<CmvcSCM> getDescriptor() {
        return DESCRIPTOR;
    }

    public boolean pollChanges(AbstractProject project, Launcher launcher, FilePath workspace, TaskListener listener) throws IOException, InterruptedException {
        ByteArrayOutputStream baos;
        if (project.getLastBuild() == null) {
            listener.getLogger().println("No existing build. Starting a new one");
            return true;
        }
        ArgumentListBuilder cmd = this.generateChangesDetectionCommand(project, listener);
        if (!this.run(launcher, cmd, listener, workspace, (OutputStream)new ForkOutputStream((OutputStream)(baos = new ByteArrayOutputStream()), (OutputStream)listener.getLogger()), null)) {
            return false;
        }
        BufferedReader in = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(baos.toByteArray())));
        return CmvcRawParser.parseTrackViewReport(in);
    }

    private ArgumentListBuilder generateChangesDetectionCommand(AbstractProject project, TaskListener listener) {
        Date lastBuild = null;
        if (project.getLastSuccessfulBuild() != null) {
            lastBuild = project.getLastSuccessfulBuild().getTimestamp().getTime();
        } else {
            listener.getLogger().println("No existing successful build.");
            lastBuild = DateUtil.MIN_DATE;
        }
        ArgumentListBuilder cmd = this.getCmvcCommandLineUtil().buildReportTrackViewCommand(DateUtil.convertToCmvcDate(new Date()), DateUtil.convertToCmvcDate(lastBuild));
        return cmd;
    }

    protected final boolean run(Launcher launcher, ArgumentListBuilder cmd, TaskListener listener, FilePath dir, OutputStream out, AbstractBuild build) throws IOException, InterruptedException {
        Map<String, String> env = this.createEnvVarMap(true, build);
        int r = launcher.launch(cmd.toCommandArray(), env, out, dir).join();
        if (r != 0) {
            listener.fatalError(this.getDescriptor().getDisplayName() + " failed. exit code=" + r);
        }
        return r == 0;
    }

    protected final boolean run(Launcher launcher, ArgumentListBuilder cmd, TaskListener listener, FilePath dir, AbstractBuild build) throws IOException, InterruptedException {
        return this.run(launcher, cmd, listener, dir, listener.getLogger(), build);
    }

    protected final Map<String, String> createEnvVarMap(boolean overrideOnly, AbstractBuild build) {
        EnvVars env = new HashMap();
        try {
            if (build != null) {
                env = build.getEnvironment();
            }
        }
        catch (IOException e) {
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        if (!overrideOnly) {
            env.putAll(EnvVars.masterEnvVars);
        }
        return env;
    }

    public void buildEnvVars(AbstractBuild build, Map<String, String> env) {
        super.buildEnvVars(build, env);
        env.put("CMVC_FAMILY", this.family);
        env.put("CMVC_RELEASES", this.releases);
        if (StringUtils.isNotEmpty((String)this.become)) {
            env.put("CMVC_BECOME", this.become);
        }
    }

    public String getReleases() {
        return this.releases;
    }

    public String getFamily() {
        return this.family;
    }

    public String getBecome() {
        return this.become;
    }

    public String getCheckoutScript() {
        return this.checkoutScript;
    }

    public void setCheckoutScript(String checkoutScript) {
        this.checkoutScript = checkoutScript;
    }

    public String getTrackViewReportWhereClause() {
        return this.trackViewReportWhereClause;
    }

    public void setTrackViewReportWhereClause(String trackViewReportWhereClause) {
        this.trackViewReportWhereClause = trackViewReportWhereClause;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DescriptorImpl
    extends SCMDescriptor<CmvcSCM>
    implements ModelObject {
        private String cmvcPath;
        private String cmvcVersion;

        protected DescriptorImpl() {
            super(CmvcSCM.class, null);
            this.load();
        }

        public String getDisplayName() {
            return "CMVC";
        }

        public SCM newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            CmvcSCM scm = (CmvcSCM)req.bindJSON(CmvcSCM.class, formData);
            return scm;
        }

        public boolean configure(StaplerRequest req) throws Descriptor.FormException {
            this.cmvcPath = Util.fixEmpty((String)req.getParameter("cmvc.cmvcPath").trim());
            this.save();
            return true;
        }

        public FormValidation doCheckFamily(@QueryParameter String value) {
            if (StringUtils.isEmpty((String)value)) {
                return FormValidation.error((String)Messages.cmvc_family_mandatory());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckReleases(@QueryParameter String value) {
            if (StringUtils.isEmpty((String)value)) {
                return FormValidation.error((String)Messages.cmvc_releases_mandatory());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckCheckoutScript(@QueryParameter String value) {
            File script;
            if (StringUtils.isNotEmpty((String)value) && !(script = new File(value)).exists()) {
                return FormValidation.error((String)Messages.cmvc_checkoutScript_filenotexist());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckTrackViewReportWhereClause(@QueryParameter String value) {
            if (StringUtils.isNotEmpty((String)value)) {
                // empty if block
            }
            return FormValidation.ok();
        }

        public String getCmvcPath() {
            if (this.cmvcPath == null) {
                return "c:/cmvc/exe";
            }
            return this.cmvcPath;
        }

        public String getCmvcVersion() {
            if (this.cmvcVersion == null) {
                return "2.0";
            }
            return this.cmvcVersion;
        }

        public void setCmvcVersion(String cmvcVersion) {
            this.cmvcVersion = cmvcVersion;
        }
    }
}

