/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cmvc.util;

import hudson.Util;
import hudson.plugins.cmvc.CmvcChangeLogSet;
import hudson.plugins.cmvc.CmvcSCM;
import hudson.util.ArgumentListBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;

public class CommandLineUtil {
    private CmvcSCM cmvcSCM = null;

    public CommandLineUtil(CmvcSCM cmvcSCM) {
        this.cmvcSCM = cmvcSCM;
    }

    public ArgumentListBuilder buildReportTrackViewCommand(String strNow, String strLastBuild) {
        ArgumentListBuilder command = this.buildBasicRawReportCommand("TrackView");
        command.add("-where");
        if (StringUtils.isEmpty((String)this.cmvcSCM.getTrackViewReportWhereClause())) {
            command.add("lastUpdate between " + strLastBuild + " and " + strNow + " and state = 'integrate' and releaseName in " + this.convertToReleaseInClause(this.cmvcSCM.getReleases()) + " order by defectName");
        } else {
            HashMap<String, String> props = new HashMap<String, String>(2);
            props.put("now", strNow);
            props.put("lastBuild", strLastBuild);
            props.put("releases", this.convertToReleaseInClause(this.cmvcSCM.getReleases()));
            command.add(Util.replaceMacro((String)this.cmvcSCM.getTrackViewReportWhereClause(), props));
        }
        return command;
    }

    public ArgumentListBuilder buildReportChangeViewCommand(String[] trackNames) {
        ArgumentListBuilder command = this.buildBasicRawReportCommand("ChangeView");
        command.add("-where");
        command.add("defectName in " + this.convertToInClause(trackNames) + " and releaseName in " + this.convertToReleaseInClause(this.cmvcSCM.getReleases()) + " order by defectName , pathName , versionSID");
        return command;
    }

    public ArgumentListBuilder buildReportChangeViewCommand(CmvcChangeLogSet changeLogSet) {
        List<CmvcChangeLogSet.CmvcChangeLog> changeLogs = changeLogSet.getLogs();
        if (changeLogs.size() > 0) {
            TreeSet<String> trackNames = new TreeSet<String>();
            for (CmvcChangeLogSet.CmvcChangeLog log : changeLogs) {
                trackNames.add(log.getTrackName());
            }
            return this.buildReportChangeViewCommand(trackNames.toArray(new String[0]));
        }
        return null;
    }

    private ArgumentListBuilder buildBasicRawReportCommand(String viewName) {
        ArgumentListBuilder command = new ArgumentListBuilder();
        command.add("Report");
        command.add("-family");
        command.add(this.cmvcSCM.getFamily());
        if (StringUtils.isNotEmpty((String)this.cmvcSCM.getBecome())) {
            command.add("-become");
            command.add(this.cmvcSCM.getBecome());
        }
        command.add("-raw");
        command.add("-view");
        command.add(viewName);
        return command;
    }

    public String convertToInClause(String[] releaseList) {
        StringBuffer buf = new StringBuffer("(");
        int length = releaseList.length;
        for (int i = 0; i < length; ++i) {
            String temp = releaseList[i].trim();
            buf.append("'" + temp + "'");
            buf.append(i != length - 1 ? ", " : ")");
        }
        return buf.toString();
    }

    private String convertToReleaseInClause(String rel) {
        String[] releaseList = rel.split(",");
        return this.convertToInClause(releaseList);
    }

    public String convertToUnixQuotedParameter(String[] trackList) {
        int length = trackList.length;
        if (length < 1) {
            return "";
        }
        StringBuffer buf = new StringBuffer("");
        for (int i = 0; i < length; ++i) {
            String temp = trackList[i].trim();
            buf.append(temp);
            buf.append(i != length - 1 ? " " : "");
        }
        return buf.toString();
    }
}

