/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cmvc;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.TaskListener;
import hudson.plugins.cmvc.CmvcChangeLogParser;
import hudson.plugins.cmvc.CmvcChangeLogSet;
import hudson.plugins.cmvc.CmvcSCM;
import hudson.plugins.cmvc.util.CmvcRawParser;
import hudson.plugins.cmvc.util.CommandLineUtil;
import hudson.plugins.cmvc.util.DateUtil;
import hudson.scm.ChangeLogParser;
import hudson.scm.SCM;
import hudson.scm.SCMDescriptor;
import hudson.util.ArgumentListBuilder;
import hudson.util.ForkOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmvcSCM
extends SCM
implements Serializable {
    private static final long serialVersionUID = -6712277029373852186L;
    private String family;
    private String releases;
    private String become;
    private String checkoutScript;
    private String trackViewReportWhereClause;
    private CommandLineUtil commandLineUtil = null;
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public CmvcSCM(String family, String become, String releases, String checkoutScript, String trackViewReportWhereClause) {
        this.checkoutScript = checkoutScript;
        this.family = family;
        this.releases = releases;
        this.become = become;
        this.trackViewReportWhereClause = trackViewReportWhereClause;
    }

    private CommandLineUtil getCmvcCommandLineUtil() {
        return this.commandLineUtil != null ? this.commandLineUtil : new CommandLineUtil(this);
    }

    public boolean checkout(AbstractBuild build, Launcher launcher, FilePath workspace, BuildListener listener, File changelogFile) throws IOException, InterruptedException {
        boolean checkoutResult = false;
        CmvcChangeLogSet cmvcChangeLogSet = null;
        try {
            cmvcChangeLogSet = this.getCmvcChangeLogSet(build, launcher, workspace, listener, changelogFile);
            if (cmvcChangeLogSet != null) {
                checkoutResult = cmvcChangeLogSet.getTrackNames() != null ? this.doCheckout(build, launcher, workspace, listener, changelogFile, cmvcChangeLogSet) : true;
                listener.getLogger().print("Writing changelog file.");
                this.writeChangeLogFile(changelogFile, cmvcChangeLogSet);
            }
        }
        catch (Throwable e) {
            listener.fatalError("Error performing checkout: " + e.getMessage(), new Object[]{e});
            checkoutResult = false;
        }
        return checkoutResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeChangeLogFile(File changelogFile, CmvcChangeLogSet cmvcChangeLogSet) throws IOException {
        FileWriter fileWriter = new FileWriter(changelogFile);
        try {
            CmvcRawParser.writeChangeLogFile((CmvcChangeLogSet)cmvcChangeLogSet, (Writer)fileWriter);
        }
        finally {
            IOUtils.closeQuietly((Writer)fileWriter);
        }
    }

    private boolean doCheckout(AbstractBuild build, Launcher launcher, FilePath workspace, BuildListener listener, File changelogFile, CmvcChangeLogSet cmvcChangeLogSet) throws IOException, InterruptedException {
        String[] releases;
        listener.getLogger().println("Wiping out workspace.");
        workspace.deleteContents();
        ArgumentListBuilder cmd = null;
        for (String release : releases = this.getReleases().split(",")) {
            release = release.trim();
            String[] tracksToCheckout = cmvcChangeLogSet.getTracksPerRelease(release).toArray(new String[0]);
            String tracksParameter = this.getCmvcCommandLineUtil().convertToUnixQuotedParameter(tracksToCheckout);
            if ("".equals(tracksParameter)) {
                listener.getLogger().println("No tracks found to release " + release);
                continue;
            }
            cmd = this.createCheckoutCommand(launcher, release, tracksParameter);
            listener.getLogger().println("Invoking checkout script. Release: " + release);
            if (this.run(launcher, cmd, (TaskListener)listener, workspace, build)) continue;
            return false;
        }
        return true;
    }

    private ArgumentListBuilder createCheckoutCommand(Launcher launcher, String release, String tracksParameter) {
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        if (this.isGroovyCheckoutScript() && !launcher.isUnix()) {
            cmd.add("groovy");
        }
        cmd.add(this.checkoutScript);
        cmd.addQuoted(tracksParameter);
        cmd.add(release);
        return cmd;
    }

    private boolean isGroovyCheckoutScript() {
        return FilenameUtils.isExtension((String)this.checkoutScript, (String)".groovy");
    }

    private CmvcChangeLogSet getCmvcChangeLogSet(AbstractBuild build, Launcher launcher, FilePath workspace, BuildListener listener, File changelogFile) throws IOException, InterruptedException, ParseException {
        ByteArrayOutputStream baos;
        CmvcChangeLogSet changeLogSet = null;
        ArgumentListBuilder cmd = this.generateChangesDetectionCommand(build.getProject(), (TaskListener)listener);
        if (!this.run(launcher, cmd, (TaskListener)listener, workspace, (OutputStream)new ForkOutputStream((OutputStream)(baos = new ByteArrayOutputStream()), (OutputStream)listener.getLogger()), build)) {
            throw new IOException("Error while checking for tracks");
        }
        BufferedReader in = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(baos.toByteArray())));
        changeLogSet = new CmvcChangeLogSet(build);
        List logs = CmvcRawParser.parseTrackViewReport((Reader)in, (CmvcChangeLogSet)changeLogSet);
        changeLogSet.setLogs(logs);
        cmd = this.getCmvcCommandLineUtil().buildReportChangeViewCommand(changeLogSet);
        baos.reset();
        if (cmd != null) {
            if (this.run(launcher, cmd, (TaskListener)listener, workspace, (OutputStream)new ForkOutputStream((OutputStream)baos, (OutputStream)listener.getLogger()), build)) {
                in = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(baos.toByteArray())));
                CmvcRawParser.parseChangeViewReportAndPopulateChangeLogs((Reader)in, (CmvcChangeLogSet)changeLogSet);
            } else {
                throw new IOException("Error while checking for changes");
            }
        }
        return changeLogSet;
    }

    public ChangeLogParser createChangeLogParser() {
        return new CmvcChangeLogParser();
    }

    public SCMDescriptor<CmvcSCM> getDescriptor() {
        return DESCRIPTOR;
    }

    public boolean pollChanges(AbstractProject project, Launcher launcher, FilePath workspace, TaskListener listener) throws IOException, InterruptedException {
        ByteArrayOutputStream baos;
        if (project.getLastBuild() == null) {
            listener.getLogger().println("No existing build. Starting a new one");
            return true;
        }
        ArgumentListBuilder cmd = this.generateChangesDetectionCommand(project, listener);
        if (!this.run(launcher, cmd, listener, workspace, (OutputStream)new ForkOutputStream((OutputStream)(baos = new ByteArrayOutputStream()), (OutputStream)listener.getLogger()), null)) {
            return false;
        }
        BufferedReader in = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(baos.toByteArray())));
        return CmvcRawParser.parseTrackViewReport((Reader)in);
    }

    private ArgumentListBuilder generateChangesDetectionCommand(AbstractProject project, TaskListener listener) {
        Date lastBuild = null;
        if (project.getLastSuccessfulBuild() != null) {
            lastBuild = project.getLastSuccessfulBuild().getTimestamp().getTime();
        } else {
            listener.getLogger().println("No existing successful build.");
            lastBuild = DateUtil.MIN_DATE;
        }
        ArgumentListBuilder cmd = this.getCmvcCommandLineUtil().buildReportTrackViewCommand(DateUtil.convertToCmvcDate((Date)new Date()), DateUtil.convertToCmvcDate((Date)lastBuild));
        return cmd;
    }

    protected final boolean run(Launcher launcher, ArgumentListBuilder cmd, TaskListener listener, FilePath dir, OutputStream out, AbstractBuild build) throws IOException, InterruptedException {
        Map env = this.createEnvVarMap(true, build);
        int r = launcher.launch().cmds(cmd).envs(env).stdout(out).pwd(dir).join();
        if (r != 0) {
            listener.fatalError(this.getDescriptor().getDisplayName() + " failed. exit code=" + r);
        }
        return r == 0;
    }

    protected final boolean run(Launcher launcher, ArgumentListBuilder cmd, TaskListener listener, FilePath dir, AbstractBuild build) throws IOException, InterruptedException {
        return this.run(launcher, cmd, listener, dir, (OutputStream)listener.getLogger(), build);
    }

    protected final Map<String, String> createEnvVarMap(boolean overrideOnly, AbstractBuild build) {
        EnvVars env = new HashMap();
        try {
            if (build != null) {
                env = build.getEnvironment(TaskListener.NULL);
            }
        }
        catch (IOException e) {
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        if (!overrideOnly) {
            env.putAll(EnvVars.masterEnvVars);
        }
        return env;
    }

    public void buildEnvVars(AbstractBuild build, Map<String, String> env) {
        super.buildEnvVars(build, env);
        env.put("CMVC_FAMILY", this.family);
        env.put("CMVC_RELEASES", this.releases);
        if (StringUtils.isNotEmpty((String)this.become)) {
            env.put("CMVC_BECOME", this.become);
        }
    }

    public String getReleases() {
        return this.releases;
    }

    public String getFamily() {
        return this.family;
    }

    public String getBecome() {
        return this.become;
    }

    public String getCheckoutScript() {
        return this.checkoutScript;
    }

    public void setCheckoutScript(String checkoutScript) {
        this.checkoutScript = checkoutScript;
    }

    public String getTrackViewReportWhereClause() {
        return this.trackViewReportWhereClause;
    }

    public void setTrackViewReportWhereClause(String trackViewReportWhereClause) {
        this.trackViewReportWhereClause = trackViewReportWhereClause;
    }
}

