/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cmvc.util;

import com.Ostermiller.util.CSVParser;
import com.thoughtworks.xstream.XStream;
import hudson.model.User;
import hudson.plugins.cmvc.CmvcChangeLogSet;
import hudson.plugins.cmvc.util.DateUtil;
import hudson.scm.ChangeLogSet;
import hudson.util.Digester2;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.locale.converters.DateLocaleConverter;
import org.apache.commons.lang.StringUtils;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmvcRawParser {
    private static CSVParser parser = null;

    public static List<CmvcChangeLogSet.CmvcChangeLog> parseTrackViewReport(Reader rawResult, CmvcChangeLogSet changeLogSet) throws IOException, ParseException {
        String[][] parsedResult = CmvcRawParser.parseCmvcRawReport(rawResult);
        ArrayList<CmvcChangeLogSet.CmvcChangeLog> changes = null;
        if (parsedResult == null || parsedResult.length <= 0) {
            changes = new ArrayList<CmvcChangeLogSet.CmvcChangeLog>(0);
        } else {
            int totalChanges = parsedResult.length;
            changes = new ArrayList(totalChanges);
            CmvcChangeLogSet.CmvcChangeLog changeLog = null;
            for (int i = 0; i < totalChanges; ++i) {
                changeLog = new CmvcChangeLogSet.CmvcChangeLog(changeLogSet);
                changeLog.setDateTime(DateUtil.convertFromCmvcDate(parsedResult[i][10]));
                changeLog.setReleaseName(parsedResult[i][0]);
                changeLog.setTrackName(parsedResult[i][1]);
                changeLog.setMsg(parsedResult[i][12]);
                changeLog.setType("f".equals(parsedResult[i][11]) ? "feature" : "defect");
                changeLog.setUser(StringUtils.isEmpty((String)parsedResult[i][6]) ? null : parsedResult[i][6]);
                changes.add(changeLog);
            }
        }
        return changes;
    }

    public static boolean parseTrackViewReport(Reader rawResult) throws IOException {
        String[][] parsedResult = CmvcRawParser.parseCmvcRawReport(rawResult);
        return parsedResult != null && parsedResult.length > 0;
    }

    private static String[][] parseCmvcRawReport(Reader rawResult) throws IOException {
        parser = new CSVParser(rawResult, '|');
        String[][] parsedResult = parser.getAllValues();
        return parsedResult;
    }

    private static Map<String, List<CmvcChangeLogSet.CmvcChangeLog.ModifiedFile>> parseReportChangeViewReader(Reader rawResult) throws IOException {
        HashMap<String, List<CmvcChangeLogSet.CmvcChangeLog.ModifiedFile>> modifiedFilesByDefectName = new HashMap<String, List<CmvcChangeLogSet.CmvcChangeLog.ModifiedFile>>();
        String[][] changes = CmvcRawParser.parseCmvcRawReport(rawResult);
        if (changes != null && changes.length > 0) {
            for (int i = 0; i < changes.length; ++i) {
                List<CmvcChangeLogSet.CmvcChangeLog.ModifiedFile> modifiedFiles;
                String defectName = changes[i][1];
                if (modifiedFilesByDefectName.containsKey(defectName)) {
                    modifiedFiles = (List)modifiedFilesByDefectName.get(defectName);
                } else {
                    modifiedFiles = new ArrayList();
                    modifiedFilesByDefectName.put(defectName, modifiedFiles);
                }
                String strFilename = changes[i][4];
                String strVersion = changes[i][3];
                CmvcChangeLogSet.CmvcChangeLog.ModifiedFile modifiedFile = new CmvcChangeLogSet.CmvcChangeLog.ModifiedFile(strFilename, changes[i][5], strVersion);
                modifiedFiles.add(modifiedFile);
            }
        }
        return modifiedFilesByDefectName;
    }

    public static List<CmvcChangeLogSet.CmvcChangeLog.ModifiedFile> parseChangeViewReport(Reader rawResult) throws IOException, ParseException {
        String[][] changes = CmvcRawParser.parseCmvcRawReport(rawResult);
        if (changes == null || changes.length <= 0) {
            return new ArrayList<CmvcChangeLogSet.CmvcChangeLog.ModifiedFile>(0);
        }
        ArrayList<CmvcChangeLogSet.CmvcChangeLog.ModifiedFile> modifiedFiles = new ArrayList<CmvcChangeLogSet.CmvcChangeLog.ModifiedFile>(changes.length);
        for (int i = 0; i < changes.length; ++i) {
            String strFilename = changes[i][4];
            String strVersion = changes[i][3];
            CmvcChangeLogSet.CmvcChangeLog.ModifiedFile modifiedFile = new CmvcChangeLogSet.CmvcChangeLog.ModifiedFile(strFilename, changes[i][5], strVersion);
            modifiedFiles.add(modifiedFile);
        }
        return modifiedFiles;
    }

    public static void parseChangeViewReportAndPopulateChangeLogs(Reader rawResult, CmvcChangeLogSet changeLogSet) throws IOException, ParseException {
        Map<String, List<CmvcChangeLogSet.CmvcChangeLog.ModifiedFile>> modifiedFilesByDefectName = CmvcRawParser.parseReportChangeViewReader(rawResult);
        changeLogSet.setTrackNames(modifiedFilesByDefectName.keySet());
        for (CmvcChangeLogSet.CmvcChangeLog log : changeLogSet.getLogs()) {
            if (!modifiedFilesByDefectName.containsKey(log.getTrackName())) continue;
            log.setFiles(modifiedFilesByDefectName.get(log.getTrackName()));
        }
    }

    public static void writeChangeLogFile(CmvcChangeLogSet changes, Writer writer) {
        XStream xstream = CmvcRawParser.getXStream();
        xstream.toXML((Object)changes, writer);
    }

    private static XStream getXStream() {
        XStream xstream = new XStream();
        xstream.setMode(1001);
        xstream.alias("changes", CmvcChangeLogSet.class);
        xstream.alias("change", CmvcChangeLogSet.CmvcChangeLog.class);
        xstream.alias("file", CmvcChangeLogSet.CmvcChangeLog.ModifiedFile.class);
        xstream.addImplicitCollection(CmvcChangeLogSet.class, "logs", CmvcChangeLogSet.CmvcChangeLog.class);
        xstream.omitField(ChangeLogSet.class, "build");
        xstream.omitField(ChangeLogSet.Entry.class, "parent");
        xstream.omitField(User.class, "properties");
        return xstream;
    }

    public static CmvcChangeLogSet parseChangeLogFile(Reader xml, CmvcChangeLogSet changeLogSet) {
        XStream xstream = CmvcRawParser.getXStream();
        return (CmvcChangeLogSet)((Object)xstream.fromXML(xml, (Object)changeLogSet));
    }

    public static List<CmvcChangeLogSet.CmvcChangeLog> parseChangeLogFile(Reader reader) throws IOException, SAXException {
        Digester2 digester = new Digester2();
        ArrayList<CmvcChangeLogSet.CmvcChangeLog> r = new ArrayList<CmvcChangeLogSet.CmvcChangeLog>();
        String pattern = "yyyy-MM-dd HH:mm:ss.0 z";
        Locale locale = Locale.getDefault();
        DateLocaleConverter converter = new DateLocaleConverter(locale, pattern);
        converter.setLenient(true);
        ConvertUtils.register((Converter)converter, Date.class);
        digester.push(r);
        digester.addObjectCreate("*/change", CmvcChangeLogSet.CmvcChangeLog.class);
        digester.addBeanPropertySetter("*/change/dateTime");
        digester.addBeanPropertySetter("*/change/author/fullName", "user");
        digester.addBeanPropertySetter("*/change/msg");
        digester.addBeanPropertySetter("*/change/type");
        digester.addBeanPropertySetter("*/change/trackName");
        digester.addObjectCreate("*/change/files/file", CmvcChangeLogSet.CmvcChangeLog.ModifiedFile.class);
        digester.addBeanPropertySetter("*/change/files/file/path");
        digester.addBeanPropertySetter("*/change/files/file/action");
        digester.addBeanPropertySetter("*/change/files/file/version");
        digester.addSetNext("*/change/files/file", "addFile");
        digester.addSetNext("*/change", "add");
        digester.parse(reader);
        return r;
    }
}

