/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cmvc.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DateUtil {
    private static final String CMVC_DATE_FORMAT_INOUT = "yy/MM/dd HH:mm:ss";
    private static final SimpleDateFormat SDF = new SimpleDateFormat("yy/MM/dd HH:mm:ss");
    private static final Calendar CALENDAR = Calendar.getInstance();
    public static final Date MIN_DATE;

    private DateUtil() {
    }

    public static Date convertFromCmvcDate(String cmvcDate) throws ParseException {
        if (cmvcDate != null && !"".equals(cmvcDate)) {
            return SDF.parse(cmvcDate.substring(1));
        }
        return null;
    }

    public static String convertToCmvcDate(Date lastBuild) {
        if (lastBuild != null) {
            CALENDAR.setTime(lastBuild);
            String sufix = CALENDAR.get(1) < 2000 ? "0" : "1";
            return "'" + sufix + SDF.format(lastBuild) + "'";
        }
        return null;
    }

    static {
        CALENDAR.clear();
        CALENDAR.set(CALENDAR.getMinimum(1), CALENDAR.getMinimum(2), CALENDAR.getMinimum(5), CALENDAR.getMinimum(11), CALENDAR.getMinimum(12), CALENDAR.getMinimum(13));
        MIN_DATE = CALENDAR.getTime();
    }
}

