/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cobertura.targets;

import hudson.plugins.cobertura.Ratio;
import hudson.plugins.cobertura.targets.CoverageAggregationMode;
import hudson.plugins.cobertura.targets.CoverageElement;
import hudson.plugins.cobertura.targets.CoverageMetric;
import java.io.Serializable;
import java.util.EnumMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoverageAggregationRule
implements Serializable {
    private final CoverageElement source;
    private final CoverageMetric input;
    private final CoverageAggregationMode mode;
    private final CoverageMetric output;
    private static final CoverageAggregationRule[] INITIAL_RULESET = new CoverageAggregationRule[]{new CoverageAggregationRule(CoverageElement.JAVA_METHOD, CoverageMetric.LINE, CoverageAggregationMode.SUM, CoverageMetric.LINE), new CoverageAggregationRule(CoverageElement.JAVA_METHOD, CoverageMetric.CONDITIONAL, CoverageAggregationMode.SUM, CoverageMetric.CONDITIONAL), new CoverageAggregationRule(CoverageElement.JAVA_METHOD, CoverageMetric.LINE, CoverageAggregationMode.COUNT_NON_ZERO, CoverageMetric.METHOD), new CoverageAggregationRule(CoverageElement.JAVA_CLASS, CoverageMetric.LINE, CoverageAggregationMode.SUM, CoverageMetric.LINE), new CoverageAggregationRule(CoverageElement.JAVA_CLASS, CoverageMetric.CONDITIONAL, CoverageAggregationMode.SUM, CoverageMetric.CONDITIONAL), new CoverageAggregationRule(CoverageElement.JAVA_CLASS, CoverageMetric.METHOD, CoverageAggregationMode.SUM, CoverageMetric.METHOD), new CoverageAggregationRule(CoverageElement.JAVA_CLASS, CoverageMetric.LINE, CoverageAggregationMode.COUNT_NON_ZERO, CoverageMetric.CLASSES), new CoverageAggregationRule(CoverageElement.JAVA_FILE, CoverageMetric.LINE, CoverageAggregationMode.SUM, CoverageMetric.LINE), new CoverageAggregationRule(CoverageElement.JAVA_FILE, CoverageMetric.CONDITIONAL, CoverageAggregationMode.SUM, CoverageMetric.CONDITIONAL), new CoverageAggregationRule(CoverageElement.JAVA_FILE, CoverageMetric.METHOD, CoverageAggregationMode.SUM, CoverageMetric.METHOD), new CoverageAggregationRule(CoverageElement.JAVA_FILE, CoverageMetric.CLASSES, CoverageAggregationMode.SUM, CoverageMetric.CLASSES), new CoverageAggregationRule(CoverageElement.JAVA_FILE, CoverageMetric.LINE, CoverageAggregationMode.COUNT_NON_ZERO, CoverageMetric.FILES), new CoverageAggregationRule(CoverageElement.JAVA_PACKAGE, CoverageMetric.LINE, CoverageAggregationMode.SUM, CoverageMetric.LINE), new CoverageAggregationRule(CoverageElement.JAVA_PACKAGE, CoverageMetric.CONDITIONAL, CoverageAggregationMode.SUM, CoverageMetric.CONDITIONAL), new CoverageAggregationRule(CoverageElement.JAVA_PACKAGE, CoverageMetric.METHOD, CoverageAggregationMode.SUM, CoverageMetric.METHOD), new CoverageAggregationRule(CoverageElement.JAVA_PACKAGE, CoverageMetric.CLASSES, CoverageAggregationMode.SUM, CoverageMetric.CLASSES), new CoverageAggregationRule(CoverageElement.JAVA_PACKAGE, CoverageMetric.FILES, CoverageAggregationMode.SUM, CoverageMetric.FILES), new CoverageAggregationRule(CoverageElement.JAVA_PACKAGE, CoverageMetric.LINE, CoverageAggregationMode.COUNT_NON_ZERO, CoverageMetric.PACKAGES)};

    public CoverageAggregationRule(CoverageElement source, CoverageMetric input, CoverageAggregationMode mode, CoverageMetric output) {
        this.mode = mode;
        this.input = input;
        this.source = source;
        this.output = output;
    }

    public static Map<CoverageMetric, Ratio> aggregate(CoverageElement source, CoverageMetric input, Ratio inputResult, Map<CoverageMetric, Ratio> runningTotal) {
        EnumMap<CoverageMetric, Ratio> result = new EnumMap<CoverageMetric, Ratio>(CoverageMetric.class);
        result.putAll(runningTotal);
        for (CoverageAggregationRule rule : INITIAL_RULESET) {
            if (rule.source != source || rule.input != input) continue;
            Ratio prevTotal = (Ratio)result.get(rule.output);
            if (prevTotal == null) {
                prevTotal = rule.mode.ZERO;
            }
            result.put(rule.output, rule.mode.aggregate(prevTotal, inputResult));
        }
        return result;
    }

    public static Ratio combine(CoverageMetric metric, Ratio existingResult, Ratio additionalResult) {
        return Ratio.create((float)(existingResult.numerator + additionalResult.numerator), (float)(existingResult.denominator + additionalResult.denominator));
    }
}

