/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cobertura;

import hudson.plugins.cobertura.CoberturaXmlHandler;
import hudson.plugins.cobertura.targets.CoverageResult;
import hudson.util.IOException2;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoberturaCoverageParser {
    private CoberturaCoverageParser() {
    }

    public static CoverageResult parse(File inFile, CoverageResult cumulative) throws IOException {
        return CoberturaCoverageParser.parse(inFile, cumulative, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CoverageResult parse(File inFile, CoverageResult cumulative, Set<String> sourcePaths) throws IOException {
        FileInputStream fileInputStream = null;
        BufferedInputStream bufferedInputStream = null;
        try {
            fileInputStream = new FileInputStream(inFile);
            bufferedInputStream = new BufferedInputStream(fileInputStream);
            CoverageResult coverageResult = CoberturaCoverageParser.parse(bufferedInputStream, cumulative, sourcePaths);
            return coverageResult;
        }
        finally {
            try {
                if (bufferedInputStream != null) {
                    bufferedInputStream.close();
                }
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException e) {}
        }
    }

    public static CoverageResult parse(InputStream in, CoverageResult cumulative) throws IOException {
        return CoberturaCoverageParser.parse(in, cumulative, null);
    }

    public static CoverageResult parse(InputStream in, CoverageResult cumulative, Set<String> sourcePaths) throws IOException {
        if (in == null) {
            throw new NullPointerException();
        }
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setValidating(false);
        try {
            factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        }
        catch (ParserConfigurationException e) {
        }
        catch (SAXNotRecognizedException e) {
        }
        catch (SAXNotSupportedException e) {
            // empty catch block
        }
        try {
            SAXParser parser = factory.newSAXParser();
            CoberturaXmlHandler handler = new CoberturaXmlHandler(cumulative);
            parser.parse(in, (DefaultHandler)handler);
            if (sourcePaths != null) {
                sourcePaths.addAll(handler.getSourcePaths());
            }
            return handler.getRootCoverage();
        }
        catch (ParserConfigurationException e) {
            throw new IOException2("Cannot parse coverage results", (Throwable)e);
        }
        catch (SAXException e) {
            throw new IOException2("Cannot parse coverage results", (Throwable)e);
        }
    }
}

