/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cobertura;

import hudson.plugins.cobertura.Ratio;

class CoberturaCoverageTotals {
    private long totalLineCount = 0L;
    private long coverLineCount = 0L;
    private long totalConditionCount = 0L;
    private long coverConditionCount = 0L;
    private long totalMethodCount = 0L;
    private long coverMethodCount = 0L;

    public void addLine(boolean covered) {
        ++this.totalLineCount;
        if (covered) {
            ++this.coverLineCount;
        }
    }

    public void addMethod(boolean covered) {
        ++this.totalMethodCount;
        if (covered) {
            ++this.coverMethodCount;
        }
    }

    public void addLine(boolean covered, int condCoverCount, int condTotalCount) {
        this.addLine(covered);
        this.totalConditionCount += (long)condTotalCount;
        this.coverConditionCount += (long)condCoverCount;
    }

    public void addTotal(CoberturaCoverageTotals sub) {
        this.totalLineCount += sub.totalLineCount;
        this.coverLineCount += sub.coverLineCount;
        this.totalConditionCount += sub.totalConditionCount;
        this.coverConditionCount += sub.coverConditionCount;
        this.totalMethodCount += sub.totalMethodCount;
        this.coverMethodCount += sub.coverMethodCount;
    }

    public Ratio getLineCoverage() {
        return Ratio.create((float)this.coverLineCount, (float)this.totalLineCount);
    }

    public Ratio getConditionalCoverage() {
        return Ratio.create((float)this.coverLineCount, (float)this.totalLineCount);
    }

    public Ratio getMethodCoverage() {
        return Ratio.create((float)this.coverMethodCount, (float)this.totalMethodCount);
    }
}

