/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cobertura.targets;

import hudson.plugins.cobertura.Ratio;
import hudson.plugins.cobertura.targets.CoverageElement;
import hudson.plugins.cobertura.targets.CoverageMetric;
import hudson.plugins.cobertura.targets.CoveragePaint;
import java.io.Serializable;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoveragePaint
implements Serializable {
    private static final long serialVersionUID = -6265259191856193735L;
    protected Map<Integer, CoveragePaintDetails> lines = new HashMap();

    public CoveragePaint(CoverageElement source) {
    }

    public void paint(int line, int hits) {
        CoveragePaintDetails d = (CoveragePaintDetails)this.lines.get(line);
        if (d == null) {
            d = new CoveragePaintDetails(this, 0, 0, 0);
            this.lines.put(line, d);
        }
        d.hitCount += hits;
    }

    public void paint(int line, int hits, int branchCover, int branchCount) {
        CoveragePaintDetails d = (CoveragePaintDetails)this.lines.get(line);
        if (d == null) {
            d = new CoveragePaintDetails(this, hits, branchCount, branchCover);
            this.lines.put(line, d);
        } else {
            d.hitCount += hits;
            if (d.branchCount == 0) {
                d.branchCount = branchCount;
                d.branchCoverage = branchCover;
            } else {
                d.branchCount = Math.max(d.branchCount, branchCount);
                d.branchCoverage = Math.max(d.branchCoverage, branchCover);
            }
        }
    }

    public void add(CoveragePaint child) {
        for (Map.Entry e : child.lines.entrySet()) {
            CoveragePaintDetails d = (CoveragePaintDetails)this.lines.get(e.getKey());
            if (d != null) {
                d.hitCount += ((CoveragePaintDetails)e.getValue()).hitCount;
                d.branchCount = Math.max(d.branchCount, ((CoveragePaintDetails)e.getValue()).branchCount);
                if (d.branchCount == 0) continue;
                d.branchCoverage = Math.max(d.branchCoverage, ((CoveragePaintDetails)e.getValue()).branchCoverage);
                continue;
            }
            CoveragePaintDetails dc = (CoveragePaintDetails)e.getValue();
            d = new CoveragePaintDetails(this, dc.hitCount, dc.branchCount, dc.branchCoverage);
            this.lines.put(e.getKey(), d);
        }
    }

    public Ratio getLineCoverage() {
        int covered = 0;
        for (CoveragePaintDetails d : this.lines.values()) {
            if (d.hitCount <= 0) continue;
            ++covered;
        }
        return Ratio.create((float)covered, (float)this.lines.size());
    }

    public Ratio getConditionalCoverage() {
        long maxTotal = 0L;
        long total = 0L;
        for (CoveragePaintDetails d : this.lines.values()) {
            maxTotal += (long)d.branchCount;
            total += (long)d.branchCoverage;
        }
        return Ratio.create((float)total, (float)maxTotal);
    }

    public Map<CoverageMetric, Ratio> getResults() {
        EnumMap<CoverageMetric, Ratio> result = new EnumMap<CoverageMetric, Ratio>(CoverageMetric.class);
        result.put(CoverageMetric.LINE, this.getLineCoverage());
        result.put(CoverageMetric.CONDITIONAL, this.getConditionalCoverage());
        return result;
    }

    public boolean isPainted(int line) {
        return this.lines.get(line) != null;
    }

    public int getHits(int line) {
        CoveragePaintDetails d = (CoveragePaintDetails)this.lines.get(line);
        if (d == null) {
            return 0;
        }
        return d.hitCount;
    }

    public int getBranchTotal(int line) {
        CoveragePaintDetails d = (CoveragePaintDetails)this.lines.get(line);
        if (d == null) {
            return 0;
        }
        return d.branchCount;
    }

    public int getBranchCoverage(int line) {
        CoveragePaintDetails d = (CoveragePaintDetails)this.lines.get(line);
        if (d == null) {
            return 0;
        }
        return d.branchCoverage;
    }
}

