/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cobertura;

import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractItem;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Build;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Project;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.plugins.cobertura.CoberturaBuildAction;
import hudson.plugins.cobertura.CoberturaCoverageParser;
import hudson.plugins.cobertura.CoberturaProjectAction;
import hudson.plugins.cobertura.CoberturaPublisher;
import hudson.plugins.cobertura.CoberturaPublisherTarget;
import hudson.plugins.cobertura.renderers.SourceCodePainter;
import hudson.plugins.cobertura.targets.CoverageMetric;
import hudson.plugins.cobertura.targets.CoverageResult;
import hudson.plugins.cobertura.targets.CoverageTarget;
import hudson.scm.SubversionSCM;
import hudson.tasks.Publisher;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class CoberturaPublisher
extends Publisher {
    private final String coberturaReportFile;
    private final boolean onlyStable;
    private CoverageTarget healthyTarget;
    private CoverageTarget unhealthyTarget;
    private CoverageTarget failingTarget;
    public static final CoberturaReportFilenameFilter COBERTURA_FILENAME_FILTER = new CoberturaReportFilenameFilter(null);
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    public CoberturaPublisher(String coberturaReportFile, boolean onlyStable) {
        this.coberturaReportFile = coberturaReportFile;
        this.onlyStable = onlyStable;
        this.healthyTarget = new CoverageTarget();
        this.unhealthyTarget = new CoverageTarget();
        this.failingTarget = new CoverageTarget();
    }

    public List<CoberturaPublisherTarget> getTargets() {
        CoberturaPublisherTarget target;
        TreeMap<CoverageMetric, CoberturaPublisherTarget> targets = new TreeMap<CoverageMetric, CoberturaPublisherTarget>();
        for (CoverageMetric metric : this.healthyTarget.getTargets()) {
            target = (CoberturaPublisherTarget)targets.get(metric);
            if (target == null) {
                target = new CoberturaPublisherTarget();
                target.setMetric(metric);
            }
            target.setHealthy(this.healthyTarget.getTarget(metric));
            targets.put(metric, target);
        }
        for (CoverageMetric metric : this.unhealthyTarget.getTargets()) {
            target = (CoberturaPublisherTarget)targets.get(metric);
            if (target == null) {
                target = new CoberturaPublisherTarget();
                target.setMetric(metric);
            }
            target.setUnhealthy(this.unhealthyTarget.getTarget(metric));
            targets.put(metric, target);
        }
        for (CoverageMetric metric : this.failingTarget.getTargets()) {
            target = (CoberturaPublisherTarget)targets.get(metric);
            if (target == null) {
                target = new CoberturaPublisherTarget();
                target.setMetric(metric);
            }
            target.setUnstable(this.failingTarget.getTarget(metric));
            targets.put(metric, target);
        }
        ArrayList<CoberturaPublisherTarget> result = new ArrayList<CoberturaPublisherTarget>(targets.values());
        return result;
    }

    private void setTargets(List<CoberturaPublisherTarget> targets) {
        this.healthyTarget.clear();
        this.unhealthyTarget.clear();
        this.failingTarget.clear();
        for (CoberturaPublisherTarget target : targets) {
            if (target.getHealthy() != null) {
                this.healthyTarget.setTarget(target.getMetric(), target.getHealthy());
            }
            if (target.getUnhealthy() != null) {
                this.unhealthyTarget.setTarget(target.getMetric(), target.getUnhealthy());
            }
            if (target.getUnstable() == null) continue;
            this.failingTarget.setTarget(target.getMetric(), target.getUnstable());
        }
    }

    public String getCoberturaReportFile() {
        return this.coberturaReportFile;
    }

    public boolean getOnlyStable() {
        return this.onlyStable;
    }

    public CoverageTarget getHealthyTarget() {
        return this.healthyTarget;
    }

    public void setHealthyTarget(CoverageTarget healthyTarget) {
        this.healthyTarget = healthyTarget;
    }

    public CoverageTarget getUnhealthyTarget() {
        return this.unhealthyTarget;
    }

    public void setUnhealthyTarget(CoverageTarget unhealthyTarget) {
        this.unhealthyTarget = unhealthyTarget;
    }

    public CoverageTarget getFailingTarget() {
        return this.failingTarget;
    }

    public void setFailingTarget(CoverageTarget failingTarget) {
        this.failingTarget = failingTarget;
    }

    static File getCoberturaReportDir(AbstractItem project) {
        return new File(project.getRootDir(), "cobertura");
    }

    static File[] getCoberturaReports(AbstractBuild build) {
        return build.getRootDir().listFiles((FilenameFilter)COBERTURA_FILENAME_FILTER);
    }

    public boolean perform(Build<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        SubversionSCM scm;
        if (!Result.SUCCESS.equals(build.getResult())) {
            listener.getLogger().println("Skipping Cobertura coverage report as build was not successful...");
            return true;
        }
        listener.getLogger().println("Publishing Cobertura coverage report...");
        Project project = (Project)build.getParent();
        boolean multipleModuleRoots = project.getScm() instanceof SubversionSCM ? (scm = (SubversionSCM)SubversionSCM.class.cast(project.getScm())).getLocations().length > 1 : false;
        FilePath moduleRoot = multipleModuleRoots ? project.getWorkspace() : project.getModuleRoot();
        File buildCoberturaDir = build.getRootDir();
        FilePath buildTarget = new FilePath(buildCoberturaDir);
        FilePath[] reports = new FilePath[]{};
        try {
            reports = moduleRoot.list(this.coberturaReportFile);
            if (build.getResult().isWorseOrEqualTo(Result.FAILURE) && reports.length == 0) {
                return true;
            }
        }
        catch (IOException e) {
            Util.displayIOException((IOException)e, (TaskListener)listener);
            e.printStackTrace(listener.fatalError("Unable to find coverage results"));
            build.setResult(Result.FAILURE);
        }
        if (reports.length == 0) {
            listener.getLogger().println("No coverage results were found using the pattern '" + this.coberturaReportFile + "'.  Did you generate the XML report(s) for Cobertura?");
            build.setResult(Result.FAILURE);
            return true;
        }
        for (int i = 0; i < reports.length; ++i) {
            FilePath targetPath = new FilePath(buildTarget, "coverage" + (i == 0 ? "" : Integer.valueOf(i)) + ".xml");
            try {
                reports[i].copyTo(targetPath);
                continue;
            }
            catch (IOException e) {
                Util.displayIOException((IOException)e, (TaskListener)listener);
                e.printStackTrace(listener.fatalError("Unable to copy coverage from " + reports[i] + " to " + buildTarget));
                build.setResult(Result.FAILURE);
            }
        }
        listener.getLogger().println("Publishing Cobertura coverage results...");
        HashSet sourcePaths = new HashSet();
        CoverageResult result = null;
        for (File coberturaXmlReport : CoberturaPublisher.getCoberturaReports(build)) {
            try {
                result = CoberturaCoverageParser.parse((File)coberturaXmlReport, result, sourcePaths);
            }
            catch (IOException e) {
                Util.displayIOException((IOException)e, (TaskListener)listener);
                e.printStackTrace(listener.fatalError("Unable to parse " + coberturaXmlReport));
                build.setResult(Result.FAILURE);
            }
        }
        if (result != null) {
            result.setOwner(build);
            FilePath paintedSourcesPath = new FilePath(new File(((Project)build.getProject()).getRootDir(), "cobertura"));
            paintedSourcesPath.mkdirs();
            SourceCodePainter painter = new SourceCodePainter(paintedSourcesPath, sourcePaths, result.getPaintedSources());
            moduleRoot.act((FilePath.FileCallable)painter);
            CoberturaBuildAction action = CoberturaBuildAction.load(build, (CoverageResult)result, (CoverageTarget)this.healthyTarget, (CoverageTarget)this.unhealthyTarget, (boolean)this.getOnlyStable());
            build.getActions().add(action);
            Set failingMetrics = this.failingTarget.getFailingMetrics(result);
            if (!failingMetrics.isEmpty()) {
                listener.getLogger().println("Code coverage enforcement failed for the following metrics:");
                for (CoverageMetric metric : failingMetrics) {
                    listener.getLogger().println("    " + metric.getName());
                }
                listener.getLogger().println("Setting Build to unstable.");
                build.setResult(Result.UNSTABLE);
            }
        } else {
            listener.getLogger().println("No coverage results were successfully parsed.  Did you generate the XML report(s) for Cobertura?");
            build.setResult(Result.FAILURE);
        }
        return true;
    }

    public Action getProjectAction(Project project) {
        return new CoberturaProjectAction((AbstractProject)project, this.getOnlyStable());
    }

    public Descriptor<Publisher> getDescriptor() {
        return DESCRIPTOR;
    }

    static /* synthetic */ void access$100(CoberturaPublisher x0, List x1) {
        x0.setTargets(x1);
    }
}

