/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cobertura.targets;

import hudson.plugins.cobertura.Ratio;
import hudson.plugins.cobertura.targets.CoverageElement;
import hudson.plugins.cobertura.targets.CoverageMetric;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class CoveragePaint
implements Serializable {
    private static int[] EMPTY_INT_ARRAY = new int[0];
    private static Integer[] EMPTY_INTEGER_ARRAY = new Integer[0];
    private static boolean[] EMPTY_BOOLEAN_ARRAY = new boolean[0];
    private static int EXTRA_BUFFER_SIZE = 64;
    private final CoverageElement source;
    private boolean[] painted = EMPTY_BOOLEAN_ARRAY;
    private int[] branchCount = EMPTY_INT_ARRAY;
    private int[] hitCount = EMPTY_INT_ARRAY;
    private int[] branchCoverage = EMPTY_INT_ARRAY;

    public CoveragePaint(CoverageElement source) {
        this.source = source;
    }

    private void ensureSize(int line) {
        if (this.painted.length <= line) {
            this.painted = CoveragePaint.copyOf((boolean[])this.painted, (int)(line + EXTRA_BUFFER_SIZE));
            this.hitCount = CoveragePaint.copyOf((int[])this.hitCount, (int)(line + EXTRA_BUFFER_SIZE));
            this.branchCount = CoveragePaint.copyOf((int[])this.branchCount, (int)(line + EXTRA_BUFFER_SIZE));
            this.branchCoverage = CoveragePaint.copyOf((int[])this.branchCoverage, (int)(line + EXTRA_BUFFER_SIZE));
        }
    }

    private static boolean[] copyOf(boolean[] original, int newLength) {
        boolean[] copy = new boolean[newLength];
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }

    private static int[] copyOf(int[] original, int newLength) {
        int[] copy = new int[newLength];
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }

    public void paint(int line, int hits) {
        this.ensureSize(line);
        if (this.painted[line]) {
            int n = line;
            this.hitCount[n] = this.hitCount[n] + hits;
        } else {
            this.painted[line] = true;
            this.hitCount[line] = hits;
            this.branchCount[line] = 0;
            this.branchCoverage[line] = 0;
        }
    }

    public void paint(int line, int hits, int branchCover, int branchCount) {
        this.ensureSize(line);
        if (this.painted[line]) {
            int n = line;
            this.hitCount[n] = this.hitCount[n] + hits;
            if (this.branchCount[line] == 0) {
                this.branchCount[line] = branchCount;
                this.branchCoverage[line] = branchCover;
            } else {
                this.branchCount[line] = Math.max(this.branchCount[line], branchCount);
                this.branchCoverage[line] = Math.max(this.branchCoverage[line], branchCover);
            }
        } else {
            this.painted[line] = true;
            this.hitCount[line] = hits;
            this.branchCount[line] = branchCount;
            this.branchCoverage[line] = branchCover;
        }
    }

    public void add(CoveragePaint child) {
        this.ensureSize(child.painted.length);
        for (int i = 0; i < child.painted.length; ++i) {
            if (!child.painted[i]) continue;
            if (this.painted[i]) {
                int n = i;
                this.hitCount[n] = this.hitCount[n] + child.hitCount[i];
                this.branchCount[i] = Math.max(this.branchCount[i], child.branchCount[i]);
                if (this.branchCount[i] == 0) continue;
                this.branchCoverage[i] = Math.max(this.branchCoverage[i], child.branchCoverage[i]);
                continue;
            }
            this.painted[i] = child.painted[i];
            this.hitCount[i] = child.hitCount[i];
            this.branchCount[i] = child.branchCount[i];
            this.branchCoverage[i] = child.branchCoverage[i];
        }
    }

    public Ratio getLineCoverage() {
        int painted = 0;
        int covered = 0;
        for (int i = 0; i < this.painted.length; ++i) {
            if (!this.painted[i]) continue;
            ++painted;
            if (this.hitCount[i] <= 0) continue;
            ++covered;
        }
        return Ratio.create((float)covered, (float)painted);
    }

    public Ratio getConditionalCoverage() {
        long maxTotal = 0L;
        long total = 0L;
        for (int i = 0; i < this.branchCount.length; ++i) {
            maxTotal += (long)this.branchCount[i];
            total += (long)this.branchCoverage[i];
        }
        return Ratio.create((float)total, (float)maxTotal);
    }

    public Map<CoverageMetric, Ratio> getResults() {
        HashMap<CoverageMetric, Ratio> result = new HashMap<CoverageMetric, Ratio>();
        result.put(CoverageMetric.LINE, this.getLineCoverage());
        result.put(CoverageMetric.CONDITIONAL, this.getConditionalCoverage());
        return result;
    }

    public boolean isPainted(int line) {
        if (line > 0 && line < this.painted.length) {
            return this.painted[line];
        }
        return false;
    }

    public int getHits(int line) {
        if (line > 0 && line < this.painted.length) {
            return this.hitCount[line];
        }
        return 0;
    }

    public int getBranchTotal(int line) {
        if (line > 0 && line < this.painted.length) {
            return this.branchCount[line];
        }
        return 0;
    }

    public int getBranchCoverage(int line) {
        if (line > 0 && line < this.painted.length) {
            return this.branchCoverage[line];
        }
        return 0;
    }
}

