/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cobertura;

import hudson.model.AbstractBuild;
import hudson.model.HealthReport;
import hudson.model.HealthReportingAction;
import hudson.model.Result;
import hudson.plugins.cobertura.CoberturaCoverageParser;
import hudson.plugins.cobertura.CoberturaPublisher;
import hudson.plugins.cobertura.Ratio;
import hudson.plugins.cobertura.targets.CoverageMetric;
import hudson.plugins.cobertura.targets.CoverageResult;
import hudson.plugins.cobertura.targets.CoverageTarget;
import hudson.util.ChartUtil;
import hudson.util.ColorPalette;
import hudson.util.DataSetBuilder;
import hudson.util.ShiftedCategoryAxis;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.data.category.CategoryDataset;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;
import org.kohsuke.stapler.StaplerProxy;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoberturaBuildAction
implements HealthReportingAction,
StaplerProxy {
    private final AbstractBuild<?, ?> owner;
    private CoverageTarget healthyTarget;
    private CoverageTarget unhealthyTarget;
    private Map<CoverageMetric, Ratio> result;
    private HealthReport health = null;
    private transient WeakReference<CoverageResult> report;
    private boolean onlyStable;
    private static final Logger logger = Logger.getLogger(CoberturaBuildAction.class.getName());

    public HealthReport getBuildHealth() {
        if (this.health != null) {
            return this.health;
        }
        if (this.healthyTarget == null || this.unhealthyTarget == null) {
            return null;
        }
        if (this.result == null) {
            CoverageResult projectCoverage = this.getResult();
            this.result = new HashMap<CoverageMetric, Ratio>();
            this.result.putAll(projectCoverage.getResults());
        }
        Map<CoverageMetric, Integer> scores = this.healthyTarget.getRangeScores(this.unhealthyTarget, this.result);
        int minValue = 100;
        CoverageMetric minKey = null;
        for (Map.Entry<CoverageMetric, Integer> e : scores.entrySet()) {
            if (e.getValue() >= minValue) continue;
            minKey = e.getKey();
            minValue = e.getValue();
        }
        if (minKey == null) {
            return null;
        }
        StringBuilder description = new StringBuilder("Cobertura Coverage: ");
        description.append(minKey.getName());
        description.append(" ");
        description.append(this.result.get((Object)minKey).getPercentage());
        description.append("% (");
        description.append(this.result.get((Object)minKey).toString());
        description.append(")");
        this.health = new HealthReport(minValue, description.toString());
        return this.health;
    }

    public String getIconFileName() {
        return "graph.gif";
    }

    public String getDisplayName() {
        return "Coverage Report";
    }

    public String getUrlName() {
        return "cobertura";
    }

    public Object getTarget() {
        return this.getResult();
    }

    public CoberturaBuildAction getPreviousResult() {
        return CoberturaBuildAction.getPreviousResult(this.owner);
    }

    static CoberturaBuildAction getPreviousResult(AbstractBuild start) {
        CoberturaBuildAction r;
        AbstractBuild b = start;
        do {
            if ((b = (AbstractBuild)b.getPreviousNotFailedBuild()) == null) {
                return null;
            }
            assert (b.getResult() != Result.FAILURE) : "We asked for the previous not failed build";
            r = (CoberturaBuildAction)b.getAction(CoberturaBuildAction.class);
            if (!r.includeOnlyStable() || b.getResult() == Result.SUCCESS) continue;
            r = null;
        } while (r == null);
        return r;
    }

    private boolean includeOnlyStable() {
        return this.onlyStable;
    }

    CoberturaBuildAction(AbstractBuild<?, ?> owner, CoverageResult r, CoverageTarget healthyTarget, CoverageTarget unhealthyTarget, boolean onlyStable) {
        this.owner = owner;
        this.report = new WeakReference<CoverageResult>(r);
        this.healthyTarget = healthyTarget;
        this.unhealthyTarget = unhealthyTarget;
        this.onlyStable = onlyStable;
        r.setOwner(owner);
        if (this.result == null) {
            this.result = new HashMap<CoverageMetric, Ratio>();
            this.result.putAll(r.getResults());
        }
        this.getBuildHealth();
    }

    public synchronized CoverageResult getResult() {
        CoverageResult r;
        if (this.report != null && (r = (CoverageResult)this.report.get()) != null) {
            return r;
        }
        r = null;
        for (File reportFile : CoberturaPublisher.getCoberturaReports(this.owner)) {
            try {
                r = CoberturaCoverageParser.parse(reportFile, r);
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Failed to load " + reportFile, e);
            }
        }
        if (r != null) {
            r.setOwner(this.owner);
            this.report = new WeakReference<CoverageResult>(r);
            return r;
        }
        return null;
    }

    public static CoberturaBuildAction load(AbstractBuild<?, ?> build, CoverageResult result, CoverageTarget healthyTarget, CoverageTarget unhealthyTarget, boolean onlyStable) {
        return new CoberturaBuildAction(build, result, healthyTarget, unhealthyTarget, onlyStable);
    }

    public void doGraph(StaplerRequest req, StaplerResponse rsp) throws IOException {
        if (ChartUtil.awtProblem) {
            rsp.sendRedirect2(req.getContextPath() + "/images/headless.png");
            return;
        }
        Calendar t = this.owner.getTimestamp();
        if (req.checkIfModified(t, rsp)) {
            return;
        }
        DataSetBuilder dsb = new DataSetBuilder();
        for (CoberturaBuildAction a = this; a != null; a = a.getPreviousResult()) {
            ChartUtil.NumberOnlyBuildLabel label = new ChartUtil.NumberOnlyBuildLabel(a.owner);
            for (Map.Entry<CoverageMetric, Ratio> value : a.result.entrySet()) {
                dsb.add((Number)Float.valueOf(value.getValue().getPercentageFloat()), (Comparable)((Object)value.getKey().getName()), (Comparable)label);
            }
        }
        ChartUtil.generateGraph((StaplerRequest)req, (StaplerResponse)rsp, (JFreeChart)this.createChart(dsb.build()), (int)500, (int)200);
    }

    private JFreeChart createChart(CategoryDataset dataset) {
        JFreeChart chart = ChartFactory.createLineChart(null, null, (String)"%", (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        LegendTitle legend = chart.getLegend();
        legend.setPosition(RectangleEdge.RIGHT);
        chart.setBackgroundPaint((Paint)Color.white);
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setOutlinePaint(null);
        plot.setRangeGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)Color.black);
        ShiftedCategoryAxis domainAxis = new ShiftedCategoryAxis(null);
        plot.setDomainAxis((CategoryAxis)domainAxis);
        domainAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
        domainAxis.setLowerMargin(0.0);
        domainAxis.setUpperMargin(0.0);
        domainAxis.setCategoryMargin(0.0);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        rangeAxis.setUpperBound(100.0);
        rangeAxis.setLowerBound(0.0);
        LineAndShapeRenderer renderer = (LineAndShapeRenderer)plot.getRenderer();
        renderer.setStroke((Stroke)new BasicStroke(2.0f));
        ColorPalette.apply((LineAndShapeRenderer)renderer);
        plot.setInsets(new RectangleInsets(5.0, 0.0, 0.0, 5.0));
        return chart;
    }
}

