/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cobertura.targets;

import hudson.plugins.cobertura.Ratio;
import hudson.plugins.cobertura.targets.CoverageAggregationMode;
import hudson.plugins.cobertura.targets.CoverageElement;
import hudson.plugins.cobertura.targets.CoverageMetric;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoverageAggreagtionRule
implements Serializable {
    private final CoverageMetric output;
    private final CoverageAggregationMode mode;
    private final CoverageMetric input;
    private final CoverageElement source;
    private static final CoverageAggreagtionRule[] INITIAL_RULESET = new CoverageAggreagtionRule[]{new CoverageAggreagtionRule(CoverageElement.JAVA_METHOD, CoverageMetric.LINE, CoverageAggregationMode.SUM, CoverageMetric.LINE), new CoverageAggreagtionRule(CoverageElement.JAVA_METHOD, CoverageMetric.CONDITIONAL, CoverageAggregationMode.SUM, CoverageMetric.CONDITIONAL), new CoverageAggreagtionRule(CoverageElement.JAVA_METHOD, CoverageMetric.LINE, CoverageAggregationMode.COUNT_NON_ZERO, CoverageMetric.METHOD), new CoverageAggreagtionRule(CoverageElement.JAVA_CLASS, CoverageMetric.LINE, CoverageAggregationMode.SUM, CoverageMetric.LINE), new CoverageAggreagtionRule(CoverageElement.JAVA_CLASS, CoverageMetric.CONDITIONAL, CoverageAggregationMode.SUM, CoverageMetric.CONDITIONAL), new CoverageAggreagtionRule(CoverageElement.JAVA_CLASS, CoverageMetric.METHOD, CoverageAggregationMode.SUM, CoverageMetric.METHOD), new CoverageAggreagtionRule(CoverageElement.JAVA_CLASS, CoverageMetric.LINE, CoverageAggregationMode.COUNT_NON_ZERO, CoverageMetric.CLASSES), new CoverageAggreagtionRule(CoverageElement.JAVA_FILE, CoverageMetric.LINE, CoverageAggregationMode.SUM, CoverageMetric.LINE), new CoverageAggreagtionRule(CoverageElement.JAVA_FILE, CoverageMetric.CONDITIONAL, CoverageAggregationMode.SUM, CoverageMetric.CONDITIONAL), new CoverageAggreagtionRule(CoverageElement.JAVA_FILE, CoverageMetric.METHOD, CoverageAggregationMode.SUM, CoverageMetric.METHOD), new CoverageAggreagtionRule(CoverageElement.JAVA_FILE, CoverageMetric.CLASSES, CoverageAggregationMode.SUM, CoverageMetric.CLASSES), new CoverageAggreagtionRule(CoverageElement.JAVA_FILE, CoverageMetric.LINE, CoverageAggregationMode.COUNT_NON_ZERO, CoverageMetric.FILES), new CoverageAggreagtionRule(CoverageElement.JAVA_PACKAGE, CoverageMetric.LINE, CoverageAggregationMode.SUM, CoverageMetric.LINE), new CoverageAggreagtionRule(CoverageElement.JAVA_PACKAGE, CoverageMetric.CONDITIONAL, CoverageAggregationMode.SUM, CoverageMetric.CONDITIONAL), new CoverageAggreagtionRule(CoverageElement.JAVA_PACKAGE, CoverageMetric.METHOD, CoverageAggregationMode.SUM, CoverageMetric.METHOD), new CoverageAggreagtionRule(CoverageElement.JAVA_PACKAGE, CoverageMetric.CLASSES, CoverageAggregationMode.SUM, CoverageMetric.CLASSES), new CoverageAggreagtionRule(CoverageElement.JAVA_PACKAGE, CoverageMetric.FILES, CoverageAggregationMode.SUM, CoverageMetric.FILES), new CoverageAggreagtionRule(CoverageElement.JAVA_PACKAGE, CoverageMetric.LINE, CoverageAggregationMode.COUNT_NON_ZERO, CoverageMetric.PACKAGES)};

    public CoverageAggreagtionRule(CoverageElement source, CoverageMetric input, CoverageAggregationMode mode, CoverageMetric output) {
        this.mode = mode;
        this.input = input;
        this.source = source;
        this.output = output;
    }

    public static Map<CoverageMetric, Ratio> aggregate(CoverageElement source, CoverageMetric input, Ratio inputResult, Map<CoverageMetric, Ratio> runningTotal) {
        HashMap<CoverageMetric, Ratio> result = new HashMap<CoverageMetric, Ratio>(runningTotal);
        block10: for (CoverageAggreagtionRule rule : INITIAL_RULESET) {
            if (!rule.source.equals((Object)source) || !rule.input.equals((Object)input)) continue;
            if (result.containsKey((Object)rule.output)) {
                Ratio prevTotal = (Ratio)result.get((Object)rule.output);
                switch (rule.mode) {
                    case SUM: {
                        result.put(rule.output, Ratio.create(prevTotal.numerator + inputResult.numerator, prevTotal.denominator + inputResult.denominator));
                        break;
                    }
                    case COUNT_NON_ZERO: {
                        if (!((double)Math.abs(inputResult.denominator) > 1.0E-7)) break;
                        if ((double)Math.abs(inputResult.numerator) > 1.0E-7) {
                            result.put(rule.output, Ratio.create(prevTotal.numerator + 1.0f, prevTotal.denominator + 1.0f));
                            break;
                        }
                        result.put(rule.output, Ratio.create(prevTotal.numerator, prevTotal.denominator + 1.0f));
                        break;
                    }
                    case PRODUCT: {
                        result.put(rule.output, Ratio.create(prevTotal.numerator * inputResult.numerator, prevTotal.denominator * inputResult.denominator));
                        break;
                    }
                    case NONE: {
                        break;
                    }
                }
                continue;
            }
            switch (rule.mode) {
                case SUM: 
                case PRODUCT: {
                    result.put(rule.output, inputResult);
                    continue block10;
                }
                case COUNT_NON_ZERO: {
                    if (!((double)Math.abs(inputResult.denominator) > 1.0E-7)) continue block10;
                    if ((double)Math.abs(inputResult.numerator) > 1.0E-7) {
                        result.put(rule.output, Ratio.create(1.0f, 1.0f));
                        continue block10;
                    }
                    result.put(rule.output, Ratio.create(0.0f, 1.0f));
                    continue block10;
                }
            }
        }
        return result;
    }

    public static Ratio combine(CoverageMetric metric, Ratio existingResult, Ratio additionalResult) {
        return Ratio.create(existingResult.numerator + additionalResult.numerator, existingResult.denominator + additionalResult.denominator);
    }
}

