/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cobertura;

import hudson.plugins.cobertura.Ratio;
import hudson.plugins.cobertura.targets.CoverageElement;
import hudson.plugins.cobertura.targets.CoverageMetric;
import hudson.plugins.cobertura.targets.CoverageResult;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CoberturaXmlHandler
extends DefaultHandler {
    private CoverageResult rootCoverage;
    private Stack<CoverageResult> stack = new Stack();
    private static final String DEFAULT_PACKAGE = "<default>";
    private Set<String> sourcePaths = new HashSet();
    private boolean inSources = false;
    private boolean inSource = false;
    private StringBuilder sourceDir = new StringBuilder();

    public CoberturaXmlHandler(CoverageResult rootCoverage) {
        this.rootCoverage = rootCoverage;
    }

    @Override
    public void startDocument() throws SAXException {
        super.startDocument();
        if (this.rootCoverage == null) {
            this.rootCoverage = new CoverageResult(CoverageElement.PROJECT, null, "Cobertura Coverage Report");
        }
        this.stack.clear();
        this.inSource = false;
        this.inSources = false;
    }

    @Override
    public void endDocument() throws SAXException {
        if (!this.stack.empty() || this.inSource || this.inSources) {
            throw new SAXException("Unbalanced parse of cobertua coverage results.");
        }
        super.endDocument();
    }

    private void descend(CoverageElement childType, String childName) {
        CoverageResult child = this.rootCoverage.getChild(childName);
        this.stack.push(this.rootCoverage);
        this.rootCoverage = child == null ? new CoverageResult(childType, this.rootCoverage, childName) : child;
    }

    private void ascend(CoverageElement element) {
        while (this.rootCoverage != null && this.rootCoverage.getElement() != element) {
            this.rootCoverage = (CoverageResult)this.stack.pop();
        }
        if (this.rootCoverage != null) {
            this.rootCoverage = (CoverageResult)this.stack.pop();
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        super.startElement(uri, localName, qName, attributes);
        String name = attributes.getValue("name");
        if ("sources".equals(qName)) {
            this.inSources = true;
        } else if ("source".equals(qName)) {
            this.sourceDir = new StringBuilder();
            this.inSource = true;
        } else if (!"coverage".equals(qName)) {
            if ("package".equals(qName)) {
                if ("".equals(name) || null == name) {
                    name = DEFAULT_PACKAGE;
                }
                this.descend(CoverageElement.JAVA_PACKAGE, name);
            } else if ("class".equals(qName)) {
                String filename;
                assert (this.rootCoverage.getElement() == CoverageElement.JAVA_PACKAGE);
                String relativeFilename = filename = attributes.getValue("filename").replace('\\', '/');
                String packageName = this.rootCoverage.getName();
                String packagePath = packageName.replace('.', '/') + "/";
                if (!DEFAULT_PACKAGE.equals(packageName) && relativeFilename.startsWith(packagePath)) {
                    relativeFilename = filename.substring(packagePath.length());
                }
                if (name.startsWith(packageName + ".")) {
                    name = name.substring(packageName.length() + 1);
                }
                this.descend(CoverageElement.JAVA_FILE, relativeFilename);
                this.rootCoverage.setRelativeSourcePath(filename);
                this.descend(CoverageElement.JAVA_CLASS, name);
            } else if ("method".equals(qName)) {
                String methodName = this.buildMethodName(name, attributes.getValue("signature"));
                this.descend(CoverageElement.JAVA_METHOD, methodName);
            } else if ("line".equals(qName)) {
                Matcher matcher;
                String conditionCoverage;
                String hitsString = attributes.getValue("hits");
                String lineNumber = attributes.getValue("number");
                int denominator = 0;
                int numerator = 0;
                if (Boolean.parseBoolean(attributes.getValue("branch")) && (conditionCoverage = attributes.getValue("condition-coverage")) != null && (matcher = Pattern.compile("(\\d*)\\%\\s*\\((\\d*)/(\\d*)\\)").matcher(conditionCoverage)).matches()) {
                    assert (matcher.groupCount() == 3);
                    String numeratorStr = matcher.group(2);
                    String denominatorStr = matcher.group(3);
                    try {
                        numerator = Integer.parseInt(numeratorStr);
                        denominator = Integer.parseInt(denominatorStr);
                        this.rootCoverage.updateMetric(CoverageMetric.CONDITIONAL, Ratio.create((float)numerator, (float)denominator));
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
                try {
                    int hits = Integer.parseInt(hitsString);
                    int number = Integer.parseInt(lineNumber);
                    if (denominator == 0) {
                        this.rootCoverage.paint(number, hits);
                    } else {
                        this.rootCoverage.paint(number, hits, numerator, denominator);
                    }
                    this.rootCoverage.updateMetric(CoverageMetric.LINE, Ratio.create((float)(hits == 0 ? 0.0f : 1.0f), (float)1.0f));
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
        }
    }

    private String buildMethodName(String name, String signature) {
        Matcher signatureMatcher = Pattern.compile("\\((.*)\\)(.*)").matcher(signature);
        StringBuilder methodName = new StringBuilder();
        if (signatureMatcher.matches()) {
            String returnType;
            Pattern argMatcher = Pattern.compile("\\[*([TL][^\\;]*\\;)|([ZCBSIFJDV])");
            Matcher matcher = argMatcher.matcher(returnType = signatureMatcher.group(2));
            if (matcher.matches()) {
                methodName.append(this.parseMethodArg(matcher.group()));
                methodName.append(' ');
            }
            methodName.append(name);
            String args = signatureMatcher.group(1);
            matcher = argMatcher.matcher(args);
            methodName.append('(');
            boolean first = true;
            while (matcher.find()) {
                if (!first) {
                    methodName.append(',');
                }
                methodName.append(this.parseMethodArg(matcher.group()));
                first = false;
            }
            methodName.append(')');
        } else {
            methodName.append(name);
        }
        return methodName.toString();
    }

    private String parseMethodArg(String s) {
        char c = s.charAt(0);
        switch (c) {
            case 'Z': {
                return "boolean";
            }
            case 'C': {
                return "char";
            }
            case 'B': {
                return "byte";
            }
            case 'S': {
                return "short";
            }
            case 'I': {
                return "int";
            }
            case 'F': {
                return "float";
            }
            case 'J': {
                return "";
            }
            case 'D': {
                return "double";
            }
            case 'V': {
                return "void";
            }
            case '[': {
                return this.parseMethodArg(s.substring(1)) + "[]";
            }
            case 'L': 
            case 'T': {
                int end = s.indexOf(59);
                return s.substring(1, end).replace('/', '.');
            }
        }
        return s;
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if ("sources".equals(qName)) {
            this.inSources = false;
        } else if ("source".equals(qName)) {
            if (this.inSources && this.inSource) {
                this.sourcePaths.add(this.sourceDir.toString().trim());
            }
            this.inSource = false;
        } else if (!"coverage".equals(qName)) {
            if ("package".equals(qName)) {
                this.ascend(CoverageElement.JAVA_PACKAGE);
            } else if ("class".equals(qName)) {
                this.ascend(CoverageElement.JAVA_CLASS);
                this.ascend(CoverageElement.JAVA_FILE);
            } else if ("method".equals(qName)) {
                this.ascend(CoverageElement.JAVA_METHOD);
            }
        }
        super.endElement(uri, localName, qName);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.sourceDir.append(new String(ch, start, length));
    }

    public CoverageResult getRootCoverage() {
        return this.rootCoverage;
    }

    public Set<String> getSourcePaths() {
        return Collections.unmodifiableSet(this.sourcePaths);
    }
}

