/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cobertura.targets;

import hudson.model.AbstractBuild;
import hudson.plugins.cobertura.targets.CoverageElement;
import hudson.plugins.cobertura.targets.CoveragePaint;
import hudson.plugins.cobertura.targets.CoveragePaintRule;
import hudson.plugins.cobertura.targets.CoverageResult;
import hudson.util.TextFile;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PaintedCoverageResult
extends CoverageResult {
    private final CoveragePaint paint;
    private String relativeSourcePath;

    public PaintedCoverageResult(CoverageElement elementType, PaintedCoverageResult parent, String name) {
        super(elementType, (CoverageResult)parent, name);
        this.paint = CoveragePaintRule.makePaint((CoverageElement)elementType);
        this.relativeSourcePath = null;
    }

    public String getRelativeSourcePath() {
        return this.relativeSourcePath;
    }

    public void setRelativeSourcePath(String relativeSourcePath) {
        this.relativeSourcePath = relativeSourcePath;
    }

    public boolean isSourceCodeLevel() {
        return this.relativeSourcePath != null;
    }

    public CoveragePaint getPaint() {
        return this.paint;
    }

    public void paint(int line, int hits) {
        if (this.paint != null) {
            this.paint.paint(line, hits);
        }
    }

    public void paint(int line, int hits, int branchHits, int branchTotal) {
        if (this.paint != null) {
            this.paint.paint(line, hits, branchHits, branchTotal);
        }
    }

    private File getSourceFile() {
        return new File(this.owner.getProject().getRootDir(), "cobertura/" + this.relativeSourcePath);
    }

    public boolean isSourceFileAvailable() {
        return this.owner == this.owner.getProject().getLastStableBuild() && this.getSourceFile().exists();
    }

    public String getSourceFileContent() {
        try {
            return new TextFile(this.getSourceFile()).read();
        }
        catch (IOException e) {
            return null;
        }
    }

    public void setOwner(AbstractBuild owner) {
        super.setOwner(owner);
        for (CoverageResult child : this.children.values()) {
            assert (child != null);
            assert (child instanceof PaintedCoverageResult) : child.getClass().getName();
            PaintedCoverageResult paintedChild = (PaintedCoverageResult)child;
            if (this.paint == null || paintedChild.paint == null || !CoveragePaintRule.propagatePaintToParent((CoverageElement)child.getElement())) continue;
            this.paint.add(paintedChild.paint);
        }
        if (this.paint != null) {
            this.aggregateResults.putAll(this.paint.getResults());
        }
    }

    public void doCoverageHighlightedSource(StaplerRequest req, StaplerResponse rsp) throws IOException {
    }

    public Map<String, CoveragePaint> getPaintedSources() {
        HashMap<String, CoveragePaint> result = new HashMap<String, CoveragePaint>();
        for (CoverageResult child : this.children.values()) {
            assert (child != null);
            assert (child instanceof PaintedCoverageResult) : child.getClass().getName();
            PaintedCoverageResult paintedChild = (PaintedCoverageResult)child;
            result.putAll(paintedChild.getPaintedSources());
        }
        if (this.relativeSourcePath != null && this.paint != null) {
            result.put(this.relativeSourcePath, this.paint);
        }
        return result;
    }
}

