/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cobertura;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Actionable;
import hudson.model.Descriptor;
import hudson.model.ProminentProjectAction;
import hudson.model.Result;
import hudson.plugins.cobertura.CoberturaBuildAction;
import hudson.plugins.cobertura.CoberturaPublisher;
import java.io.IOException;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoberturaProjectAction
extends Actionable
implements ProminentProjectAction {
    private final AbstractProject<?, ?> project;
    private boolean onlyStable;

    public CoberturaProjectAction(AbstractProject<?, ?> project, boolean onlyStable) {
        this.project = project;
        this.onlyStable = onlyStable;
    }

    public CoberturaProjectAction(AbstractProject<?, ?> project) {
        this.project = project;
        CoberturaPublisher cp = (CoberturaPublisher)project.getPublishersList().get((Descriptor)CoberturaPublisher.DESCRIPTOR);
        if (cp != null) {
            this.onlyStable = cp.getOnlyStable();
        }
    }

    public AbstractProject<?, ?> getProject() {
        return this.project;
    }

    public String getIconFileName() {
        return "graph.gif";
    }

    public String getDisplayName() {
        return "Coverage Report";
    }

    public String getUrlName() {
        return "cobertura";
    }

    public CoberturaBuildAction getLastResult() {
        for (AbstractBuild b = this.getLastBuildToBeConsidered(); b != null; b = (AbstractBuild)b.getPreviousNotFailedBuild()) {
            CoberturaBuildAction r;
            if (b.getResult() == Result.FAILURE || b.getResult() != Result.SUCCESS && this.onlyStable || (r = (CoberturaBuildAction)b.getAction(CoberturaBuildAction.class)) == null) continue;
            return r;
        }
        return null;
    }

    private AbstractBuild<?, ?> getLastBuildToBeConsidered() {
        return this.onlyStable ? (AbstractBuild)this.project.getLastStableBuild() : (AbstractBuild)this.project.getLastSuccessfulBuild();
    }

    public Integer getLastResultBuild() {
        for (AbstractBuild b = this.getLastBuildToBeConsidered(); b != null; b = (AbstractBuild)b.getPreviousNotFailedBuild()) {
            CoberturaBuildAction r;
            if (b.getResult() == Result.FAILURE || b.getResult() != Result.SUCCESS && this.onlyStable || (r = (CoberturaBuildAction)b.getAction(CoberturaBuildAction.class)) == null) continue;
            return b.getNumber();
        }
        return null;
    }

    public void doGraph(StaplerRequest req, StaplerResponse rsp) throws IOException {
        if (this.getLastResult() != null) {
            this.getLastResult().doGraph(req, rsp);
        }
    }

    public void doIndex(StaplerRequest req, StaplerResponse rsp) throws IOException {
        Integer buildNumber = this.getLastResultBuild();
        if (buildNumber == null) {
            rsp.sendRedirect2("nodata");
        } else {
            rsp.sendRedirect2("../" + buildNumber + "/cobertura");
        }
    }

    public String getSearchUrl() {
        return this.getUrlName();
    }
}

