/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cobertura.targets;

import hudson.model.AbstractBuild;
import hudson.model.Run;
import hudson.plugins.cobertura.CoberturaBuildAction;
import hudson.plugins.cobertura.Ratio;
import hudson.plugins.cobertura.targets.CoverageAggreagtionRule;
import hudson.plugins.cobertura.targets.CoverageElement;
import hudson.plugins.cobertura.targets.CoverageMetric;
import hudson.util.ChartUtil;
import hudson.util.ColorPalette;
import hudson.util.DataSetBuilder;
import hudson.util.ShiftedCategoryAxis;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.data.category.CategoryDataset;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoverageResult
implements Serializable {
    private final CoverageElement element;
    protected final Map<CoverageMetric, Ratio> aggregateResults = new HashMap<CoverageMetric, Ratio>();
    private final Map<CoverageMetric, Ratio> localResults = new HashMap<CoverageMetric, Ratio>();
    private final CoverageResult parent;
    protected final Map<String, CoverageResult> children = new HashMap<String, CoverageResult>();
    private final String name;
    public AbstractBuild<?, ?> owner = null;

    public CoverageResult(CoverageElement elementType, CoverageResult parent, String name) {
        this.element = elementType;
        this.parent = parent;
        this.name = name;
        if (this.parent != null) {
            this.parent.children.put(name, this);
        }
    }

    public String getName() {
        return this.name;
    }

    public CoverageResult getParent() {
        return this.parent;
    }

    public CoverageElement getElement() {
        return this.element;
    }

    public List<CoverageResult> getParents() {
        ArrayList<CoverageResult> result = new ArrayList<CoverageResult>();
        for (CoverageResult p = this.getParent(); p != null; p = p.getParent()) {
            result.add(p);
        }
        Collections.reverse(result);
        return result;
    }

    public Set<CoverageElement> getChildElements() {
        HashSet<CoverageElement> result = new HashSet<CoverageElement>();
        for (CoverageResult child : this.children.values()) {
            result.add(child.element);
        }
        return result;
    }

    public Set<String> getChildren(CoverageElement element) {
        TreeSet<String> result = new TreeSet<String>();
        for (CoverageResult child : this.children.values()) {
            if (!child.element.equals((Object)element)) continue;
            result.add(child.name);
        }
        return result;
    }

    public Set<CoverageMetric> getChildMetrics(CoverageElement element) {
        TreeSet<CoverageMetric> result = new TreeSet<CoverageMetric>();
        for (CoverageResult child : this.children.values()) {
            if (!child.element.equals((Object)element)) continue;
            result.addAll(child.getMetrics());
        }
        return result;
    }

    public Set<String> getChildren() {
        return this.children.keySet();
    }

    public Map<CoverageMetric, Ratio> getResults() {
        return Collections.unmodifiableMap(this.aggregateResults);
    }

    public String urlTransform(String name) {
        StringBuilder buf = new StringBuilder(name.length());
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if ('0' <= c && '9' >= c || 'A' <= c && 'Z' >= c || 'a' <= c && 'z' >= c) {
                buf.append(c);
                continue;
            }
            buf.append('_');
        }
        return buf.toString();
    }

    public String xmlTransform(String name) {
        return name.replaceAll("\\&", "&amp;").replaceAll("\\<", "&lt;").replaceAll("\\>", "&gt;");
    }

    public String relativeUrl(CoverageResult parent) {
        StringBuffer url = new StringBuffer("..");
        for (CoverageResult p = this.getParent(); p != null && p != parent; p = p.getParent()) {
            url.append("/..");
        }
        return url.toString();
    }

    public CoverageResult getChild(String name) {
        return this.children.get(name);
    }

    public Ratio getCoverage(CoverageMetric metric) {
        return this.aggregateResults.get((Object)metric);
    }

    public Set<CoverageMetric> getMetrics() {
        return Collections.unmodifiableSet(new TreeSet<CoverageMetric>(this.aggregateResults.keySet()));
    }

    public void updateMetric(CoverageMetric metric, Ratio additionalResult) {
        if (this.localResults.containsKey((Object)metric)) {
            Ratio existingResult = this.localResults.get((Object)metric);
            this.localResults.put(metric, CoverageAggreagtionRule.combine(metric, existingResult, additionalResult));
        } else {
            this.localResults.put(metric, additionalResult);
        }
    }

    public AbstractBuild getOwner() {
        return this.owner;
    }

    public void setOwner(AbstractBuild owner) {
        this.owner = owner;
        this.aggregateResults.clear();
        for (CoverageResult child : this.children.values()) {
            child.setOwner(owner);
            for (Map.Entry<CoverageMetric, Ratio> childResult : child.aggregateResults.entrySet()) {
                this.aggregateResults.putAll(CoverageAggreagtionRule.aggregate(child.getElement(), childResult.getKey(), childResult.getValue(), this.aggregateResults));
            }
        }
        this.aggregateResults.putAll(this.localResults);
        this.localResults.clear();
    }

    public CoverageResult getPreviousResult() {
        if (this.parent == null) {
            if (this.owner == null) {
                return null;
            }
            Run prevBuild = this.owner.getPreviousNotFailedBuild();
            if (prevBuild == null) {
                return null;
            }
            CoberturaBuildAction action = null;
            while (prevBuild != null && null == (action = (CoberturaBuildAction)prevBuild.getAction(CoberturaBuildAction.class))) {
                prevBuild = prevBuild.getPreviousNotFailedBuild();
            }
            if (action == null) {
                return null;
            }
            return action.getResult();
        }
        CoverageResult prevParent = this.parent.getPreviousResult();
        return prevParent == null ? null : prevParent.getChild(this.name);
    }

    public Object getDynamic(String token, StaplerRequest req, StaplerResponse rsp) throws IOException {
        token = token.toLowerCase();
        for (String name : this.children.keySet()) {
            if (!this.urlTransform(name).toLowerCase().equals(token)) continue;
            return this.getChild(name);
        }
        return null;
    }

    public void doGraph(StaplerRequest req, StaplerResponse rsp) throws IOException {
        if (ChartUtil.awtProblem) {
            rsp.sendRedirect2(req.getContextPath() + "/images/headless.png");
            return;
        }
        AbstractBuild build = this.getOwner();
        Calendar t = build.getTimestamp();
        if (req.checkIfModified(t, rsp)) {
            return;
        }
        DataSetBuilder dsb = new DataSetBuilder();
        for (CoverageResult a = this; a != null; a = a.getPreviousResult()) {
            ChartUtil.NumberOnlyBuildLabel label = new ChartUtil.NumberOnlyBuildLabel(a.getOwner());
            for (Map.Entry<CoverageMetric, Ratio> value : a.aggregateResults.entrySet()) {
                dsb.add((Number)Float.valueOf(value.getValue().getPercentageFloat()), (Comparable)((Object)value.getKey().getName()), (Comparable)label);
            }
        }
        ChartUtil.generateGraph((StaplerRequest)req, (StaplerResponse)rsp, (JFreeChart)this.createChart(dsb.build()), (int)500, (int)200);
    }

    private JFreeChart createChart(CategoryDataset dataset) {
        JFreeChart chart = ChartFactory.createLineChart(null, null, (String)"%", (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        LegendTitle legend = chart.getLegend();
        legend.setPosition(RectangleEdge.RIGHT);
        chart.setBackgroundPaint((Paint)Color.white);
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setOutlinePaint(null);
        plot.setRangeGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)Color.black);
        ShiftedCategoryAxis domainAxis = new ShiftedCategoryAxis(null);
        plot.setDomainAxis((CategoryAxis)domainAxis);
        domainAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
        domainAxis.setLowerMargin(0.0);
        domainAxis.setUpperMargin(0.0);
        domainAxis.setCategoryMargin(0.0);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        rangeAxis.setUpperBound(100.0);
        rangeAxis.setLowerBound(0.0);
        LineAndShapeRenderer renderer = (LineAndShapeRenderer)plot.getRenderer();
        renderer.setStroke((Stroke)new BasicStroke(2.0f));
        ColorPalette.apply((LineAndShapeRenderer)renderer);
        plot.setInsets(new RectangleInsets(5.0, 0.0, 0.0, 5.0));
        return chart;
    }
}

