/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cobertura.targets;

import hudson.plugins.cobertura.targets.CoverageAggregationMode;
import hudson.plugins.cobertura.targets.CoverageElement;
import hudson.plugins.cobertura.targets.CoveragePaint;
import java.io.Serializable;

public class CoveragePaintRule
implements Serializable {
    private final CoverageElement element;
    private final CoverageAggregationMode mode;
    private static final CoveragePaintRule[] INITIAL_RULESET = new CoveragePaintRule[]{new CoveragePaintRule(CoverageElement.JAVA_METHOD, CoverageAggregationMode.NONE), new CoveragePaintRule(CoverageElement.JAVA_CLASS, CoverageAggregationMode.SUM)};

    public CoveragePaintRule(CoverageElement element, CoverageAggregationMode mode) {
        this.element = element;
        this.mode = mode;
    }

    public static CoveragePaint makePaint(CoverageElement element) {
        for (CoveragePaintRule rule : INITIAL_RULESET) {
            if (!element.equals((Object)rule.element) && (!element.equals((Object)rule.element.getParent()) || CoverageAggregationMode.NONE.equals((Object)rule.mode))) continue;
            return new CoveragePaint(element);
        }
        return null;
    }

    public static boolean propagatePaintToParent(CoverageElement element) {
        for (CoveragePaintRule rule : INITIAL_RULESET) {
            if (!element.equals((Object)rule.element)) continue;
            return !CoverageAggregationMode.NONE.equals((Object)rule.mode);
        }
        return false;
    }
}

