/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cobertura.renderers;

import hudson.FilePath;
import hudson.model.BuildListener;
import hudson.plugins.cobertura.targets.CoveragePaint;
import hudson.remoting.VirtualChannel;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceCodePainter
implements FilePath.FileCallable<Boolean>,
Serializable {
    private final Set<String> sourcePaths;
    private final Map<String, CoveragePaint> paint;
    private final FilePath destination;
    private final BuildListener listener;

    public SourceCodePainter(FilePath destination, Set<String> sourcePaths, Map<String, CoveragePaint> paint, BuildListener listener) {
        this.destination = destination;
        this.sourcePaths = sourcePaths;
        this.paint = paint;
        this.listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintSourceCode(File source, CoveragePaint paint, FilePath canvas) throws IOException, InterruptedException {
        OutputStream os = null;
        FileReader reader = null;
        BufferedReader input = null;
        FilterOutputStream bos = null;
        PrintStream output = null;
        int line = 0;
        try {
            String content;
            canvas.getParent().mkdirs();
            os = canvas.write();
            reader = new FileReader(source);
            input = new BufferedReader(reader);
            bos = new BufferedOutputStream(os);
            output = new PrintStream(bos);
            while ((content = input.readLine()) != null) {
                if (paint.isPainted(++line)) {
                    int coveragePercent;
                    int hits = paint.getHits(line);
                    int branchCoverage = paint.getBranchCoverage(line);
                    int branchTotal = paint.getBranchTotal(line);
                    int n = coveragePercent = hits == 0 ? 0 : (int)((double)branchCoverage * 100.0 / (double)branchTotal);
                    if (paint.getHits(line) > 0) {
                        if (branchTotal == branchCoverage) {
                            output.println("<tr class=\"coverFull\">");
                        } else {
                            output.println("<tr class=\"coverPart\" title=\"Line " + line + ": Conditional coverage " + coveragePercent + "% (" + branchCoverage + "/" + branchTotal + ")\">");
                        }
                    } else {
                        output.println("<tr class=\"coverNone\">");
                    }
                    output.println("<td class=\"line\">" + line + "</td>");
                    output.println("<td class=\"hits\">" + hits + "</td>");
                } else {
                    output.println("<tr class=\"noCover\">");
                    output.println("<td class=\"line\">" + line + "</td>");
                    output.println("<td class=\"hits\"/>");
                }
                output.println("<td class=\"code\">" + content.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\n", "").replace("\r", "").replace(" ", "&nbsp;").replace("\t", "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;") + "</td>");
                output.println("</tr>");
            }
        }
        finally {
            if (output != null) {
                output.close();
            }
            if (bos != null) {
                bos.close();
            }
            if (input != null) {
                input.close();
            }
            if (os != null) {
                os.close();
            }
            if (reader != null) {
                ((Reader)reader).close();
            }
        }
    }

    public Boolean invoke(File workspaceDir, VirtualChannel channel) throws IOException {
        ArrayList<File> trialPaths = new ArrayList<File>(this.sourcePaths.size());
        for (String string : this.sourcePaths) {
            File trialPath2;
            File trialPath = new File(string);
            if (trialPath.exists()) {
                trialPaths.add(trialPath);
            }
            if (!(trialPath2 = new File(workspaceDir, string)).exists() || trialPath2.equals(trialPath)) continue;
            trialPaths.add(trialPath2);
        }
        for (Map.Entry entry : this.paint.entrySet()) {
            File source = new File(workspaceDir, (String)entry.getKey());
            Iterator possiblePath = trialPaths.iterator();
            while (!source.exists() && possiblePath.hasNext()) {
                source = new File((File)possiblePath.next(), (String)entry.getKey());
            }
            if (!source.isFile()) continue;
            try {
                this.paintSourceCode(source, (CoveragePaint)entry.getValue(), this.destination.child((String)entry.getKey()));
            }
            catch (IOException e) {
                e.printStackTrace(this.listener.error("ERROR: Failure to paint " + source + " to " + this.destination));
            }
            catch (InterruptedException e) {
                return Boolean.FALSE;
            }
        }
        return Boolean.TRUE;
    }
}

