/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cobertura.dashboard;

import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Job;
import hudson.model.Run;
import hudson.plugins.cobertura.CoberturaBuildAction;
import hudson.plugins.cobertura.Ratio;
import hudson.plugins.cobertura.targets.CoverageMetric;
import hudson.plugins.cobertura.targets.CoverageResult;
import hudson.plugins.view.dashboard.DashboardPortlet;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Set;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoverageTablePortlet
extends DashboardPortlet {
    @DataBoundConstructor
    public CoverageTablePortlet(String name) {
        super(name);
    }

    public Collection<Run> getCoverageRuns() {
        LinkedList<Run> allResults = new LinkedList<Run>();
        for (Job job : this.getDashboard().getJobs()) {
            CoberturaBuildAction rbb;
            Run run = job.getLastSuccessfulBuild();
            if (run == null || (rbb = (CoberturaBuildAction)run.getAction(CoberturaBuildAction.class)) == null) continue;
            allResults.add(run);
        }
        return allResults;
    }

    public CoverageResult getCoverageResult(Run run) {
        CoberturaBuildAction rbb = (CoberturaBuildAction)run.getAction(CoberturaBuildAction.class);
        return rbb.getResult();
    }

    public HashMap<CoverageMetric, Ratio> getTotalCoverageRatio() {
        HashMap<CoverageMetric, Ratio> totalRatioMap = new HashMap<CoverageMetric, Ratio>();
        for (Job job : this.getDashboard().getJobs()) {
            CoberturaBuildAction rbb;
            Run run = job.getLastSuccessfulBuild();
            if (run == null || (rbb = (CoberturaBuildAction)run.getAction(CoberturaBuildAction.class)) == null) continue;
            CoverageResult result = rbb.getResult();
            Set<CoverageMetric> metrics = result.getMetrics();
            for (CoverageMetric metric : metrics) {
                if (totalRatioMap.get((Object)metric) == null) {
                    totalRatioMap.put(metric, result.getCoverage(metric));
                    continue;
                }
                float currentNumerator = totalRatioMap.get((Object)((Object)metric)).numerator;
                float CurrentDenominator = totalRatioMap.get((Object)((Object)metric)).denominator;
                float sumNumerator = currentNumerator + result.getCoverage((CoverageMetric)metric).numerator;
                float sumDenominator = CurrentDenominator + result.getCoverage((CoverageMetric)metric).denominator;
                totalRatioMap.put(metric, Ratio.create(sumNumerator, sumDenominator));
            }
        }
        return totalRatioMap;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DescriptorImpl
    extends Descriptor<DashboardPortlet> {
        public static DescriptorImpl newInstance() {
            if (Hudson.getInstance().getPlugin("dashboard-view") != null) {
                return new DescriptorImpl();
            }
            return null;
        }

        public String getDisplayName() {
            return "Code Coverages";
        }
    }
}

