/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cobertura;

import hudson.Extension;
import hudson.FilePath;
import hudson.Util;
import hudson.maven.MavenBuildProxy;
import hudson.maven.MavenModule;
import hudson.maven.MavenReporter;
import hudson.maven.MavenReporterDescriptor;
import hudson.maven.MojoInfo;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.plugins.cobertura.CoberturaCoverageParser;
import hudson.plugins.cobertura.CoberturaProjectAction;
import hudson.plugins.cobertura.MavenCoberturaPublisher;
import hudson.plugins.cobertura.renderers.SourceCodePainter;
import hudson.plugins.cobertura.renderers.SourceEncoding;
import hudson.plugins.cobertura.targets.CoverageResult;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class MavenCoberturaPublisher
extends MavenReporter {
    @Extension
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl(null);
    private static final long serialVersionUID = 1L;

    public boolean preExecute(MavenBuildProxy build, MavenProject pom, MojoInfo mojo, BuildListener listener) throws InterruptedException, IOException {
        if (this.isCoberturaReport(mojo)) {
            boolean maven3orLater = this.maven3orLater(build.getMavenBuildInformation().getMavenVersion());
            PlexusConfiguration c = mojo.configuration.getChild("formats");
            if (c == null) {
                listener.getLogger().println("[HUDSON] Configuring cobertura-maven-plugin to enable xml reports");
                Xpp3Dom fmts = new Xpp3Dom("formats");
                Xpp3Dom fmt = new Xpp3Dom("format");
                fmt.setValue("html");
                fmts.addChild(fmt);
                Xpp3Dom fmt2 = new Xpp3Dom("format");
                fmt2.setValue("xml");
                fmts.addChild(fmt2);
                if (!maven3orLater) {
                    XmlPlexusConfiguration xmlPlexusConfiguration = new XmlPlexusConfiguration(fmts);
                    mojo.configuration.addChild((PlexusConfiguration)xmlPlexusConfiguration);
                } else {
                    mojo.mojoExecution.setConfiguration(fmts);
                }
            } else {
                PlexusConfiguration[] fmts = c.getChildren("format");
                boolean xmlConfigured = false;
                for (PlexusConfiguration fmt : fmts) {
                    if (!"xml".equalsIgnoreCase(fmt.getValue().trim())) continue;
                    xmlConfigured = true;
                    break;
                }
                if (xmlConfigured) {
                    listener.getLogger().println("[HUDSON] cobertura-maven-plugin already configured with xml reports enabled");
                } else {
                    XmlPlexusConfiguration fmt;
                    listener.getLogger().println("[HUDSON] Configuring cobertura-maven-plugin to enable xml reports");
                    if (!maven3orLater) {
                        fmt = new XmlPlexusConfiguration("format");
                        fmt.setValue("xml");
                        c.addChild((PlexusConfiguration)fmt);
                    } else {
                        fmt = new Xpp3Dom("format");
                        fmt.setValue("xml");
                        Xpp3Dom formats = mojo.mojoExecution.getConfiguration().getChild("formats");
                        if (formats == null) {
                            formats = new Xpp3Dom("formats");
                            mojo.mojoExecution.getConfiguration().addChild(formats);
                        }
                        formats.addChild((Xpp3Dom)fmt);
                    }
                }
            }
        }
        return true;
    }

    public boolean postExecute(MavenBuildProxy build, MavenProject pom, MojoInfo mojo, BuildListener listener, Throwable error) throws InterruptedException, IOException {
        File outputDir;
        if (!this.isCoberturaReport(mojo)) {
            return true;
        }
        boolean haveXMLReport = false;
        try {
            String[] formats;
            outputDir = (File)mojo.getConfigurationValue("outputDirectory", File.class);
            if (!outputDir.exists()) {
                return true;
            }
            for (String o : formats = (String[])mojo.getConfigurationValue("formats", String[].class)) {
                if (!"xml".equalsIgnoreCase(o.trim())) continue;
                haveXMLReport = true;
                break;
            }
            if (!haveXMLReport) {
                listener.getLogger().println("[HUDSON] I could not auto-configure the cobertura-maven-plugin to generate xml reports");
                listener.getLogger().println("[HUDSON] If the cobertura plugin needs was configured to generate xml reports, e.g.");
                listener.getLogger().println("[HUDSON]     ...");
                listener.getLogger().println("[HUDSON]     <plugin>");
                listener.getLogger().println("[HUDSON]       <groupId>org.codehaus.mojo</groupId>");
                listener.getLogger().println("[HUDSON]       <artifactId>codehaus-maven-plugin</artifactId>");
                listener.getLogger().println("[HUDSON]       ...");
                listener.getLogger().println("[HUDSON]       <configuration>");
                listener.getLogger().println("[HUDSON]         ...");
                listener.getLogger().println("[HUDSON]         <formats>");
                listener.getLogger().println("[HUDSON]           ...");
                listener.getLogger().println("[HUDSON]           <format>xml</format> <!-- ensure this format is present -->");
                listener.getLogger().println("[HUDSON]           ...");
                listener.getLogger().println("[HUDSON]         </formats>");
                listener.getLogger().println("[HUDSON]         ...");
                listener.getLogger().println("[HUDSON]       </configuration>");
                listener.getLogger().println("[HUDSON]       ...");
                listener.getLogger().println("[HUDSON]     </plugin>");
                listener.getLogger().println("[HUDSON]     ...");
                listener.getLogger().println("[HUDSON] Code coverage reports would be enabled");
                build.setResult(Result.UNSTABLE);
                return true;
            }
        }
        catch (ComponentConfigurationException e) {
            e.printStackTrace(listener.fatalError("Unable to obtain configuration from cobertura mojo"));
            build.setResult(Result.UNSTABLE);
            return true;
        }
        File reportFile = new File(outputDir, "coverage.xml");
        if (!reportFile.exists()) {
            listener.getLogger().println("[HUDSON] Cobertura report not generated (probably this module is not a java module)");
            return true;
        }
        FilePath reportFilePath = new FilePath(reportFile);
        FilePath target = build.getRootDir();
        try {
            target.mkdirs();
            listener.getLogger().println("[HUDSON] Recording coverage results");
            reportFilePath.copyTo(target.child("coverage.xml"));
        }
        catch (IOException e) {
            Util.displayIOException((IOException)e, (TaskListener)listener);
            e.printStackTrace(listener.fatalError("Unable to copy " + reportFilePath + " to " + target));
            build.setResult(Result.FAILURE);
        }
        CoverageResult result = null;
        HashSet sourcePaths = new HashSet();
        try {
            result = CoberturaCoverageParser.parse((File)reportFile, null, sourcePaths);
        }
        catch (IOException e) {
            Util.displayIOException((IOException)e, (TaskListener)listener);
            e.printStackTrace(listener.fatalError("Unable to parse " + reportFilePath));
            build.setResult(Result.FAILURE);
        }
        if (result != null) {
            result.setOwner(null);
            FilePath paintedSourcesPath = build.getProjectRootDir().child("cobertura");
            paintedSourcesPath.mkdirs();
            SourceEncoding encoding = SourceEncoding.getEncoding((String)System.getProperty("file.encoding"));
            SourceCodePainter painter = new SourceCodePainter(paintedSourcesPath, sourcePaths, result.getPaintedSources(), listener, encoding);
            new FilePath(pom.getBasedir()).act((FilePath.FileCallable)painter);
            if (!((Boolean)build.execute((MavenBuildProxy.BuildCallable)new MavenCoberturaActionAdder(listener))).booleanValue()) {
                listener.getLogger().println("[HUDSON] Unable to add link to cobertura results");
                build.setResult(Result.FAILURE);
                return true;
            }
        } else {
            listener.getLogger().println("[HUDSON] Unable to parse coverage results.");
            build.setResult(Result.FAILURE);
            return true;
        }
        build.registerAsProjectAction((MavenReporter)this);
        return true;
    }

    private boolean isCoberturaReport(MojoInfo mojo) {
        if (!mojo.pluginName.matches("org.codehaus.mojo", "cobertura-maven-plugin")) {
            return false;
        }
        return mojo.getGoal().equals("cobertura");
    }

    public Action getProjectAction(MavenModule project) {
        return new CoberturaProjectAction((AbstractProject)project);
    }

    public MavenReporterDescriptor getDescriptor() {
        return DESCRIPTOR;
    }

    public boolean maven3orLater(String mavenVersion) {
        if (StringUtils.isBlank((String)mavenVersion)) {
            return false;
        }
        return new ComparableVersion(mavenVersion).compareTo(new ComparableVersion("3.0")) >= 0;
    }
}

