/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cobertura;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractItem;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.plugins.cobertura.CoberturaBuildAction;
import hudson.plugins.cobertura.CoberturaCoverageParser;
import hudson.plugins.cobertura.CoberturaProjectAction;
import hudson.plugins.cobertura.CoberturaPublisherTarget;
import hudson.plugins.cobertura.Messages;
import hudson.plugins.cobertura.renderers.SourceCodePainter;
import hudson.plugins.cobertura.renderers.SourceEncoding;
import hudson.plugins.cobertura.targets.CoverageMetric;
import hudson.plugins.cobertura.targets.CoverageResult;
import hudson.plugins.cobertura.targets.CoverageTarget;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import net.sf.json.JSONObject;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.Converter;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoberturaPublisher
extends Recorder {
    private final String coberturaReportFile;
    private final boolean onlyStable;
    private CoverageTarget healthyTarget;
    private CoverageTarget unhealthyTarget;
    private CoverageTarget failingTarget;
    public static final CoberturaReportFilenameFilter COBERTURA_FILENAME_FILTER = new CoberturaReportFilenameFilter();
    private final SourceEncoding sourceEncoding;
    @Extension
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public CoberturaPublisher(String coberturaReportFile, boolean onlyStable, SourceEncoding sourceEncoding) {
        this.coberturaReportFile = coberturaReportFile;
        this.onlyStable = onlyStable;
        this.sourceEncoding = sourceEncoding;
        this.healthyTarget = new CoverageTarget();
        this.unhealthyTarget = new CoverageTarget();
        this.failingTarget = new CoverageTarget();
    }

    public List<CoberturaPublisherTarget> getTargets() {
        CoberturaPublisherTarget target;
        TreeMap<CoverageMetric, CoberturaPublisherTarget> targets = new TreeMap<CoverageMetric, CoberturaPublisherTarget>();
        for (CoverageMetric metric : this.healthyTarget.getTargets()) {
            target = (CoberturaPublisherTarget)targets.get((Object)metric);
            if (target == null) {
                target = new CoberturaPublisherTarget();
                target.setMetric(metric);
            }
            target.setHealthy(this.healthyTarget.getTarget(metric));
            targets.put(metric, target);
        }
        for (CoverageMetric metric : this.unhealthyTarget.getTargets()) {
            target = (CoberturaPublisherTarget)targets.get((Object)metric);
            if (target == null) {
                target = new CoberturaPublisherTarget();
                target.setMetric(metric);
            }
            target.setUnhealthy(this.unhealthyTarget.getTarget(metric));
            targets.put(metric, target);
        }
        for (CoverageMetric metric : this.failingTarget.getTargets()) {
            target = (CoberturaPublisherTarget)targets.get((Object)metric);
            if (target == null) {
                target = new CoberturaPublisherTarget();
                target.setMetric(metric);
            }
            target.setUnstable(this.failingTarget.getTarget(metric));
            targets.put(metric, target);
        }
        ArrayList<CoberturaPublisherTarget> result = new ArrayList<CoberturaPublisherTarget>(targets.values());
        return result;
    }

    private void setTargets(List<CoberturaPublisherTarget> targets) {
        this.healthyTarget.clear();
        this.unhealthyTarget.clear();
        this.failingTarget.clear();
        for (CoberturaPublisherTarget target : targets) {
            if (target.getHealthy() != null) {
                this.healthyTarget.setTarget(target.getMetric(), target.getHealthy());
            }
            if (target.getUnhealthy() != null) {
                this.unhealthyTarget.setTarget(target.getMetric(), target.getUnhealthy());
            }
            if (target.getUnstable() == null) continue;
            this.failingTarget.setTarget(target.getMetric(), target.getUnstable());
        }
    }

    public String getCoberturaReportFile() {
        return this.coberturaReportFile;
    }

    public boolean getOnlyStable() {
        return this.onlyStable;
    }

    public CoverageTarget getHealthyTarget() {
        return this.healthyTarget;
    }

    public void setHealthyTarget(CoverageTarget healthyTarget) {
        this.healthyTarget = healthyTarget;
    }

    public CoverageTarget getUnhealthyTarget() {
        return this.unhealthyTarget;
    }

    public void setUnhealthyTarget(CoverageTarget unhealthyTarget) {
        this.unhealthyTarget = unhealthyTarget;
    }

    public CoverageTarget getFailingTarget() {
        return this.failingTarget;
    }

    public void setFailingTarget(CoverageTarget failingTarget) {
        this.failingTarget = failingTarget;
    }

    static File getCoberturaReportDir(AbstractItem project) {
        return new File(project.getRootDir(), "cobertura");
    }

    static File[] getCoberturaReports(AbstractBuild<?, ?> build) {
        return build.getRootDir().listFiles(COBERTURA_FILENAME_FILTER);
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        Result threshold;
        Result result = threshold = this.onlyStable ? Result.SUCCESS : Result.UNSTABLE;
        if (build.getResult().isWorseThan(threshold)) {
            listener.getLogger().println("Skipping Cobertura coverage report as build was not " + threshold.toString() + " or better ...");
            return true;
        }
        listener.getLogger().println("Publishing Cobertura coverage report...");
        FilePath[] moduleRoots = build.getModuleRoots();
        boolean multipleModuleRoots = moduleRoots != null && moduleRoots.length > 1;
        FilePath moduleRoot = multipleModuleRoots ? build.getWorkspace() : build.getModuleRoot();
        File buildCoberturaDir = build.getRootDir();
        FilePath buildTarget = new FilePath(buildCoberturaDir);
        FilePath[] reports = new FilePath[]{};
        try {
            reports = moduleRoot.list(this.coberturaReportFile);
            if (build.getResult().isWorseOrEqualTo(Result.FAILURE) && reports.length == 0) {
                return true;
            }
        }
        catch (IOException e) {
            Util.displayIOException((IOException)e, (TaskListener)listener);
            e.printStackTrace(listener.fatalError("Unable to find coverage results"));
            build.setResult(Result.FAILURE);
        }
        if (reports.length == 0) {
            String msg = "No coverage results were found using the pattern '" + this.coberturaReportFile + "' relative to '" + moduleRoot.getRemote() + "'." + "  Did you enter a pattern relative to the correct directory?" + "  Did you generate the XML report(s) for Cobertura?";
            listener.getLogger().println(msg);
            build.setResult(Result.FAILURE);
            return true;
        }
        for (int i = 0; i < reports.length; ++i) {
            FilePath targetPath = new FilePath(buildTarget, "coverage" + (i == 0 ? "" : Integer.valueOf(i)) + ".xml");
            try {
                reports[i].copyTo(targetPath);
                continue;
            }
            catch (IOException e) {
                Util.displayIOException((IOException)e, (TaskListener)listener);
                e.printStackTrace(listener.fatalError("Unable to copy coverage from " + reports[i] + " to " + buildTarget));
                build.setResult(Result.FAILURE);
            }
        }
        listener.getLogger().println("Publishing Cobertura coverage results...");
        HashSet<String> sourcePaths = new HashSet<String>();
        CoverageResult result2 = null;
        for (File coberturaXmlReport : CoberturaPublisher.getCoberturaReports(build)) {
            try {
                result2 = CoberturaCoverageParser.parse(coberturaXmlReport, result2, sourcePaths);
            }
            catch (IOException e) {
                Util.displayIOException((IOException)e, (TaskListener)listener);
                e.printStackTrace(listener.fatalError("Unable to parse " + coberturaXmlReport));
                build.setResult(Result.FAILURE);
            }
        }
        if (result2 != null) {
            result2.setOwner(build);
            FilePath paintedSourcesPath = new FilePath(new File(build.getProject().getRootDir(), "cobertura"));
            paintedSourcesPath.mkdirs();
            SourceCodePainter painter = new SourceCodePainter(paintedSourcesPath, sourcePaths, result2.getPaintedSources(), listener, this.getSourceEncoding());
            moduleRoot.act((FilePath.FileCallable)painter);
            CoberturaBuildAction action = CoberturaBuildAction.load(build, result2, this.healthyTarget, this.unhealthyTarget, this.getOnlyStable());
            build.getActions().add(action);
            Set<CoverageMetric> failingMetrics = this.failingTarget.getFailingMetrics(result2);
            if (!failingMetrics.isEmpty()) {
                listener.getLogger().println("Code coverage enforcement failed for the following metrics:");
                for (CoverageMetric metric : failingMetrics) {
                    listener.getLogger().println("    " + metric.getName());
                }
                listener.getLogger().println("Setting Build to unstable.");
                build.setResult(Result.UNSTABLE);
            }
        } else {
            listener.getLogger().println("No coverage results were successfully parsed.  Did you generate the XML report(s) for Cobertura?");
            build.setResult(Result.FAILURE);
        }
        return true;
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        return new CoberturaProjectAction(project, this.getOnlyStable());
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    public BuildStepDescriptor<Publisher> getDescriptor() {
        return DESCRIPTOR;
    }

    public SourceEncoding getSourceEncoding() {
        return this.sourceEncoding;
    }

    private static class CoberturaReportFilenameFilter
    implements FilenameFilter {
        private CoberturaReportFilenameFilter() {
        }

        public boolean accept(File dir, String name) {
            return name.startsWith("coverage") && name.endsWith(".xml");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        CoverageMetric[] metrics = new CoverageMetric[]{CoverageMetric.PACKAGES, CoverageMetric.FILES, CoverageMetric.CLASSES, CoverageMetric.METHOD, CoverageMetric.LINE, CoverageMetric.CONDITIONAL};

        DescriptorImpl() {
            super(CoberturaPublisher.class);
        }

        public String getDisplayName() {
            return Messages.CoberturaPublisher_displayName();
        }

        public List<CoverageMetric> getMetrics() {
            return Arrays.asList(this.metrics);
        }

        public List<CoberturaPublisherTarget> getDefaultTargets() {
            ArrayList<CoberturaPublisherTarget> result = new ArrayList<CoberturaPublisherTarget>();
            result.add(new CoberturaPublisherTarget(CoverageMetric.METHOD, 80, null, null));
            result.add(new CoberturaPublisherTarget(CoverageMetric.LINE, 80, null, null));
            result.add(new CoberturaPublisherTarget(CoverageMetric.CONDITIONAL, 70, null, null));
            return result;
        }

        public List<CoberturaPublisherTarget> getTargets(CoberturaPublisher instance) {
            if (instance == null) {
                return this.getDefaultTargets();
            }
            return instance.getTargets();
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            req.bindParameters((Object)this, "cobertura.");
            this.save();
            return super.configure(req, formData);
        }

        public CoberturaPublisher newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            CoberturaPublisher instance = (CoberturaPublisher)((Object)req.bindJSON(CoberturaPublisher.class, formData));
            ConvertUtils.register((Converter)CoberturaPublisherTarget.CONVERTER, CoverageMetric.class);
            List targets = req.bindParametersToList(CoberturaPublisherTarget.class, "cobertura.target.");
            instance.setTargets(targets);
            return instance;
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }
    }
}

