/*
 * Decompiled with CFR 0.152.
 */
package com.collabnet.ce.webservices;

import com.collabnet.ce.soap50.webservices.ClientSoapStubFactory;
import com.collabnet.ce.soap50.webservices.docman.DocumentFolderSoapDO;
import com.collabnet.ce.soap50.webservices.docman.DocumentFolderSoapList;
import com.collabnet.ce.soap50.webservices.docman.DocumentFolderSoapRow;
import com.collabnet.ce.soap50.webservices.docman.DocumentSoapDO;
import com.collabnet.ce.soap50.webservices.docman.DocumentSoapList;
import com.collabnet.ce.soap50.webservices.docman.DocumentSoapRow;
import com.collabnet.ce.soap50.webservices.docman.IDocumentAppSoap;
import com.collabnet.ce.webservices.CollabNetApp;
import java.rmi.RemoteException;
import java.util.Date;

public class DocumentApp {
    private CollabNetApp collabNetApp;
    private IDocumentAppSoap da;

    public DocumentApp(CollabNetApp collabNetApp) {
        this.collabNetApp = collabNetApp;
        this.da = this.getDocumentAppSoap();
    }

    private IDocumentAppSoap getDocumentAppSoap() {
        String soapURL = this.getUrl() + CollabNetApp.SOAP_SERVICE + "DocumentApp?wsdl";
        return (IDocumentAppSoap)ClientSoapStubFactory.getSoapStub(IDocumentAppSoap.class, (String)soapURL);
    }

    public String findOrCreatePath(String projectId, String documentPath) throws RemoteException {
        this.checkValidSessionId();
        String[] folderNames = documentPath.split("/");
        int i = 0;
        DocumentFolderSoapRow rootRow = this.getRootFolder(projectId);
        if (rootRow.getTitle().equals(folderNames[i])) {
            ++i;
        }
        String currentFolderId = rootRow.getId();
        String subFolderId = null;
        while (i < folderNames.length) {
            DocumentFolderSoapList dfsList = this.da.getDocumentFolderList(this.getSessionId(), currentFolderId, false);
            String folderList = "";
            for (DocumentFolderSoapRow row : dfsList.getDataRows()) {
                folderList = folderList + row.getTitle() + ", ";
            }
            for (DocumentFolderSoapRow row : dfsList.getDataRows()) {
                if (!row.getTitle().equals(folderNames[i])) continue;
                subFolderId = row.getId();
                break;
            }
            if (subFolderId == null) break;
            currentFolderId = subFolderId;
            subFolderId = null;
            ++i;
        }
        while (i < folderNames.length) {
            DocumentFolderSoapDO dfsd = this.da.createDocumentFolder(this.getSessionId(), currentFolderId, folderNames[i], "Hudson Document creation of " + folderNames[i]);
            currentFolderId = dfsd.getId();
            ++i;
        }
        return currentFolderId;
    }

    private DocumentFolderSoapRow getRootFolder(String projectId) throws RemoteException {
        DocumentFolderSoapList dfsList = this.da.getDocumentFolderList(this.getSessionId(), projectId, false);
        if (dfsList.getDataRows().length < 1) {
            throw new CollabNetApp.CollabNetAppException("getRootFolder for projectId " + projectId + " failed to find any folders");
        }
        if (dfsList.getDataRows().length > 1) {
            StringBuffer rowNames = new StringBuffer("");
            for (DocumentFolderSoapRow row : dfsList.getDataRows()) {
                rowNames.append(row.getTitle() + ", ");
            }
            throw new CollabNetApp.CollabNetAppException("getRootFolder returned unexpected number of folders: " + rowNames.toString());
        }
        return dfsList.getDataRows()[0];
    }

    public String verifyPath(String projectId, String documentPath) throws RemoteException {
        this.checkValidSessionId();
        String[] folderNames = documentPath.split("/");
        int i = 0;
        DocumentFolderSoapRow rootRow = this.getRootFolder(projectId);
        if (rootRow.getTitle().equals(folderNames[i])) {
            ++i;
        }
        String currentFolderId = rootRow.getId();
        String subFolderId = null;
        while (i < folderNames.length) {
            DocumentFolderSoapList dfsList = this.da.getDocumentFolderList(this.getSessionId(), currentFolderId, false);
            for (DocumentFolderSoapRow row : dfsList.getDataRows()) {
                if (!row.getTitle().equals(folderNames[i])) continue;
                subFolderId = row.getId();
                break;
            }
            if (subFolderId == null) {
                return folderNames[i];
            }
            currentFolderId = subFolderId;
            subFolderId = null;
            ++i;
        }
        return null;
    }

    public String getFolderPath(String folderId) throws RemoteException {
        this.checkValidSessionId();
        DocumentFolderSoapDO folderSoap = this.da.getDocumentFolderData(this.getSessionId(), folderId);
        return folderSoap.getPath();
    }

    public String findDocumentId(String folderId, String title) throws RemoteException {
        this.checkValidSessionId();
        DocumentSoapList dsList = this.da.getDocumentList(this.getSessionId(), folderId, null);
        if (dsList.getDataRows().length < 1) {
            return null;
        }
        Date latest = null;
        String lastId = null;
        for (DocumentSoapRow row : dsList.getDataRows()) {
            if (!row.getTitle().equals(title)) continue;
            if (latest == null) {
                latest = row.getDateVersionCreated();
                lastId = row.getId();
                continue;
            }
            if (!row.getDateVersionCreated().after(latest)) continue;
            latest = row.getDateVersionCreated();
            lastId = row.getId();
        }
        return lastId;
    }

    public void updateDoc(String docId, String fileId) throws RemoteException {
        this.checkValidSessionId();
        DocumentSoapDO docData = this.da.getDocumentData(this.getSessionId(), docId, 0);
        this.da.setDocumentData(this.getSessionId(), docData, fileId);
    }

    public DocumentSoapDO createDocument(String parentId, String title, String description, String versionComment, String status, boolean createLocked, String fileName, String mimeType, String fileId, String associationId, String associationDesc) throws RemoteException {
        return this.da.createDocument(this.getSessionId(), parentId, title, description, versionComment, status, createLocked, fileName, mimeType, fileId, associationId, associationDesc);
    }

    private void checkValidSessionId() {
        this.collabNetApp.checkValidSessionId();
    }

    private String getSessionId() {
        return this.collabNetApp.getSessionId();
    }

    private String getUrl() {
        return this.collabNetApp.getServerUrl();
    }
}

