/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.collabnet.auth;

import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.JobPropertyDescriptor;
import hudson.plugins.collabnet.auth.CNAuthorizationStrategy;
import hudson.plugins.collabnet.auth.CNConnection;
import hudson.plugins.collabnet.auth.CNProjectACL;
import hudson.plugins.collabnet.auth.CollabNetRole;
import hudson.security.Permission;
import hudson.util.FormFieldValidator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CNAuthProjectProperty
extends JobProperty<Job<?, ?>> {
    public static Permission CONFIGURE_PROPERTY = Item.CONFIGURE;
    private String project;
    private boolean createRoles = false;
    private boolean grantDefaultRoles = false;
    private static Logger log = Logger.getLogger("CNAuthProjectProperty");
    private static Collection<String> defaultAdminRoles = Collections.emptyList();
    private static Collection<String> defaultUserRoles = Collections.emptyList();
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    public CNAuthProjectProperty(String project, Boolean createRoles, Boolean grantDefaults) {
        this.project = project;
        this.createRoles = createRoles;
        this.grantDefaultRoles = grantDefaults;
        if (this.createRoles || this.grantDefaultRoles) {
            this.loadRoles();
        }
    }

    public String getProject() {
        return this.project;
    }

    public boolean createRoles() {
        return this.createRoles;
    }

    public boolean grantDefaultRoles() {
        return this.grantDefaultRoles;
    }

    public Collection<String> getDefaultUserRoles() {
        if (defaultUserRoles.isEmpty()) {
            defaultUserRoles = new ArrayList<String>();
            defaultUserRoles.add("Hudson Read");
        }
        return defaultUserRoles;
    }

    public Collection<String> getDefaultAdminRoles() {
        if (defaultAdminRoles.isEmpty()) {
            defaultAdminRoles = CNProjectACL.CollabNetRoles.getNames();
        }
        return defaultAdminRoles;
    }

    private void loadRoles() {
        if (this.getProject() != null && !this.getProject().equals("")) {
            CNConnection conn = CNConnection.getInstance();
            if (conn == null) {
                log.warning("Cannot loadRoles, incorrect authentication type.");
                return;
            }
            String projectId = conn.getProjectId(this.getProject());
            if (this.createRoles()) {
                List<String> roleNames = CNProjectACL.CollabNetRoles.getNames();
                List<String> descriptions = CNProjectACL.CollabNetRoles.getDescriptions();
                conn.addRoles(projectId, roleNames, descriptions);
            }
            if (this.grantDefaultRoles()) {
                conn.grantRoles(projectId, this.getDefaultUserRoles(), conn.getUsers(projectId));
                conn.grantRoles(projectId, this.getDefaultAdminRoles(), conn.getAdmins(projectId));
            }
        }
    }

    public JobPropertyDescriptor getDescriptor() {
        return DESCRIPTOR;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DescriptorImpl
    extends JobPropertyDescriptor {
        protected DescriptorImpl() {
            super(CNAuthProjectProperty.class);
        }

        public JobProperty<?> newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            Boolean createRoles = Boolean.FALSE;
            Boolean grantDefaults = Boolean.FALSE;
            if (formData.get("createRoles") != null) {
                createRoles = Boolean.TRUE;
            }
            if (formData.get("grantDefaults") != null) {
                grantDefaults = Boolean.TRUE;
            }
            return new CNAuthProjectProperty((String)formData.get("project"), createRoles, grantDefaults);
        }

        public String getDisplayName() {
            return "Associated CollabNet Project";
        }

        public boolean isApplicable(Class<? extends Job> jobType) {
            return Hudson.getInstance().getAuthorizationStrategy() instanceof CNAuthorizationStrategy;
        }

        public void doProjectCheck(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
            new FormFieldValidator(req, rsp, false){

                protected void check() throws IOException, ServletException {
                    String project = this.request.getParameter("project");
                    if (project == null || project.equals("")) {
                        this.warning("If left empty, only Hudson admins have more than READ permissions in the project.");
                        return;
                    }
                    CNConnection conn = CNConnection.getInstance();
                    if (conn == null) {
                        this.warning("Cannot check project name, improper authentication type.");
                        return;
                    }
                    String projectId = conn.getProjectId(project);
                    boolean superUser = conn.isSuperUser();
                    boolean hudsonAdmin = Hudson.getInstance().getACL().hasPermission(Hudson.ADMINISTER);
                    if (projectId == null) {
                        if (superUser) {
                            this.error("This project does not exist.");
                            return;
                        }
                        this.error("The current user does not have access to this project.  If this project is chosen, the current user will be locked out of this Hudson job.");
                        return;
                    }
                    if (superUser) {
                        this.ok();
                        return;
                    }
                    if (!conn.isProjectAdmin(projectId)) {
                        this.warning("The current user is not a project admin in the project, so he/she cannot create or grant roles.");
                    }
                    if (hudsonAdmin) {
                        this.ok();
                        return;
                    }
                    CNProjectACL acl = new CNProjectACL(project);
                    if (!acl.hasPermission(CONFIGURE_PROPERTY)) {
                        CollabNetRole roleNeeded = CNProjectACL.CollabNetRoles.getGrantingRole(CONFIGURE_PROPERTY);
                        this.warning("The current user does not have the '" + roleNeeded.getName() + "' role in the " + "project, which is required to configure " + "this Hudson job.  If this project is chosen," + " the current user will not have the power " + "to change the project later, unless he/she " + "is given this role.");
                    }
                    this.ok();
                }
            }.process();
        }

        public String[] getProjects() {
            log.info("getting projects");
            Collection<Object> projects = Collections.emptyList();
            CNConnection conn = CNConnection.getInstance();
            if (conn == null) {
                return new String[0];
            }
            projects = conn.getProjects();
            return projects.toArray(new String[0]);
        }

        public String getCollabNetUrl() {
            CNConnection conn = CNConnection.getInstance();
            return conn.getCollabNetApp().getServerUrl();
        }
    }
}

