/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.collabnet.auth;

import hudson.model.AbstractItem;
import hudson.model.AbstractProject;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.User;
import hudson.model.View;
import hudson.plugins.collabnet.auth.CNAuthProjectProperty;
import hudson.plugins.collabnet.auth.CNConnection;
import hudson.plugins.collabnet.auth.CNProjectACL;
import hudson.plugins.collabnet.auth.CNRootACL;
import hudson.plugins.collabnet.auth.CNVersion;
import hudson.security.ACL;
import hudson.security.AuthorizationStrategy;
import hudson.util.FormFieldValidator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CNAuthorizationStrategy
extends AuthorizationStrategy {
    private Collection<String> readUsers;
    private Collection<String> readGroups;
    private Collection<String> adminUsers;
    private Collection<String> adminGroups;
    private ACL rootACL;
    private static Logger log = Logger.getLogger("CNAuthorizationStrategy");
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    public CNAuthorizationStrategy(String[] readUsers, String[] readGroups, String[] adminUsers, String[] adminGroups) {
        this.readUsers = Arrays.asList(readUsers);
        this.readGroups = Arrays.asList(readGroups);
        this.adminUsers = Arrays.asList(adminUsers);
        this.adminGroups = Arrays.asList(adminGroups);
        this.rootACL = new CNRootACL(this.adminUsers, this.adminGroups, this.readUsers, this.readGroups);
    }

    public String getReadUsersStr() {
        if (this.readUsers.isEmpty()) {
            return "";
        }
        return CNAuthorizationStrategy.join(this.readUsers, ", ");
    }

    public String getReadGroupsStr() {
        if (this.readGroups.isEmpty()) {
            return "";
        }
        return CNAuthorizationStrategy.join(this.readGroups, ", ");
    }

    public String getAdminUsersStr() {
        if (this.adminUsers.isEmpty()) {
            return "";
        }
        return CNAuthorizationStrategy.join(this.adminUsers, ", ");
    }

    public String getAdminGroupsStr() {
        if (this.adminGroups.isEmpty()) {
            return "";
        }
        return CNAuthorizationStrategy.join(this.adminGroups, ", ");
    }

    public static String join(Collection<String> strs, String delimiter) {
        StringBuffer buf = new StringBuffer();
        Iterator<String> it = strs.iterator();
        while (it.hasNext()) {
            String next = it.next();
            buf.append(next);
            if (!it.hasNext()) continue;
            buf.append(delimiter);
        }
        return buf.toString();
    }

    public Collection<String> getGroups() {
        return CNProjectACL.CollabNetRoles.getNames();
    }

    public ACL getRootACL() {
        log.info("Getting Root ACL");
        if (this.rootACL == null) {
            this.rootACL = new CNRootACL(this.adminUsers, this.adminGroups, this.readUsers, this.readGroups);
        }
        return this.rootACL;
    }

    public ACL getACL(Job<?, ?> job) {
        log.info("Getting Project ACL for: name: " + job.getName() + ", type: " + job.getClass().getName());
        CNAuthProjectProperty capp = (CNAuthProjectProperty)job.getProperty(CNAuthProjectProperty.class);
        if (capp != null) {
            String projectName = capp.getProject();
            if (projectName != null && !projectName.equals("")) {
                return new CNRootACL(this.adminUsers, this.adminGroups, this.readUsers, this.readGroups, new CNProjectACL(projectName));
            }
            return this.getRootACL();
        }
        return this.getRootACL();
    }

    public ACL getACL(AbstractItem item) {
        log.info("Getting AbstractItem ACL");
        return this.getRootACL();
    }

    public ACL getACL(AbstractProject<?, ?> project) {
        log.info("Getting AbstractProject ACL");
        return this.getACL((Job<?, ?>)project);
    }

    public ACL getACL(View view) {
        log.info("Getting View ACL");
        return this.getRootACL();
    }

    public ACL getACL(Computer computer) {
        log.info("Getting Computer ACL");
        return this.getRootACL();
    }

    public ACL getACL(User user) {
        log.info("Getting User ACL");
        return this.getRootACL();
    }

    public Descriptor<AuthorizationStrategy> getDescriptor() {
        return DESCRIPTOR;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends Descriptor<AuthorizationStrategy> {
        public static String GOOD_VERSION = "5.2.0.0";

        DescriptorImpl() {
            super(CNAuthorizationStrategy.class);
        }

        public String getDisplayName() {
            return "CollabNet Authorization";
        }

        public static String getHelpUrl() {
            return "/plugin/collabnet/auth/";
        }

        public String getHelpFile() {
            return DescriptorImpl.getHelpUrl() + "help-authStrategy.html";
        }

        public CNAuthorizationStrategy newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            String[] readUsers = this.splitCommaStr((String)formData.get("readUsers"));
            String[] readGroups = this.splitCommaStr((String)formData.get("readGroups"));
            String[] adminUsers = this.splitCommaStr((String)formData.get("adminUsers"));
            String[] adminGroups = this.splitCommaStr((String)formData.get("adminGroups"));
            return new CNAuthorizationStrategy(readUsers, readGroups, adminUsers, adminGroups);
        }

        private String[] splitCommaStr(String commaStr) {
            ArrayList<String> results = new ArrayList<String>(Arrays.asList(commaStr.trim().split("\\s*,\\s*")));
            Iterator it = results.iterator();
            while (it.hasNext()) {
                String next = (String)it.next();
                if (!(next = next.trim()).equals("")) continue;
                it.remove();
            }
            return results.toArray(new String[0]);
        }

        public static String getCollabNetUrl() {
            CNConnection conn = CNConnection.getInstance();
            if (conn == null) {
                return null;
            }
            return conn.getCollabNetApp().getServerUrl();
        }

        public static CNVersion getVersion(String url) {
            if (url == null) {
                return null;
            }
            return CNConnection.getVersion(url);
        }

        public static boolean isGoodCNVersion(String url) {
            CNVersion version = DescriptorImpl.getVersion(url);
            if (version == null) {
                return true;
            }
            CNVersion desiredVersion = new CNVersion(GOOD_VERSION);
            if (version.compareTo(desiredVersion) >= 0) {
                log.info("current version (" + version + ") is greater " + "than or equal to desired version " + desiredVersion);
                return true;
            }
            return false;
        }

        public void doVersionCheck(StaplerRequest req, StaplerResponse rsp) throws IOException {
            String url = req.getParameter("url");
            rsp.setContentType("text/plain;charset=UTF-8");
            JSONObject versionJSON = new JSONObject();
            String error_display_style = "none";
            if (!DescriptorImpl.isGoodCNVersion(url)) {
                error_display_style = "inline";
            }
            versionJSON.element("error_display_style", (Object)error_display_style);
            CNVersion version = DescriptorImpl.getVersion(url);
            if (version != null) {
                versionJSON.element("version", (Object)DescriptorImpl.getVersion(url).toString());
            } else {
                versionJSON.element("version", (Object)"unknown");
            }
            rsp.getWriter().print(versionJSON.toString());
        }

        public void doUserCheck(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
            new FormFieldValidator(req, rsp, true){

                protected void check() throws IOException, ServletException {
                    String userStr = this.request.getParameter("value");
                    Collection invalidUsers = DescriptorImpl.this.getInvalidUsers(userStr);
                    if (!invalidUsers.isEmpty()) {
                        this.error("The following users do not exist: " + invalidUsers);
                        return;
                    }
                    this.ok();
                }
            }.process();
        }

        private Collection<String> getInvalidUsers(String userStr) {
            String[] users = this.splitCommaStr(userStr);
            CNConnection conn = CNConnection.getInstance();
            if (conn == null) {
                return Collections.emptyList();
            }
            ArrayList<String> invalidUsers = new ArrayList<String>();
            for (String user : users) {
                if (conn.isUsernameValid(user)) continue;
                invalidUsers.add(user);
            }
            return invalidUsers;
        }

        public void doGroupCheck(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
            new FormFieldValidator(req, rsp, true){

                protected void check() throws IOException, ServletException {
                    String groupStr = this.request.getParameter("groups");
                    Collection invalidGroups = DescriptorImpl.this.getInvalidGroups(groupStr);
                    if (!invalidGroups.isEmpty()) {
                        this.error("The following groups do not exist: " + invalidGroups);
                        return;
                    }
                    String userStr = this.request.getParameter("users");
                    if (userStr != null && DescriptorImpl.this.locksOutCurrentUser(userStr, groupStr)) {
                        this.error("The authorization settings would lock the current user out of this page.  You may want to add your username to the user list.");
                        return;
                    }
                    this.ok();
                }
            }.process();
        }

        private Collection<String> getInvalidGroups(String groupStr) {
            CNConnection conn = CNConnection.getInstance();
            if (conn == null) {
                return Collections.emptyList();
            }
            if (!conn.isSuperUser()) {
                return Collections.emptyList();
            }
            String[] groups = this.splitCommaStr(groupStr);
            ArrayList<String> invalidGroups = new ArrayList<String>();
            for (String group : groups) {
                if (conn.isGroupnameValid(group)) continue;
                invalidGroups.add(group);
            }
            return invalidGroups;
        }

        private boolean locksOutCurrentUser(String userStr, String groupStr) {
            String[] users;
            CNConnection conn = CNConnection.getInstance();
            if (conn == null) {
                return false;
            }
            if (conn.isSuperUser()) {
                return false;
            }
            String currentUser = conn.getUsername();
            for (String user : users = this.splitCommaStr(userStr)) {
                if (!user.equals(currentUser)) continue;
                return false;
            }
            String[] groups = this.splitCommaStr(groupStr);
            return !conn.isMemberOfAny(Arrays.asList(groups));
        }
    }
}

