/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.collabnet.auth;

import com.collabnet.ce.webservices.CollabNetApp;
import hudson.model.Hudson;
import hudson.plugins.collabnet.auth.CNAuthentication;
import hudson.plugins.collabnet.auth.CollabNetSecurityRealm;
import hudson.security.SecurityRealm;
import java.io.IOException;
import java.net.URLEncoder;
import java.rmi.RemoteException;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.acegisecurity.Authentication;
import org.acegisecurity.context.SecurityContextHolder;

public class CNFilter
implements Filter {
    private static Logger log = Logger.getLogger("CNFilter");

    public void init(FilterConfig filterConfig) {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Authentication auth = Hudson.getAuthentication();
        SecurityRealm securityRealm = Hudson.getInstance().getSecurityRealm();
        if (Hudson.getInstance().isUseSecurity() && (!auth.isAuthenticated() || auth.getPrincipal().equals("anonymous")) && securityRealm instanceof CollabNetSecurityRealm) {
            this.attemptSFLogin((CollabNetSecurityRealm)securityRealm, request, response);
        } else if (Hudson.getInstance().isUseSecurity() && securityRealm instanceof CollabNetSecurityRealm && auth instanceof CNAuthentication && !((CNAuthentication)auth).isCNAuthed()) {
            this.doSFAuth((CNAuthentication)auth, (CollabNetSecurityRealm)securityRealm, (HttpServletRequest)request, (HttpServletResponse)response, chain);
            return;
        }
        chain.doFilter(request, response);
    }

    private void attemptSFLogin(CollabNetSecurityRealm securityRealm, ServletRequest request, ServletResponse response) {
        String url = securityRealm.getCollabNetUrl();
        String username = request.getParameter("sfUsername");
        String token = request.getParameter("sfLoginToken");
        if (username != null && token != null) {
            CollabNetApp ca = new CollabNetApp(url, username);
            try {
                ca.loginWithToken(token);
                CNAuthentication cnauthentication = new CNAuthentication(username, ca);
                SecurityContextHolder.getContext().setAuthentication((Authentication)cnauthentication);
            }
            catch (RemoteException re) {
                log.severe("Login failed with RemoteException: " + re.getMessage());
            }
        }
    }

    private void doSFAuth(CNAuthentication auth, CollabNetSecurityRealm securityRealm, HttpServletRequest req, HttpServletResponse rsp, FilterChain chain) throws IOException, ServletException {
        auth.setCNAuthed(true);
        String reqUrl = CNFilter.getCurrentUrl(req);
        String collabNetUrl = securityRealm.getCollabNetUrl();
        String username = (String)auth.getPrincipal();
        String id = auth.getSessionId();
        String cnauthUrl = collabNetUrl + "/sf/sfmain/do/soapredirect?id=" + URLEncoder.encode(id, "UTF-8") + "&user=" + URLEncoder.encode(username, "UTF-8") + "&redirectUrl=" + URLEncoder.encode(reqUrl, "UTF-8");
        rsp.setStatus(302);
        rsp.setHeader("Location", cnauthUrl);
        chain.doFilter((ServletRequest)req, (ServletResponse)rsp);
    }

    public static String getCurrentBaseUrl(HttpServletRequest req) {
        StringBuilder url = new StringBuilder();
        String rootUrl = Hudson.getInstance().getRootUrl();
        if (rootUrl != null) {
            url.append(rootUrl);
        } else {
            url.append(req.getScheme());
            url.append("://");
            url.append(req.getServerName());
            if (req.getServerPort() != 80) {
                url.append(':').append(req.getServerPort());
            }
        }
        return url.toString();
    }

    public static String getCurrentUrl(HttpServletRequest req) {
        StringBuilder url = new StringBuilder(CNFilter.getCurrentBaseUrl(req));
        if (req.getContextPath() != null) {
            url.append(req.getContextPath());
        }
        if (req.getRequestURI() != null) {
            url.append(req.getRequestURI());
        }
        if (req.getQueryString() != null) {
            url.append("?" + req.getQueryString());
        }
        return url.toString();
    }

    public void destroy() {
    }
}

