/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.collabnet.filerelease;

import com.collabnet.ce.soap50.webservices.frs.FrsFileSoapDO;
import com.collabnet.ce.webservices.CollabNetApp;
import com.collabnet.ce.webservices.FrsApp;
import com.collabnet.ce.webservices.SimpleFileStorageApp;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Result;
import hudson.plugins.collabnet.filerelease.CnfrResultAction;
import hudson.plugins.collabnet.util.CNFormFieldValidator;
import hudson.plugins.collabnet.util.CNHudsonUtil;
import hudson.plugins.collabnet.util.ComboBoxUpdater;
import hudson.plugins.collabnet.util.CommonUtil;
import hudson.plugins.promoted_builds.Promotion;
import hudson.remoting.VirtualChannel;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Publisher;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Map;
import javax.activation.MimetypesFileTypeMap;
import javax.servlet.ServletException;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CNFileRelease
extends Publisher {
    private transient BuildListener listener = null;
    private static final String IMAGE_URL = "/plugin/collabnet/images/48x48/";
    private transient CollabNetApp cna = null;
    private String url;
    private String username;
    private String password;
    private String project;
    private String rpackage;
    private String release;
    private boolean overwrite;
    private String[] file_patterns;
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    public CNFileRelease(String url, String username, String password, String project, String rpackage, String release, boolean overwrite, String[] filePatterns) {
        this.url = url;
        this.username = username;
        this.password = password;
        this.project = project;
        this.rpackage = rpackage;
        this.release = release;
        this.overwrite = overwrite;
        this.file_patterns = filePatterns;
    }

    private void setupLogging(BuildListener listener) {
        this.listener = listener;
    }

    private void log(String message) {
        if (this.listener != null) {
            message = "CollabNet FileRelease: " + message;
            this.listener.getLogger().println(message);
        }
    }

    private void log(String methodName, RemoteException re) {
        this.log(methodName + " failed due to " + re.getClass().getName() + ": " + re.getMessage());
    }

    public String getCollabNetUrl() {
        return this.url;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getProject() {
        return this.project;
    }

    public String getPackage() {
        return this.rpackage;
    }

    public String getRelease() {
        return this.release;
    }

    public boolean overwrite() {
        return this.overwrite;
    }

    public String[] getFilePatterns() {
        if (this.file_patterns != null) {
            return this.file_patterns;
        }
        return new String[0];
    }

    public String[] getProjects() {
        CollabNetApp cna = CNHudsonUtil.getCollabNetApp(this.getCollabNetUrl(), this.getUsername(), this.getPassword());
        Collection<String> projects = ComboBoxUpdater.ProjectsUpdater.getProjectList(cna);
        CNHudsonUtil.logoff(cna);
        return projects.toArray(new String[0]);
    }

    public String[] getPackages() {
        CollabNetApp cna = CNHudsonUtil.getCollabNetApp(this.getCollabNetUrl(), this.getUsername(), this.getPassword());
        String projectId = CNHudsonUtil.getProjectId(cna, this.getProject());
        Collection<String> packages = ComboBoxUpdater.PackagesUpdater.getPackageList(cna, projectId);
        CNHudsonUtil.logoff(cna);
        return packages.toArray(new String[0]);
    }

    public String[] getReleases() {
        CollabNetApp cna = CNHudsonUtil.getCollabNetApp(this.getCollabNetUrl(), this.getUsername(), this.getPassword());
        String packageId = this.getPackageId(this.getProjectId());
        Collection<String> releases = ComboBoxUpdater.ReleasesUpdater.getReleaseList(cna, packageId);
        CNHudsonUtil.logoff(cna);
        return releases.toArray(new String[0]);
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) {
        this.setupLogging(listener);
        this.cna = CNHudsonUtil.getCollabNetApp(this.getCollabNetUrl(), this.getUsername(), this.getPassword());
        if (this.cna == null) {
            this.log("Critical Error: login to " + this.getCollabNetUrl() + " failed.  Setting build status to UNSTABLE (or worse).");
            Result previousBuildStatus = build.getResult();
            build.setResult(previousBuildStatus.combine(Result.UNSTABLE));
            build.addAction((Action)this.createAction(0, null));
            return false;
        }
        String releaseId = this.getReleaseId();
        if (releaseId == null) {
            Result previousBuildStatus = build.getResult();
            build.setResult(previousBuildStatus.combine(Result.UNSTABLE));
            this.logoff();
            build.addAction((Action)this.createAction(0, releaseId));
            return false;
        }
        int numUploaded = this.uploadFiles(build, releaseId);
        build.addAction((Action)this.createAction(numUploaded, releaseId));
        this.logoff();
        return true;
    }

    public CnfrResultAction createAction(int numUploaded, String releaseId) {
        String displaymsg = "Download from CollabNet File Release System";
        return new CnfrResultAction(displaymsg, "/plugin/collabnet/images/48x48/cn-icon.gif", "console", this.getFileReleaseUrl(releaseId), numUploaded);
    }

    private String getFileReleaseUrl(String releaseId) {
        String path = null;
        if (releaseId != null) {
            FrsApp fa = new FrsApp(this.cna);
            try {
                path = fa.getReleasePath(releaseId);
            }
            catch (RemoteException re) {
                this.log("get release path", re);
            }
        }
        if (path != null) {
            return this.getCollabNetUrl() + "/sf/frs/do/viewRelease/" + path;
        }
        return this.getCollabNetUrl();
    }

    private String getFileUrl(String path) {
        return this.getCollabNetUrl() + "/sf/frs/do/downloadFile/" + path;
    }

    public int uploadFiles(AbstractBuild<?, ?> build, final String releaseId) {
        int numUploaded = 0;
        final SimpleFileStorageApp sfsa = new SimpleFileStorageApp(this.cna);
        final FrsApp fa = new FrsApp(this.cna);
        this.log("Uploading file to project '" + this.getProject() + "', package '" + this.getPackage() + "', release '" + this.getRelease() + "' on host '" + this.getCollabNetUrl() + "' as user '" + this.getUsername() + "'.");
        for (String uninterp_fp : this.getFilePatterns()) {
            String file_pattern = "";
            try {
                file_pattern = this.getInterpreted(build, uninterp_fp);
            }
            catch (IllegalArgumentException e) {
                this.log("File pattern " + uninterp_fp + " contained a bad " + "env var.  Skipping.");
                continue;
            }
            if (file_pattern.equals("")) continue;
            this.log("Upload files matching " + file_pattern + ":");
            for (FilePath uploadFilePath : this.getFilePaths(build, file_pattern)) {
                String fileId = null;
                try {
                    fileId = fa.findFrsFile(uploadFilePath.getName(), releaseId);
                }
                catch (RemoteException re) {
                    this.log("find file", re);
                }
                if (fileId != null) {
                    if (this.overwrite()) {
                        try {
                            fa.deleteFrsFile(fileId);
                            this.log("Deleted previously uploaded file: " + uploadFilePath.getName());
                        }
                        catch (RemoteException re) {
                            this.log("delete file", re);
                        }
                    } else {
                        this.log("File " + uploadFilePath.getName() + " already exists in the file release " + "system and overwrite is set to false.  " + "Skipping.");
                        continue;
                    }
                }
                try {
                    String path = (String)uploadFilePath.act((FilePath.FileCallable)new FilePath.FileCallable<String>(){

                        public String invoke(File f, VirtualChannel channel) throws IOException, RemoteException {
                            String fileId = sfsa.uploadFile(f);
                            FrsFileSoapDO fileSoap = fa.createFrsFile(releaseId, f.getName(), CNFileRelease.getMimeType(f), fileId);
                            return fileSoap.getPath();
                        }
                    });
                    this.log("Uploaded file " + uploadFilePath.getName() + " -> " + this.getFileUrl(path));
                    ++numUploaded;
                }
                catch (RemoteException re) {
                    this.log("upload file", re);
                }
                catch (IOException ioe) {
                    this.log("Could not upload file due to IOException: " + ioe.getMessage());
                }
                catch (InterruptedException ie) {
                    this.log("Could not upload file due to InterruptedException: " + ie.getMessage());
                }
            }
        }
        return numUploaded;
    }

    private FilePath[] getFilePaths(AbstractBuild<?, ?> build, String pattern) {
        FilePath workspace = build.getProject().getWorkspace();
        FilePath[] uploadFilePaths = new FilePath[]{};
        try {
            uploadFilePaths = workspace.list(pattern);
        }
        catch (IOException ioe) {
            this.log("Could not list workspace due to IOException: " + ioe.getMessage());
        }
        catch (InterruptedException ie) {
            this.log("Could not list workspace due to InterruptedException: " + ie.getMessage());
        }
        return uploadFilePaths;
    }

    public static String getMimeType(File f) {
        return new MimetypesFileTypeMap().getContentType(f);
    }

    public void logoff() {
        if (this.cna != null) {
            CNHudsonUtil.logoff(this.cna);
            this.cna = null;
        } else {
            this.log("logoff failed. Not logged in!");
        }
    }

    public String getReleaseId() {
        String projectId = this.getProjectId();
        if (projectId == null) {
            this.log("Critical Error: projectId cannot be found for " + this.getProject() + ".  This could mean that the project " + "does not exist OR that the user logging in does not " + "have access to that project.  " + "Setting build status to UNSTABLE (or worse).");
            return null;
        }
        String packageId = this.getPackageId(projectId);
        if (packageId == null) {
            this.log("Critical Error: packageId cannot be found for " + this.getPackage() + ".  " + "Setting build status to UNSTABLE (or worse).");
            return null;
        }
        String releaseId = this.getReleaseId(packageId);
        if (releaseId == null) {
            this.log("Critical Error: releaseId cannot be found for " + this.getRelease() + ".  " + "Setting build status to UNSTABLE (or worse).");
            return null;
        }
        return releaseId;
    }

    public String getProjectId() {
        if (this.cna == null) {
            this.log("Cannot getProjectId, not logged in!");
            return null;
        }
        return CNHudsonUtil.getProjectId(this.cna, this.getProject());
    }

    public String getPackageId(String projectId) {
        if (this.cna == null) {
            this.log("Cannot getPackageId, not logged in!");
            return null;
        }
        return CNHudsonUtil.getPackageId(this.cna, this.getPackage(), projectId);
    }

    public String getReleaseId(String packageId) {
        if (this.cna == null) {
            this.log("Cannot getReleaseId, not logged in!");
            return null;
        }
        return CNHudsonUtil.getReleaseId(this.cna, packageId, this.getRelease());
    }

    private String getInterpreted(AbstractBuild<?, ?> build, String str) {
        Map envVars = null;
        if (Hudson.getInstance().getPlugin("promoted-builds") != null && build.getClass().equals(Promotion.class)) {
            Promotion promotion = (Promotion)Promotion.class.cast(build);
            envVars = promotion.getTarget().getEnvVars();
        } else {
            envVars = build.getEnvVars();
        }
        try {
            return CommonUtil.getInterpreted(envVars, str);
        }
        catch (IllegalArgumentException iae) {
            this.log(iae.getMessage());
            throw iae;
        }
    }

    public Descriptor<Publisher> getDescriptor() {
        return DESCRIPTOR;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        private static int unique = 0;

        DescriptorImpl() {
            super(CNFileRelease.class);
        }

        public synchronized int getUniqueId() {
            int return_value = unique++;
            if (unique >= Integer.MAX_VALUE) {
                unique = 0;
            }
            return return_value;
        }

        public String getDisplayName() {
            return "CollabNet File Release";
        }

        public static String getHelpUrl() {
            return "/plugin/collabnet/filerelease/";
        }

        public String getHelpFile() {
            return DescriptorImpl.getHelpUrl() + "help-main.html";
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public CNFileRelease newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            JSONObject[] jpats;
            Object fileData = formData.get("files");
            if (fileData instanceof JSONArray) {
                JSONArray patData = (JSONArray)fileData;
                jpats = (JSONObject[])JSONArray.toArray((JSONArray)patData, JSONObject.class);
            } else {
                jpats = fileData instanceof JSONObject ? new JSONObject[]{(JSONObject)fileData} : new JSONObject[]{};
            }
            String[] patterns = new String[jpats.length];
            for (int i = 0; i < jpats.length; ++i) {
                patterns[i] = (String)jpats[i].get("file");
            }
            return new CNFileRelease((String)formData.get("collabneturl"), (String)formData.get("username"), (String)formData.get("password"), (String)formData.get("project"), (String)formData.get("package"), (String)formData.get("release"), CommonUtil.getBoolean("overwrite", formData), patterns);
        }

        public void doCollabNetUrlCheck(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
            new CNFormFieldValidator.SoapUrlCheck(req, rsp).process();
        }

        public void doPasswordCheck(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
            new CNFormFieldValidator.LoginCheck(req, rsp).process();
        }

        public void doProjectCheck(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
            new CNFormFieldValidator.ProjectCheck(req, rsp).process();
        }

        public void doRequiredCheck(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
            new CNFormFieldValidator.RequiredCheck(req, rsp).process();
        }

        public void doPackageCheck(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
            new CNFormFieldValidator.PackageCheck(req, rsp).process();
        }

        public void doReleaseCheck(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
            new CNFormFieldValidator.ReleaseCheck(req, rsp).process();
        }

        public void doUnRequiredInterpretedCheck(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
            new CNFormFieldValidator.UnrequiredInterpretedCheck(req, rsp).process();
        }

        public void doGetProjects(StaplerRequest req, StaplerResponse rsp) throws IOException {
            new ComboBoxUpdater.ProjectsUpdater(req, rsp).update();
        }

        public void doGetPackages(StaplerRequest req, StaplerResponse rsp) throws IOException {
            new ComboBoxUpdater.PackagesUpdater(req, rsp).update();
        }

        public void doGetReleases(StaplerRequest req, StaplerResponse rsp) throws IOException {
            new ComboBoxUpdater.ReleasesUpdater(req, rsp).update();
        }
    }
}

