/*
 * Decompiled with CFR 0.152.
 */
package com.collabnet.ce.webservices;

import com.collabnet.ce.soap50.types.SoapFieldValues;
import com.collabnet.ce.soap50.types.SoapFilter;
import com.collabnet.ce.soap50.webservices.ClientSoapStubFactory;
import com.collabnet.ce.soap50.webservices.tracker.ArtifactSoapDO;
import com.collabnet.ce.soap50.webservices.tracker.ArtifactSoapList;
import com.collabnet.ce.soap50.webservices.tracker.ArtifactSoapRow;
import com.collabnet.ce.soap50.webservices.tracker.ITrackerAppSoap;
import com.collabnet.ce.soap50.webservices.tracker.TrackerSoapList;
import com.collabnet.ce.soap50.webservices.tracker.TrackerSoapRow;
import com.collabnet.ce.webservices.CollabNetApp;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Date;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrackerApp {
    private CollabNetApp collabNetApp;
    private ITrackerAppSoap itas;

    public TrackerApp(CollabNetApp collabNetApp) {
        this.collabNetApp = collabNetApp;
        this.itas = this.getITrackerAppSoap();
    }

    private ITrackerAppSoap getITrackerAppSoap() {
        String soapURL = this.getUrl() + CollabNetApp.SOAP_SERVICE + "TrackerApp?wsdl";
        return (ITrackerAppSoap)ClientSoapStubFactory.getSoapStub(ITrackerAppSoap.class, (String)soapURL);
    }

    public String getTrackerId(String projectId, String trackerName) throws RemoteException {
        this.checkValidSessionId();
        TrackerSoapList tslist = this.itas.getTrackerList(this.getSessionId(), projectId);
        for (TrackerSoapRow row : tslist.getDataRows()) {
            if (!row.getTitle().equals(trackerName)) continue;
            return row.getId();
        }
        return null;
    }

    public Collection<String> getTrackers(String projectId) throws RemoteException {
        this.checkValidSessionId();
        TreeSet<String> names = new TreeSet<String>();
        TrackerSoapList tslist = this.itas.getTrackerList(this.getSessionId(), projectId);
        for (TrackerSoapRow row : tslist.getDataRows()) {
            names.add(row.getTitle());
        }
        return names;
    }

    public ArtifactSoapDO findLastTrackerArtifact(String trackerId, String title) throws RemoteException {
        this.checkValidSessionId();
        SoapFilter[] filters = new SoapFilter[]{new SoapFilter("title", title)};
        ArtifactSoapList aslist = this.itas.getArtifactList(this.getSessionId(), trackerId, filters);
        ArtifactSoapRow latestRow = this.getLastSubmitted(aslist.getDataRows());
        if (latestRow != null) {
            return this.getArtifactDO(latestRow.getId());
        }
        return null;
    }

    public ArtifactSoapDO getArtifactDO(String artifactId) throws RemoteException {
        this.checkValidSessionId();
        return this.itas.getArtifactData(this.getSessionId(), artifactId);
    }

    private ArtifactSoapRow getLastSubmitted(ArtifactSoapRow[] rows) {
        if (rows.length < 1) {
            return null;
        }
        Date latest_date = rows[0].getSubmittedDate();
        int latest_index = 0;
        for (int index = 1; index < rows.length; ++index) {
            Date row_date = rows[index].getSubmittedDate();
            if (!row_date.after(latest_date)) continue;
            latest_date = row_date;
            latest_index = index;
        }
        return rows[latest_index];
    }

    public ArtifactSoapDO createNewTrackerArtifact(String trackerId, String title, String description, String group, String category, String status, String customer, int priority, int estimatedHours, String assignTo, String releaseId, SoapFieldValues flexFields, String fileName, String fileMimeType, String fileId) throws RemoteException {
        this.checkValidSessionId();
        return this.itas.createArtifact(this.getSessionId(), trackerId, title, description, group, category, status, customer, priority, estimatedHours, assignTo, releaseId, flexFields, fileName, fileMimeType, fileId);
    }

    public void setArtifactData(ArtifactSoapDO artifact, String comment, String fileName, String fileMimeType, String fileId) throws RemoteException {
        this.checkValidSessionId();
        this.itas.setArtifactData(this.getSessionId(), artifact, comment, fileName, fileMimeType, fileId);
    }

    private void checkValidSessionId() {
        this.collabNetApp.checkValidSessionId();
    }

    private String getSessionId() {
        return this.collabNetApp.getSessionId();
    }

    private String getUrl() {
        return this.collabNetApp.getServerUrl();
    }
}

