/*
 * Decompiled with CFR 0.152.
 */
package com.collabnet.ce.webservices;

import com.collabnet.ce.soap50.webservices.ClientSoapStubFactory;
import com.collabnet.ce.soap50.webservices.frs.FrsFileSoapDO;
import com.collabnet.ce.soap50.webservices.frs.FrsFileSoapList;
import com.collabnet.ce.soap50.webservices.frs.FrsFileSoapRow;
import com.collabnet.ce.soap50.webservices.frs.IFrsAppSoap;
import com.collabnet.ce.soap50.webservices.frs.PackageSoapList;
import com.collabnet.ce.soap50.webservices.frs.PackageSoapRow;
import com.collabnet.ce.soap50.webservices.frs.ReleaseSoapDO;
import com.collabnet.ce.soap50.webservices.frs.ReleaseSoapList;
import com.collabnet.ce.soap50.webservices.frs.ReleaseSoapRow;
import com.collabnet.ce.webservices.CollabNetApp;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FrsApp {
    private CollabNetApp collabNetApp;
    private IFrsAppSoap ifa;

    public FrsApp(CollabNetApp collabNetApp) {
        this.collabNetApp = collabNetApp;
        this.ifa = this.getFrsAppSoap();
    }

    private IFrsAppSoap getFrsAppSoap() {
        String soapURL = this.getUrl() + CollabNetApp.SOAP_SERVICE + "FrsApp?wsdl";
        return (IFrsAppSoap)ClientSoapStubFactory.getSoapStub(IFrsAppSoap.class, (String)soapURL);
    }

    public String findPackageId(String packageName, String projectId) throws RemoteException {
        this.checkValidSessionId();
        if (packageName == null || packageName.equals("")) {
            return null;
        }
        PackageSoapList psList = this.ifa.getPackageList(this.getSessionId(), projectId);
        for (PackageSoapRow prow : psList.getDataRows()) {
            if (!prow.getTitle().equals(packageName)) continue;
            return prow.getId();
        }
        return null;
    }

    public Collection<String> getPackages(String projectId) throws RemoteException {
        this.checkValidSessionId();
        PackageSoapList psList = this.ifa.getPackageList(this.getSessionId(), projectId);
        ArrayList<String> names = new ArrayList<String>();
        for (PackageSoapRow prow : psList.getDataRows()) {
            names.add(prow.getTitle());
        }
        return names;
    }

    public String findReleaseId(String releaseName, String projectId) throws RemoteException {
        PackageSoapRow prow;
        this.checkValidSessionId();
        if (releaseName == null || releaseName.equals("")) {
            return null;
        }
        PackageSoapList psList = this.ifa.getPackageList(this.getSessionId(), projectId);
        String matchingReleaseId = null;
        PackageSoapRow[] arr$ = psList.getDataRows();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && (matchingReleaseId = this.findReleaseIdByPackage(releaseName, (prow = arr$[i$]).getId())) == null; ++i$) {
        }
        return matchingReleaseId;
    }

    public Collection<String> getProjectReleases(String projectId) throws RemoteException {
        this.checkValidSessionId();
        TreeSet<String> names = new TreeSet<String>();
        PackageSoapList psList = this.ifa.getPackageList(this.getSessionId(), projectId);
        for (PackageSoapRow prow : psList.getDataRows()) {
            names.addAll(this.getReleases(prow.getId()));
        }
        return names;
    }

    public String findReleaseIdByPackage(String releaseName, String packageId) throws RemoteException {
        this.checkValidSessionId();
        if (releaseName == null || releaseName.equals("")) {
            return null;
        }
        ReleaseSoapList rsList = this.ifa.getReleaseList(this.getSessionId(), packageId);
        for (ReleaseSoapRow rrow : rsList.getDataRows()) {
            if (!rrow.getTitle().equals(releaseName)) continue;
            return rrow.getId();
        }
        return null;
    }

    public Collection<String> getReleases(String packageId) throws RemoteException {
        this.checkValidSessionId();
        ReleaseSoapList rsList = this.ifa.getReleaseList(this.getSessionId(), packageId);
        ArrayList<String> names = new ArrayList<String>();
        for (ReleaseSoapRow rrow : rsList.getDataRows()) {
            names.add(rrow.getTitle());
        }
        return names;
    }

    public String getReleasePath(String releaseId) throws RemoteException {
        this.checkValidSessionId();
        ReleaseSoapDO rsd = this.ifa.getReleaseData(this.getSessionId(), releaseId);
        return rsd.getPath();
    }

    public String findFrsFile(String name, String releaseId) throws RemoteException {
        this.checkValidSessionId();
        String fileId = null;
        FrsFileSoapList ffslist = this.ifa.getFrsFileList(this.getSessionId(), releaseId);
        for (FrsFileSoapRow row : ffslist.getDataRows()) {
            if (!row.getTitle().equals(name)) continue;
            fileId = row.getId();
            break;
        }
        return fileId;
    }

    public void deleteFrsFile(String fileId) throws RemoteException {
        this.checkValidSessionId();
        this.ifa.deleteFrsFile(this.getSessionId(), fileId);
    }

    public FrsFileSoapDO createFrsFile(String releaseId, String fileName, String mimeType, String fileId) throws RemoteException {
        this.checkValidSessionId();
        return this.ifa.createFrsFile(this.getSessionId(), releaseId, fileName, mimeType, fileId);
    }

    private void checkValidSessionId() {
        this.collabNetApp.checkValidSessionId();
    }

    private String getSessionId() {
        return this.collabNetApp.getSessionId();
    }

    private String getUrl() {
        return this.collabNetApp.getServerUrl();
    }
}

