/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.collabnet.auth;

import hudson.model.AbstractProject;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.plugins.collabnet.auth.CNConnection;
import hudson.plugins.collabnet.auth.CollabNetRole;
import hudson.plugins.promoted_builds.Promotion;
import hudson.security.ACL;
import hudson.security.Permission;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.acegisecurity.Authentication;

public class CNProjectACL
extends ACL {
    private String project;
    private String projectId = null;
    private static Logger log = Logger.getLogger("CNProjectACL");

    public CNProjectACL(String project) {
        this.project = project;
    }

    public String getProjectId(CNConnection conn) {
        if (this.projectId == null) {
            this.projectId = conn.getProjectId(this.project);
        }
        return this.projectId;
    }

    public boolean hasPermission(Authentication a, Permission permission) {
        CNConnection conn = CNConnection.getInstance(a);
        if (conn == null) {
            log.severe("Improper Authentication type used with CNAuthorizationStrategy!  CNAuthorization strategy cannot be used without CNAuthentication.  Please re-configure your Hudson instance.");
            return false;
        }
        String projId = this.getProjectId(conn);
        if (projId == null) {
            log.severe("hasPerission: project id could not be found for project: " + this.project + ".");
            return false;
        }
        Collection<CollabNetRole> userRoles = CollabNetRoles.getRoles(conn.getUserRoles(projId, conn.getUsername()));
        while (permission != null) {
            for (CollabNetRole role : userRoles) {
                if (!role.hasPermission(permission)) continue;
                return true;
            }
            permission = permission.impliedBy;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CollabNetRoles {
        private static Collection<CollabNetRole> roles = Collections.emptyList();

        public static CollabNetRole getRole(String name) {
            for (CollabNetRole role : CollabNetRoles.getAllRoles()) {
                if (!role.getName().equals(name)) continue;
                return role;
            }
            return null;
        }

        public static Collection<CollabNetRole> getRoles(Collection<String> names) {
            ArrayList<CollabNetRole> matchRoles = new ArrayList<CollabNetRole>();
            for (String name : names) {
                CollabNetRole role = CollabNetRoles.getRole(name);
                if (role == null) continue;
                matchRoles.add(role);
            }
            return matchRoles;
        }

        public static Collection<CollabNetRole> getAllRoles() {
            if (roles.isEmpty()) {
                roles = new ArrayList<CollabNetRole>();
                ArrayList<Permission> tempPermission = new ArrayList<Permission>();
                tempPermission.add(Hudson.READ);
                tempPermission.add(Item.READ);
                roles.add(new CollabNetRole("Hudson Read", "Allows users read-access to Hudson jobs.", tempPermission));
                tempPermission.clear();
                tempPermission.add(AbstractProject.BUILD);
                tempPermission.add(AbstractProject.ABORT);
                tempPermission.add(AbstractProject.WORKSPACE);
                tempPermission.add(Item.BUILD);
                roles.add(new CollabNetRole("Hudson Build/Cancel", "Allow users to start a new build, or to cancel a build.", tempPermission));
                tempPermission.clear();
                tempPermission.add(Item.CONFIGURE);
                roles.add(new CollabNetRole("Hudson Configure", "Allow users to configure a build.", tempPermission));
                tempPermission.clear();
                tempPermission.add(Item.DELETE);
                roles.add(new CollabNetRole("Hudson Delete", "Allow users to delete builds.", tempPermission));
                tempPermission.clear();
                if (Hudson.getInstance().getPlugin("promoted-builds") != null) {
                    Field[] promotionFields;
                    Field promote = null;
                    for (Field field : promotionFields = Promotion.class.getFields()) {
                        if (!field.getName().equals("PROMOTE")) continue;
                        promote = field;
                        break;
                    }
                    if (promote != null) {
                        Permission promotePermission = null;
                        try {
                            promotePermission = (Permission)promote.get(null);
                        }
                        catch (IllegalAccessException iae) {
                            // empty catch block
                        }
                        if (promotePermission != null) {
                            tempPermission.add(promotePermission);
                        }
                    }
                }
                roles.add(new CollabNetRole("Hudson Promote", "Allow users to promote builds.", tempPermission));
                tempPermission.clear();
            }
            return roles;
        }

        public static List<String> getNames() {
            ArrayList<String> names = new ArrayList<String>();
            for (CollabNetRole role : CollabNetRoles.getAllRoles()) {
                names.add(role.getName());
            }
            return names;
        }

        public static List<String> getDescriptions() {
            ArrayList<String> descriptions = new ArrayList<String>();
            for (CollabNetRole role : CollabNetRoles.getAllRoles()) {
                descriptions.add(role.getDescription());
            }
            return descriptions;
        }

        public static CollabNetRole getGrantingRole(Permission permission) {
            Collection<Permission> implyingPermissions = CollabNetRoles.expandPermissions(permission);
            for (CollabNetRole role : CollabNetRoles.getAllRoles()) {
                for (Permission p : implyingPermissions) {
                    if (!role.hasPermission(p)) continue;
                    return role;
                }
            }
            return null;
        }

        private static Collection<Permission> expandPermissions(Permission permission) {
            ArrayList<Permission> permissions = new ArrayList<Permission>();
            Permission p = permission;
            while (p != null) {
                permissions.add(p);
                p = permission.impliedBy;
            }
            return permissions;
        }
    }
}

