/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.collabnet.share;

import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.JobPropertyDescriptor;
import hudson.plugins.collabnet.util.CNFormFieldValidator;
import java.io.IOException;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TeamForgeShare
extends JobProperty<Job<?, ?>> {
    public TeamForgeShareDescriptor getDescriptor() {
        return (TeamForgeShareDescriptor)Hudson.getInstance().getDescriptor(((Object)((Object)this)).getClass());
    }

    public static TeamForgeShareDescriptor getTeamForgeShareDescriptor() {
        return (TeamForgeShareDescriptor)Hudson.getInstance().getDescriptor(TeamForgeShare.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class TeamForgeShareDescriptor
    extends JobPropertyDescriptor {
        private static Logger log = Logger.getLogger("TeamForgeShareDescriptor");
        private String collabNetUrl = null;
        private String username = null;
        private String password = null;
        private boolean useGlobal = false;

        public TeamForgeShareDescriptor() {
            super(TeamForgeShare.class);
            this.load();
        }

        public String getDisplayName() {
            return "Global CollabNet Teamforge Configuration";
        }

        public boolean isApplicable(Class<? extends Job> jobType) {
            return false;
        }

        public boolean configure(StaplerRequest staplerRequest, JSONObject json) throws Descriptor.FormException {
            if (json.has("useglobal")) {
                this.useGlobal = true;
                JSONObject config = json.getJSONObject("useglobal");
                this.collabNetUrl = config.getString("collabneturl");
                this.username = config.getString("username");
                this.password = config.getString("password");
            } else {
                this.useGlobal = false;
                this.collabNetUrl = null;
                this.username = null;
                this.password = null;
            }
            this.save();
            return true;
        }

        public boolean useGlobal() {
            return this.useGlobal;
        }

        public String getCollabNetUrl() {
            return this.collabNetUrl;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }

        public void doCollabNetUrlCheck(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
            new CNFormFieldValidator.SoapUrlCheck(req, rsp).process();
        }

        public void doRequiredCheck(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
            new CNFormFieldValidator.RequiredCheck(req, rsp).process();
        }

        public void doPasswordCheck(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
            new CNFormFieldValidator.LoginCheck(req, rsp).process();
        }
    }
}

