/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.collabnet.auth;

import hudson.model.Item;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.plugins.collabnet.auth.CNConnection;
import hudson.plugins.collabnet.auth.CNProjectACL;
import hudson.security.Permission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CNAuthProjectProperty
extends JobProperty<Job<?, ?>> {
    public static Permission CONFIGURE_PROPERTY = Item.CONFIGURE;
    private String project;
    private boolean createRoles = false;
    private boolean grantDefaultRoles = false;
    private static Logger log = Logger.getLogger("CNAuthProjectProperty");
    private static Collection<String> defaultAdminRoles = Collections.emptyList();
    private static Collection<String> defaultUserRoles = Collections.emptyList();

    public CNAuthProjectProperty(String project, Boolean createRoles, Boolean grantDefaults) {
        this.project = project;
        this.createRoles = createRoles;
        this.grantDefaultRoles = grantDefaults;
        if (this.createRoles || this.grantDefaultRoles) {
            this.loadRoles();
        }
    }

    public String getProject() {
        return this.project;
    }

    public boolean createRoles() {
        return this.createRoles;
    }

    public boolean grantDefaultRoles() {
        return this.grantDefaultRoles;
    }

    public Collection<String> getDefaultUserRoles() {
        if (defaultUserRoles.isEmpty()) {
            defaultUserRoles = new ArrayList();
            defaultUserRoles.add("Hudson Read");
        }
        return defaultUserRoles;
    }

    public Collection<String> getDefaultAdminRoles() {
        if (defaultAdminRoles.isEmpty()) {
            defaultAdminRoles = CNProjectACL.CollabNetRoles.getNames();
        }
        return defaultAdminRoles;
    }

    private void loadRoles() {
        if (this.getProject() != null && !this.getProject().equals("")) {
            CNConnection conn = CNConnection.getInstance();
            if (conn == null) {
                log.warning("Cannot loadRoles, incorrect authentication type.");
                return;
            }
            String projectId = conn.getProjectId(this.getProject());
            if (this.createRoles()) {
                List roleNames = CNProjectACL.CollabNetRoles.getNames();
                List descriptions = CNProjectACL.CollabNetRoles.getDescriptions();
                conn.addRoles(projectId, roleNames, descriptions);
            }
            if (this.grantDefaultRoles()) {
                conn.grantRoles(projectId, this.getDefaultUserRoles(), conn.getUsers(projectId));
                conn.grantRoles(projectId, this.getDefaultAdminRoles(), conn.getAdmins(projectId));
            }
        }
    }
}

