/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.collabnet.auth;

import com.collabnet.ce.webservices.CollabNetApp;
import com.collabnet.ce.webservices.RbacApp;
import hudson.model.Hudson;
import hudson.plugins.collabnet.auth.CNAuthentication;
import hudson.plugins.collabnet.auth.CNVersion;
import hudson.plugins.collabnet.util.CNHudsonUtil;
import hudson.plugins.collabnet.util.ComboBoxUpdater;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.acegisecurity.Authentication;
import org.acegisecurity.GrantedAuthority;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class CNConnection {
    private CNAuthentication auth;
    private static Logger log = Logger.getLogger("CNConnection");

    private CNConnection(CNAuthentication a) {
        this.auth = a;
    }

    public static CNConnection getInstance() {
        return CNConnection.getInstance((Authentication)Hudson.getAuthentication());
    }

    public static CNConnection getInstance(Authentication a) {
        if (a instanceof CNAuthentication) {
            return new CNConnection((CNAuthentication)a);
        }
        return null;
    }

    public CollabNetApp getCollabNetApp() {
        Object creds = this.getAuth().getCredentials();
        if (creds instanceof CollabNetApp) {
            return (CollabNetApp)creds;
        }
        throw new IllegalStateException("Credentials are incorrect type for CollabNetAutorization: " + creds.getClass().getName());
    }

    public static CNVersion getVersion(String url) {
        String version = null;
        CNVersion cnversion = null;
        try {
            version = CollabNetApp.getApiVersion((String)url);
        }
        catch (RemoteException re) {
            log.info("getVersion: failed with RemoteException: " + re.getMessage());
            return cnversion;
        }
        try {
            cnversion = new CNVersion(version);
        }
        catch (IllegalArgumentException iae) {
            log.severe("getVersion: unexpected error when attempting to parse CollabNet version: " + iae.getMessage());
            return cnversion;
        }
        return cnversion;
    }

    public String getUsername() {
        Object principal = this.getAuth().getPrincipal();
        if (principal instanceof String) {
            return (String)principal;
        }
        throw new IllegalStateException("Pricipal is incorrect type for CollabNetAutorization: " + principal.getClass().getName());
    }

    public CNAuthentication getAuth() {
        return this.auth;
    }

    public boolean isMemberOfAny(Collection<String> groups) {
        for (String group : groups) {
            if (!this.getAuth().isMember(group)) continue;
            return true;
        }
        return false;
    }

    public boolean isSuperUser() {
        GrantedAuthority[] authorities;
        for (GrantedAuthority authority : authorities = this.getAuth().getAuthorities()) {
            if (!authority.getAuthority().equals("SuperUser")) continue;
            return true;
        }
        return false;
    }

    public boolean isProjectAdmin(String projectId) {
        boolean admin = false;
        try {
            admin = this.getCollabNetApp().isUserProjectAdmin(this.getUsername(), projectId);
        }
        catch (RemoteException re) {
            log.info("isProjectAdmin: failed with RemoteException: " + re.getMessage());
        }
        return admin;
    }

    public String getProjectId(String project) {
        return CNHudsonUtil.getProjectId((CollabNetApp)this.getCollabNetApp(), (String)project);
    }

    public Collection<String> getProjects() {
        return ComboBoxUpdater.ProjectsUpdater.getProjectList((CollabNetApp)this.getCollabNetApp());
    }

    public Collection<String> getUserRoles(String projectId, String username) {
        ArrayList<String> roles = new ArrayList();
        RbacApp ra = new RbacApp(this.getCollabNetApp());
        try {
            roles = ra.getUserRoles(projectId, username);
        }
        catch (RemoteException re) {
            log.severe("getUserRoles: failed with Remote Exception while getting roles for user " + username + ": " + re.getMessage());
        }
        return roles;
    }

    public Collection<String> getUsers(String projectId) {
        return ComboBoxUpdater.UsersUpdater.getUserList((CollabNetApp)this.getCollabNetApp(), (String)projectId);
    }

    public boolean isUsernameValid(String username) {
        return CNHudsonUtil.isUserValid((CollabNetApp)this.getCollabNetApp(), (String)username);
    }

    public boolean isGroupnameValid(String group) {
        boolean valid = false;
        try {
            valid = this.getCollabNetApp().getGroups().containsKey(group);
        }
        catch (RemoteException re) {
            log.severe("isGroupnameValid: failed with RemoteException " + re.getMessage());
        }
        return valid;
    }

    public Collection<String> getAdmins(String projectId) {
        List<String> admins = Collections.emptyList();
        try {
            admins = this.getCollabNetApp().getAdmins(projectId);
        }
        catch (RemoteException re) {
            log.severe("getAdmins: failed with RemoteException " + re.getMessage());
        }
        return admins;
    }

    public boolean addRoles(String projectId, List<String> roleNames, List<String> descriptions) {
        boolean added = false;
        RbacApp ra = new RbacApp(this.getCollabNetApp());
        try {
            added = ra.addRoles(projectId, roleNames.toArray(new String[0]), descriptions.toArray(new String[0]));
        }
        catch (RemoteException re) {
            log.severe("addRoles: failed with RemoteException: " + re.getMessage());
        }
        return added;
    }

    public void grantRoles(String projectId, Collection<String> roles, Collection<String> usernames) {
        RbacApp ra = new RbacApp(this.getCollabNetApp());
        for (String username : usernames) {
            for (String role : roles) {
                try {
                    ra.grantRole(projectId, role, username);
                }
                catch (RemoteException re) {
                    log.severe("grantRoles: failed with RemoteException: " + re.getMessage());
                }
            }
        }
    }
}

